/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.utility;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.configuration.ConfigManager;
import me.athlaeos.valhallammo.utility.StringUtils;
import me.athlaeos.valhallammo.utility.Utils;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class GlobalEffect
extends BukkitRunnable {
    private static GlobalEffect runnable = null;
    private static final Map<String, EffectProperties> activeGlobalEffects = new HashMap<String, EffectProperties>();
    private static final Collection<String> validEffects = new HashSet<String>();
    private static final int globalbuff_bossbar_duration = ConfigManager.getConfig("config.yml").reload().get().getInt("globalbuff_bossbar_duration", 10);
    private static final int globalbuff_cycle_pause = ConfigManager.getConfig("config.yml").reload().get().getInt("globalbuff_cycle_pause", 300);
    private static List<EffectProperties> currentLoopEffects = new ArrayList<EffectProperties>();
    private static int currentLoopIndex = 0;
    private static final BossBar bossBar = ValhallaMMO.getInstance().getServer().createBossBar("", BarColor.BLUE, BarStyle.SOLID, new BarFlag[0]);
    private static int timer = 0;
    private static final Collection<Player> temporarilyExcludePlayers = new HashSet<Player>();

    public static void initializeRunnable() {
        if (runnable != null) {
            runnable.cancel();
        }
        runnable = new GlobalEffect();
        runnable.runTaskTimer((Plugin)ValhallaMMO.getInstance(), 1L, 20L);
    }

    public void run() {
        if (timer == 0) {
            currentLoopEffects = activeGlobalEffects.values().stream().filter(effectProperties -> effectProperties.bossBar != null && GlobalEffect.isActive(effectProperties.effect)).collect(Collectors.toList());
        }
        if (!currentLoopEffects.isEmpty()) {
            if (currentLoopIndex < currentLoopEffects.size()) {
                EffectProperties currentEffect = currentLoopEffects.get(currentLoopIndex);
                long l = GlobalEffect.getDuration(currentEffect.effect);
                long lastsFor = l == -1L ? -1L : Math.max(0L, l);
                long originalDuration = GlobalEffect.getOriginalDuration(currentEffect.effect);
                ValhallaMMO.getInstance().getServer().getOnlinePlayers().forEach(player -> {
                    if (!temporarilyExcludePlayers.contains(player)) {
                        bossBar.addPlayer(player);
                    }
                });
                bossBar.setTitle(Utils.chat(currentEffect.bossBar.replace("%time%", StringUtils.toTimeStamp2(lastsFor, 1000L)).replace("%time2%", StringUtils.toTimeStamp(lastsFor, 1000L))));
                bossBar.setColor(currentEffect.color);
                bossBar.setStyle(currentEffect.style);
                if (originalDuration > 0L) {
                    bossBar.setProgress(Math.max(0.0, Math.min(1.0, (double)lastsFor / (double)originalDuration)));
                }
                if (timer >= (currentLoopIndex + 1) * globalbuff_bossbar_duration) {
                    ++currentLoopIndex;
                }
            } else {
                new ArrayList<Player>(bossBar.getPlayers()).forEach(player -> {
                    if (!temporarilyExcludePlayers.contains(player)) {
                        bossBar.removePlayer(player);
                    }
                });
            }
            if (++timer >= globalbuff_cycle_pause + currentLoopEffects.size() * globalbuff_bossbar_duration) {
                timer = 0;
                currentLoopIndex = 0;
            }
        }
    }

    public static void temporarilyRevealBossBar(final Player p) {
        temporarilyExcludePlayers.add(p);
        new BukkitRunnable(){
            private List<EffectProperties> currentLoopEffects = new ArrayList<EffectProperties>();
            private int currentLoopIndex = 0;
            private int timer = 0;

            public void run() {
                if (!p.isOnline()) {
                    temporarilyExcludePlayers.remove(p);
                    this.cancel();
                    return;
                }
                if (this.timer == 0) {
                    this.currentLoopEffects = activeGlobalEffects.values().stream().filter(effectProperties -> effectProperties.bossBar != null && GlobalEffect.isActive(effectProperties.effect)).collect(Collectors.toList());
                    if (this.currentLoopEffects.isEmpty()) {
                        temporarilyExcludePlayers.remove(p);
                        this.cancel();
                        return;
                    }
                }
                if (this.currentLoopIndex < this.currentLoopEffects.size()) {
                    EffectProperties currentEffect = this.currentLoopEffects.get(this.currentLoopIndex);
                    long l = GlobalEffect.getDuration(currentEffect.effect);
                    long lastsFor = l == -1L ? -1L : Math.max(0L, l);
                    long originalDuration = GlobalEffect.getDuration(currentEffect.effect);
                    bossBar.addPlayer(p);
                    bossBar.setTitle(Utils.chat(currentEffect.bossBar.replace("%time%", StringUtils.toTimeStamp2(lastsFor, 1000L)).replace("%time2%", StringUtils.toTimeStamp(lastsFor, 1000L))));
                    bossBar.setColor(currentEffect.color);
                    bossBar.setStyle(currentEffect.style);
                    if (originalDuration > 0L) {
                        bossBar.setProgress(Math.max(0.0, Math.min(1.0, (double)lastsFor / (double)originalDuration)));
                    }
                    if (this.timer >= (this.currentLoopIndex + 1) * globalbuff_bossbar_duration) {
                        ++this.currentLoopIndex;
                    }
                } else {
                    bossBar.removeAll();
                }
                ++this.timer;
                if (this.timer >= this.currentLoopEffects.size() * globalbuff_bossbar_duration) {
                    temporarilyExcludePlayers.remove(p);
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)ValhallaMMO.getInstance(), 1L, 20L);
    }

    public static void saveActiveGlobalEffects() {
        YamlConfiguration config = ConfigManager.getConfig("global_effects.yml").reload().get();
        ConfigurationSection section = config.getConfigurationSection("active_effects");
        if (section != null) {
            section.getKeys(false).forEach(s -> config.set("active_effects." + s, null));
        }
        for (String s2 : activeGlobalEffects.keySet()) {
            EffectProperties details = activeGlobalEffects.get(s2);
            if (details.effectiveUntil != -1L && details.effectiveUntil < System.currentTimeMillis()) continue;
            config.set("active_effects." + s2 + ".lasts_until", (Object)details.effectiveUntil);
            config.set("active_effects." + s2 + ".original_duration", (Object)details.getOriginalLength());
            config.set("active_effects." + s2 + ".amplifier", (Object)details.amplifier);
            if (details.bossBar == null) continue;
            config.set("active_effects." + s2 + ".boss_bar", (Object)details.bossBar);
            config.set("active_effects." + s2 + ".bar_color", (Object)details.color.toString());
            config.set("active_effects." + s2 + ".bar_style", (Object)details.style.toString());
        }
        ConfigManager.saveConfig("global_effects.yml");
    }

    public static void loadActiveGlobalEffects() {
        YamlConfiguration config = ConfigManager.getConfig("global_effects.yml").reload().get();
        ConfigurationSection section = config.getConfigurationSection("active_effects");
        if (section != null) {
            for (String effect : section.getKeys(false)) {
                long lasts_until = config.getLong("active_effects." + effect + ".lasts_until");
                if (lasts_until != -1L && lasts_until < System.currentTimeMillis()) continue;
                long original_duration = config.getLong("active_effects." + effect + ".original_duration");
                double amplifier = config.getDouble("active_effects." + effect + ".amplifier");
                String bossBar = config.getString("active_effects." + effect + ".boss_bar");
                if (bossBar != null) {
                    try {
                        BarColor color = BarColor.valueOf((String)config.getString("active_effects." + effect + ".bar_color"));
                        BarStyle style = BarStyle.valueOf((String)config.getString("active_effects." + effect + ".bar_style"));
                        activeGlobalEffects.put(effect, new EffectProperties(effect, original_duration, lasts_until, amplifier, bossBar, color, style));
                    }
                    catch (IllegalArgumentException ignored) {
                        ValhallaMMO.logWarning("Invalid BarColor or BarStyle for " + effect + " in global_effects.yml");
                    }
                    continue;
                }
                activeGlobalEffects.put(effect, new EffectProperties(effect, original_duration, lasts_until, amplifier, null, null, null));
            }
        }
    }

    public static void addEffect(String effect, long duration, double amplifier, EffectAdditionMode mode, String bossBar, BarColor barColor, BarStyle barStyle) {
        double existingAmplifier = GlobalEffect.getAmplifier(effect);
        long existingDuration = GlobalEffect.getDuration(effect);
        long originalDuration = GlobalEffect.getOriginalDuration(effect);
        if (originalDuration == 0L) {
            originalDuration = duration;
        }
        switch (mode.ordinal()) {
            case 3: {
                existingAmplifier += amplifier;
                if (existingDuration == -1L) break;
                existingDuration += duration;
                break;
            }
            case 1: {
                existingAmplifier = amplifier;
                if (existingDuration == -1L) break;
                existingDuration += duration;
                break;
            }
            case 2: {
                existingAmplifier += amplifier;
                existingDuration = duration;
                break;
            }
            case 0: {
                existingAmplifier = amplifier;
                existingDuration = duration;
            }
        }
        if (existingDuration != -1L) {
            originalDuration = Math.max(existingDuration, originalDuration);
            existingDuration += System.currentTimeMillis();
        } else {
            originalDuration = -1L;
        }
        timer = 0;
        currentLoopIndex = 0;
        activeGlobalEffects.put(effect, new EffectProperties(effect, originalDuration, existingDuration, existingAmplifier, bossBar, barColor, barStyle));
    }

    public static boolean isActive(String buff) {
        if (activeGlobalEffects.containsKey(buff)) {
            if (GlobalEffect.activeGlobalEffects.get((Object)buff).effectiveUntil == -1L) {
                return true;
            }
            return GlobalEffect.activeGlobalEffects.get((Object)buff).effectiveUntil > System.currentTimeMillis();
        }
        return false;
    }

    public static long getDuration(String buff) {
        if (GlobalEffect.isActive(buff)) {
            if (GlobalEffect.activeGlobalEffects.get((Object)buff).effectiveUntil == -1L) {
                return -1L;
            }
            return Math.max(0L, GlobalEffect.activeGlobalEffects.get((Object)buff).effectiveUntil - System.currentTimeMillis());
        }
        return 0L;
    }

    public static long getOriginalDuration(String buff) {
        if (GlobalEffect.isActive(buff)) {
            if (activeGlobalEffects.get(buff).getOriginalLength() == -1L) {
                return -1L;
            }
            return Math.max(0L, activeGlobalEffects.get(buff).getOriginalLength());
        }
        return 0L;
    }

    public static String getBossBarTitle(String buff) {
        if (GlobalEffect.isActive(buff)) {
            return GlobalEffect.activeGlobalEffects.get((Object)buff).bossBar;
        }
        return null;
    }

    public static double getAmplifier(String buff) {
        if (GlobalEffect.isActive(buff)) {
            return Math.max(0.0, GlobalEffect.activeGlobalEffects.get((Object)buff).amplifier);
        }
        return 0.0;
    }

    public static Collection<String> getValidEffects() {
        return validEffects;
    }

    public static void addValidEffect(String effect) {
        validEffects.add(effect);
    }

    public static void removeValidEffect(String effect) {
        validEffects.remove(effect);
    }

    public static Map<String, EffectProperties> getActiveGlobalEffects() {
        return activeGlobalEffects;
    }

    public static class EffectProperties {
        private final String effect;
        private final long effectiveUntil;
        private long originalLength;
        private final double amplifier;
        private final String bossBar;
        private final BarColor color;
        private final BarStyle style;

        public EffectProperties(String effect, long originalLength, long effectiveUntil, double amplifier, String bossBar, BarColor color, BarStyle style) {
            this.effect = effect;
            this.originalLength = originalLength;
            this.effectiveUntil = effectiveUntil;
            this.amplifier = amplifier;
            this.bossBar = bossBar;
            this.color = color;
            this.style = style;
        }

        public long getOriginalLength() {
            return this.originalLength;
        }

        public void setOriginalLength(long originalLength) {
            this.originalLength = originalLength;
        }
    }

    public static enum EffectAdditionMode {
        OVERWRITE,
        ADDITIVE_DURATION,
        ADDITIVE_AMPLIFIER,
        ADDITIVE_BOTH;

    }
}

