/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.utility;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import me.athlaeos.valhallammo.utility.Utils;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class MathUtils {
    private static final double HAND_ANGLE = 0.7853981633974483;
    private static final double HAND_RADIUS = 0.4;
    private static final Map<Double, Double> cosCache = new HashMap<Double, Double>();
    private static final Map<Double, Double> sinCache = new HashMap<Double, Double>();
    private static final Map<Double, Double> tanCache = new HashMap<Double, Double>();
    private static final Map<Double, Double> radiansCache = new HashMap<Double, Double>();
    private static final Map<Double, Double> powCache = new HashMap<Double, Double>();
    private static final Map<Double, Double> sqrtCache = new HashMap<Double, Double>();

    public static Collection<Location> getRandomPointsInArea(Location center, double radius, int count) {
        HashSet<Location> locations = new HashSet<Location>();
        double minX = center.getX() - radius;
        double minY = center.getY() - radius;
        double minZ = center.getZ() - radius;
        double maxX = center.getX() + radius;
        double maxY = center.getY() + radius;
        double maxZ = center.getZ() + radius;
        for (int i = 0; i < count; ++i) {
            double randomX = minX + (maxX - minX) * Utils.getRandom().nextDouble();
            double randomY = minY + (maxY - minY) * Utils.getRandom().nextDouble();
            double randomZ = minZ + (maxZ - minZ) * Utils.getRandom().nextDouble();
            locations.add(new Location(center.getWorld(), randomX, randomY, randomZ));
        }
        return locations;
    }

    public static double pitchDegrees(double x, double y, double z) {
        return Math.toDegrees(MathUtils.pitchRadians(x, y, z));
    }

    public static double pitchDegrees(Vector v) {
        return MathUtils.pitchDegrees(v.getX(), v.getY(), v.getZ());
    }

    public static double pitchRadians(Vector v) {
        return MathUtils.pitchRadians(v.getX(), v.getY(), v.getZ());
    }

    public static double pitchRadians(double x, double y, double z) {
        double xz = MathUtils.sqrt(x * x + z * z);
        return Math.atan2(-y, xz);
    }

    public static Vector getHandOffset(Player player, boolean hand) {
        double a = Math.toRadians(player.getEyeLocation().getYaw());
        double p = hand ? 1.0 : -1.0;
        double x = 0.4 * Math.cos(a + 1.5707963267948966 + p * 0.7853981633974483);
        double z = 0.4 * Math.sin(a + 1.5707963267948966 + p * 0.7853981633974483);
        return new Vector(x, 0.0, z);
    }

    public static Collection<Location> getRandomPointsInPlane(Location center, double radius, int count) {
        HashSet<Location> locations = new HashSet<Location>();
        double minX = center.getX() - radius;
        double minZ = center.getZ() - radius;
        double maxX = center.getX() + radius;
        double maxZ = center.getZ() + radius;
        for (int i = 0; i < count; ++i) {
            double randomX = minX + (maxX - minX) * Utils.getRandom().nextDouble();
            double randomZ = minZ + (maxZ - minZ) * Utils.getRandom().nextDouble();
            locations.add(new Location(center.getWorld(), randomX, center.getY(), randomZ));
        }
        return locations;
    }

    public static Collection<Location> getRandomPointsInCircle(Location center, double radius, int amount, boolean includeCenter) {
        World world = center.getWorld();
        HashSet<Location> locations = new HashSet<Location>();
        for (int i = 1; i < amount + 1; ++i) {
            double theta = Utils.getRandom().nextDouble() * 2.0 * Math.PI;
            double x = center.getX() + radius * Math.cos(theta);
            double z = center.getZ() + radius * Math.sin(theta);
            locations.add(new Location(world, x, center.getY(), z));
        }
        if (includeCenter) {
            locations.add(center);
        }
        return locations;
    }

    public static Collection<Location> getEvenCircle(Location center, double radius, int amount, double addAngle) {
        World world = center.getWorld();
        HashSet<Location> locations = new HashSet<Location>();
        for (double i = 0.0; i < (double)amount; i += 1.0) {
            double angle = Math.toRadians(i / (double)amount * 360.0) + Math.toRadians(addAngle * 360.0);
            double x = center.getX() + Math.cos(angle) * radius;
            double z = center.getZ() + Math.sin(angle) * radius;
            locations.add(new Location(world, x, center.getY(), z));
        }
        return locations;
    }

    public static void transformExistingPoints(Location center, double yaw, double pitch, double roll, double scale, Collection<Location> points) {
        yaw = Math.toRadians(yaw);
        pitch = Math.toRadians(pitch);
        roll = Math.toRadians(roll);
        double cp = MathUtils.cos(pitch);
        double sp = MathUtils.sin(pitch);
        double cy = MathUtils.cos(yaw);
        double sy = MathUtils.sin(yaw);
        double cr = MathUtils.cos(roll);
        double sr = MathUtils.sin(roll);
        MathUtils.transformExistingPointsPredefined(center, cp, sp, cy, sy, cr, sr, 1.0, points);
    }

    public static void transformExistingPointsPredefined(Location center, double cp, double sp, double cy, double sy, double cr, double sr, double scale, Collection<Location> points) {
        for (Location point : points) {
            double z;
            double y;
            double x;
            double bx = x = point.getX() - center.getX();
            double by = y = point.getY() - center.getY();
            double bz = z = point.getZ() - center.getZ();
            x = ((x * cy - bz * sy) * cr + by * sr) * scale;
            y = ((y * cp + bz * sp) * cr - bx * sr) * scale;
            z = ((z * cp - by * sp) * cy + bx * sy) * scale;
            point.setX(center.getX() + x);
            point.setY(center.getY() + y);
            point.setZ(center.getZ() + z);
        }
    }

    public static double cos(double d) {
        if (cosCache.containsKey(d)) {
            return cosCache.get(d);
        }
        double result = Math.cos(d);
        cosCache.put(d, result);
        return result;
    }

    public static double sin(double d) {
        if (sinCache.containsKey(d)) {
            return sinCache.get(d);
        }
        double result = Math.sin(d);
        sinCache.put(d, result);
        return result;
    }

    public static double tan(double d) {
        if (tanCache.containsKey(d)) {
            return tanCache.get(d);
        }
        double result = Math.tan(d);
        tanCache.put(d, result);
        return result;
    }

    public static double toRadians(double d) {
        if (radiansCache.containsKey(d)) {
            return radiansCache.get(d);
        }
        double result = Math.toRadians(d);
        radiansCache.put(d, result);
        return result;
    }

    public static double pow(double d, double pow) {
        if (powCache.containsKey(d)) {
            return powCache.get(d);
        }
        double result = Math.pow(d, pow);
        powCache.put(d, result);
        return result;
    }

    public static double sqrt(double d) {
        if (sqrtCache.containsKey(d)) {
            return sqrtCache.get(d);
        }
        double result = Math.sqrt(d);
        sqrtCache.put(d, result);
        return result;
    }

    public static Collection<Location> getCubeWithLines(Location center, int lineDensity, double radius) {
        HashSet<Location> square = new HashSet<Location>();
        Location p1 = new Location(center.getWorld(), center.getX() - radius, center.getY() - radius, center.getZ() - radius);
        Location p2 = new Location(center.getWorld(), center.getX() - radius, center.getY() - radius, center.getZ() + radius);
        Location p3 = new Location(center.getWorld(), center.getX() - radius, center.getY() + radius, center.getZ() - radius);
        Location p4 = new Location(center.getWorld(), center.getX() - radius, center.getY() + radius, center.getZ() + radius);
        Location p5 = new Location(center.getWorld(), center.getX() + radius, center.getY() - radius, center.getZ() - radius);
        Location p6 = new Location(center.getWorld(), center.getX() + radius, center.getY() - radius, center.getZ() + radius);
        Location p7 = new Location(center.getWorld(), center.getX() + radius, center.getY() + radius, center.getZ() - radius);
        Location p8 = new Location(center.getWorld(), center.getX() + radius, center.getY() + radius, center.getZ() + radius);
        square.addAll(MathUtils.getPointsInLine(p1, p2, lineDensity));
        square.addAll(MathUtils.getPointsInLine(p1, p3, lineDensity));
        square.addAll(MathUtils.getPointsInLine(p2, p4, lineDensity));
        square.addAll(MathUtils.getPointsInLine(p3, p4, lineDensity));
        square.addAll(MathUtils.getPointsInLine(p5, p6, lineDensity));
        square.addAll(MathUtils.getPointsInLine(p5, p7, lineDensity));
        square.addAll(MathUtils.getPointsInLine(p6, p8, lineDensity));
        square.addAll(MathUtils.getPointsInLine(p7, p8, lineDensity));
        square.addAll(MathUtils.getPointsInLine(p1, p5, lineDensity));
        square.addAll(MathUtils.getPointsInLine(p2, p6, lineDensity));
        square.addAll(MathUtils.getPointsInLine(p3, p7, lineDensity));
        square.addAll(MathUtils.getPointsInLine(p4, p8, lineDensity));
        return square;
    }

    public static List<Location> getPointsInLine(Location point1, Location point2, int amount) {
        double xStep = (point1.getX() - point2.getX()) / (double)amount;
        double yStep = (point1.getY() - point2.getY()) / (double)amount;
        double zStep = (point1.getZ() - point2.getZ()) / (double)amount;
        ArrayList<Location> points = new ArrayList<Location>();
        for (int i = 0; i < amount + 1; ++i) {
            points.add(new Location(point1.getWorld(), point1.getX() - xStep * (double)i, point1.getY() - yStep * (double)i, point1.getZ() - zStep * (double)i));
        }
        return points;
    }

    public static int[][] getOffsetsBetweenPoints(int[] offset1, int[] offset2, int[] ... append) {
        int xOff = Math.abs(offset1[0] - offset2[0]) + 1;
        int yOff = Math.abs(offset1[1] - offset2[1]) + 1;
        int zOff = Math.abs(offset1[2] - offset2[2]) + 1;
        int arraySize = Math.abs(xOff) * Math.abs(yOff) * Math.abs(zOff) + append.length;
        int[][] offsets = new int[arraySize][3];
        int index = 0;
        for (int x = offset1[0]; x <= offset2[0]; ++x) {
            for (int y = offset1[1]; y <= offset2[1]; ++y) {
                int z = offset1[2];
                while (z <= offset2[2]) {
                    offsets[index] = new int[]{x, y, z++};
                    ++index;
                }
            }
        }
        for (int i = 1; i <= append.length; ++i) {
            offsets[arraySize - i] = append[i];
        }
        return offsets;
    }
}

