/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.utility;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.configuration.ConfigManager;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.playerstats.AccumulativeStatManager;
import me.athlaeos.valhallammo.utility.StringUtils;
import me.athlaeos.valhallammo.utility.Utils;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Timer {
    private static final Map<String, Map<UUID, Long>> allCooldowns = new HashMap<String, Map<UUID, Long>>();
    private static final Map<String, Map<UUID, Long>> allTimers = new HashMap<String, Map<UUID, Long>>();
    private static final Map<String, Map<UUID, Long>> allTimersNanos = new HashMap<String, Map<UUID, Long>>();
    private static final Map<UUID, BukkitRunnable> cooldownStatusRunnables = new HashMap<UUID, BukkitRunnable>();

    public static void setCooldown(UUID entity, int timems, String cooldownKey) {
        if (!allCooldowns.containsKey(cooldownKey)) {
            allCooldowns.put(cooldownKey, new HashMap());
        }
        allCooldowns.get(cooldownKey).put(entity, System.currentTimeMillis() + (long)timems);
    }

    public static void setCooldownIgnoreIfPermission(Entity entity, int timems, String cooldownKey) {
        if (!entity.hasPermission("valhalla.ignorecooldowns")) {
            double cooldownReduction = AccumulativeStatManager.getCachedStats("COOLDOWN_REDUCTION", entity, 10000L, true);
            int newCooldown = Math.max(0, (int)((double)timems * (1.0 - cooldownReduction)));
            Timer.setCooldown(entity.getUniqueId(), newCooldown, cooldownKey);
        }
    }

    public static void sendCooldownStatus(final Player player, final String cooldownKey, final String type) {
        final int ticks = ConfigManager.getConfig("config.yml").get().getInt("cooldown_status_duration", 0);
        if (ticks > 0) {
            BukkitRunnable existingRunnable = cooldownStatusRunnables.get(player.getUniqueId());
            if (existingRunnable != null) {
                existingRunnable.cancel();
            }
            existingRunnable = new BukkitRunnable(){
                int ticksRemaining;
                {
                    this.ticksRemaining = ticks;
                }

                public void run() {
                    long remainingCooldown = Timer.getCooldown(player.getUniqueId(), cooldownKey);
                    Utils.sendActionBar(player, TranslationManager.getTranslation("status_cooldown").replace("%type%", type).replace("%timestamp%", StringUtils.toTimeStamp(remainingCooldown, 1000L)).replace("%timestamp2%", StringUtils.toTimeStamp2(remainingCooldown, 1000L, true)));
                    if (this.ticksRemaining < 0 || remainingCooldown <= 0L || !player.isOnline()) {
                        this.cancel();
                        cooldownStatusRunnables.remove(player.getUniqueId());
                        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(""));
                    }
                    --this.ticksRemaining;
                }
            };
            existingRunnable.runTaskTimer((Plugin)ValhallaMMO.getInstance(), 1L, 1L);
            cooldownStatusRunnables.put(player.getUniqueId(), existingRunnable);
        } else if (ticks == 0) {
            long remainingCooldown = Timer.getCooldown(player.getUniqueId(), cooldownKey);
            Utils.sendActionBar(player, TranslationManager.getTranslation("status_cooldown").replace("%type%", type).replace("%timestamp%", StringUtils.toTimeStamp(remainingCooldown, 1000L)).replace("%timestamp2%", StringUtils.toTimeStamp2(remainingCooldown, 1000L, true)));
        }
    }

    public static long getCooldown(UUID entity, String cooldownKey) {
        if (!allCooldowns.containsKey(cooldownKey)) {
            allCooldowns.put(cooldownKey, new HashMap());
        }
        if (allCooldowns.get(cooldownKey).containsKey(entity)) {
            return allCooldowns.get(cooldownKey).get(entity) - System.currentTimeMillis();
        }
        return 0L;
    }

    public static boolean isCooldownPassed(UUID entity, String cooldownKey) {
        allCooldowns.computeIfAbsent(cooldownKey, k -> new HashMap());
        if (((Map)allCooldowns.getOrDefault(cooldownKey, new HashMap())).containsKey(entity)) {
            return (Long)((Map)allCooldowns.getOrDefault(cooldownKey, new HashMap())).get(entity) <= System.currentTimeMillis();
        }
        return true;
    }

    public static void startTimer(UUID entity, String timerKey) {
        if (!allTimers.containsKey(timerKey)) {
            allTimers.put(timerKey, new HashMap());
        }
        allTimers.get(timerKey).put(entity, System.currentTimeMillis());
    }

    public static long getTimerResult(UUID entity, String timerKey) {
        if (!allTimers.containsKey(timerKey)) {
            allTimers.put(timerKey, new HashMap());
        }
        if (allTimers.get(timerKey).containsKey(entity)) {
            return System.currentTimeMillis() - allTimers.get(timerKey).get(entity);
        }
        return 0L;
    }

    public static void stopTimer(UUID entity, String timerKey) {
        if (!allTimers.containsKey(timerKey)) {
            allTimers.put(timerKey, new HashMap());
        }
        allTimers.get(timerKey).remove(entity);
    }

    public static void startTimerNanos(UUID entity, String timerKey) {
        if (!allTimersNanos.containsKey(timerKey)) {
            allTimersNanos.put(timerKey, new HashMap());
        }
        allTimersNanos.get(timerKey).put(entity, System.nanoTime());
    }

    public static long getTimerResultNanos(UUID entity, String timerKey) {
        if (!allTimersNanos.containsKey(timerKey)) {
            allTimersNanos.put(timerKey, new HashMap());
        }
        if (allTimersNanos.get(timerKey).containsKey(entity)) {
            return System.nanoTime() - allTimersNanos.get(timerKey).get(entity);
        }
        return 0L;
    }

    public static void stopTimerNanos(UUID entity, String timerKey) {
        if (!allTimersNanos.containsKey(timerKey)) {
            allTimersNanos.put(timerKey, new HashMap());
        }
        allTimersNanos.get(timerKey).remove(entity);
    }
}

