/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.version;

import java.util.HashMap;
import java.util.Map;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.configuration.ConfigManager;
import me.athlaeos.valhallammo.event.PlayerSkillExperienceGainEvent;
import me.athlaeos.valhallammo.skills.skills.Skill;
import me.athlaeos.valhallammo.skills.skills.SkillRegistry;
import me.athlaeos.valhallammo.skills.skills.implementations.AlchemySkill;
import me.athlaeos.valhallammo.skills.skills.implementations.ArcherySkill;
import me.athlaeos.valhallammo.skills.skills.implementations.DiggingSkill;
import me.athlaeos.valhallammo.skills.skills.implementations.EnchantingSkill;
import me.athlaeos.valhallammo.skills.skills.implementations.FarmingSkill;
import me.athlaeos.valhallammo.skills.skills.implementations.FishingSkill;
import me.athlaeos.valhallammo.skills.skills.implementations.HeavyArmorSkill;
import me.athlaeos.valhallammo.skills.skills.implementations.HeavyWeaponsSkill;
import me.athlaeos.valhallammo.skills.skills.implementations.LightArmorSkill;
import me.athlaeos.valhallammo.skills.skills.implementations.LightWeaponsSkill;
import me.athlaeos.valhallammo.skills.skills.implementations.MiningSkill;
import me.athlaeos.valhallammo.skills.skills.implementations.SmithingSkill;
import me.athlaeos.valhallammo.skills.skills.implementations.WoodcuttingSkill;
import me.athlaeos.valhallammo.version.conversion_dto.AlphaDatabaseAdapter;
import me.athlaeos.valhallammo.version.conversion_dto.AlphaPDCAdapter;
import me.athlaeos.valhallammo.version.conversion_dto.DatabaseConnection;
import me.athlaeos.valhallammo.version.conversion_dto.Profile;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class AlphaToBetaConversionHandler
implements Listener {
    private static final boolean enabled = ConfigManager.getConfig("alpha_conversion.yml").get().getBoolean("enabled");
    private static final double expConversion = ConfigManager.getConfig("alpha_conversion.yml").get().getDouble("exp_conversion");
    private static final double expConversionFishing = ConfigManager.getConfig("alpha_conversion.yml").get().getDouble("exp_conversion_fishing");
    private static final double expConversionFarming = ConfigManager.getConfig("alpha_conversion.yml").get().getDouble("exp_conversion_farming");
    private static final double expConversionWoodcutting = ConfigManager.getConfig("alpha_conversion.yml").get().getDouble("exp_conversion_woodcutting");
    private static final double expConversionDigging = ConfigManager.getConfig("alpha_conversion.yml").get().getDouble("exp_conversion_digging");
    private final AlphaDatabaseAdapter adapter = new AlphaDatabaseAdapter(new DatabaseConnection(), new AlphaPDCAdapter());
    private final Map<String, NamespacedKey> alphaKeyMappings = new HashMap<String, NamespacedKey>();
    private final Map<String, Class<? extends Skill>> alphaToBetaSkillMappings = new HashMap<String, Class<? extends Skill>>();
    private static final NamespacedKey CONVERTED_FROM_ALPHA_KEY = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "converted_from_alpha");

    public AlphaToBetaConversionHandler() {
        this.alphaKeyMappings.put("ALCHEMY", new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "valhalla_profile_alchemy"));
        this.alphaKeyMappings.put("ARCHERY", new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "valhalla_profile_archery"));
        this.alphaKeyMappings.put("ENCHANTING", new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "valhalla_profile_enchanting"));
        this.alphaKeyMappings.put("FARMING", new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "valhalla_profile_farming"));
        this.alphaKeyMappings.put("HEAVYARMOR", new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "valhalla_profile_heavy_armor"));
        this.alphaKeyMappings.put("HEAVYWEAPONS", new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "valhalla_profile_heavy_weapons"));
        this.alphaKeyMappings.put("LANDSCAPING", new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "valhalla_profile_landscaping"));
        this.alphaKeyMappings.put("LIGHTARMOR", new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "valhalla_profile_light_armor"));
        this.alphaKeyMappings.put("LIGHTWEAPONS", new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "valhalla_profile_light_weapons"));
        this.alphaKeyMappings.put("MINING", new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "valhalla_profile_mining"));
        this.alphaKeyMappings.put("SMITHING", new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "valhalla_profile_smithing"));
        this.alphaToBetaSkillMappings.put("ALCHEMY", AlchemySkill.class);
        this.alphaToBetaSkillMappings.put("ARCHERY", ArcherySkill.class);
        this.alphaToBetaSkillMappings.put("ENCHANTING", EnchantingSkill.class);
        this.alphaToBetaSkillMappings.put("FARMING", FarmingSkill.class);
        this.alphaToBetaSkillMappings.put("HEAVYARMOR", HeavyArmorSkill.class);
        this.alphaToBetaSkillMappings.put("HEAVYWEAPONS", HeavyWeaponsSkill.class);
        this.alphaToBetaSkillMappings.put("LANDSCAPING", WoodcuttingSkill.class);
        this.alphaToBetaSkillMappings.put("LIGHTARMOR", LightArmorSkill.class);
        this.alphaToBetaSkillMappings.put("LIGHTWEAPONS", LightWeaponsSkill.class);
        this.alphaToBetaSkillMappings.put("MINING", MiningSkill.class);
        this.alphaToBetaSkillMappings.put("SMITHING", SmithingSkill.class);
    }

    public static boolean shouldConvert() {
        YamlConfiguration config = ConfigManager.getConfig("tutorial_book.yml").get();
        return enabled && config.getString("title") != null;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void expConversion(PlayerJoinEvent e) {
        if (expConversion <= 0.0 || e.getPlayer().getPersistentDataContainer().has(CONVERTED_FROM_ALPHA_KEY, PersistentDataType.BYTE)) {
            return;
        }
        ValhallaMMO.getInstance().getServer().getScheduler().runTaskLater((Plugin)ValhallaMMO.getInstance(), () -> {
            if (!e.getPlayer().isOnline()) {
                return;
            }
            ValhallaMMO.logInfo("Player " + e.getPlayer().getName() + " had alpha data, converting to beta");
            for (String profileType : this.alphaKeyMappings.keySet()) {
                Profile profile = this.adapter.getProfile(e.getPlayer(), profileType);
                NamespacedKey key = this.alphaKeyMappings.get(profileType);
                Class<? extends Skill> skillClass = this.alphaToBetaSkillMappings.get(profileType);
                if (profile == null || key == null || skillClass == null) continue;
                switch (profileType) {
                    case "LANDSCAPING": {
                        SkillRegistry.getSkill(DiggingSkill.class).addEXP(e.getPlayer(), expConversionDigging * profile.getLifetimeEXP(), false, PlayerSkillExperienceGainEvent.ExperienceGainReason.ALPHA_REFUND);
                        SkillRegistry.getSkill(WoodcuttingSkill.class).addEXP(e.getPlayer(), expConversionWoodcutting * profile.getLifetimeEXP(), false, PlayerSkillExperienceGainEvent.ExperienceGainReason.ALPHA_REFUND);
                        break;
                    }
                    case "FARMING": {
                        SkillRegistry.getSkill(FishingSkill.class).addEXP(e.getPlayer(), expConversionFishing * profile.getLifetimeEXP(), false, PlayerSkillExperienceGainEvent.ExperienceGainReason.ALPHA_REFUND);
                        SkillRegistry.getSkill(FarmingSkill.class).addEXP(e.getPlayer(), expConversionFarming * profile.getLifetimeEXP(), false, PlayerSkillExperienceGainEvent.ExperienceGainReason.ALPHA_REFUND);
                        break;
                    }
                    default: {
                        SkillRegistry.getSkill(skillClass).addEXP(e.getPlayer(), expConversionFarming * profile.getLifetimeEXP(), false, PlayerSkillExperienceGainEvent.ExperienceGainReason.ALPHA_REFUND);
                    }
                }
                e.getPlayer().getPersistentDataContainer().remove(key);
            }
            e.getPlayer().getPersistentDataContainer().set(CONVERTED_FROM_ALPHA_KEY, PersistentDataType.BYTE, (Object)1);
        }, 20L);
    }
}

