/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.version;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.dom.MinecraftVersion;
import me.athlaeos.valhallammo.event.ValhallaLootPopulateEvent;
import me.athlaeos.valhallammo.listeners.LootListener;
import me.athlaeos.valhallammo.loot.LootTable;
import me.athlaeos.valhallammo.loot.LootTableRegistry;
import me.athlaeos.valhallammo.playerstats.AccumulativeStatManager;
import me.athlaeos.valhallammo.shaded.com.jeff_media.customblockdata.CustomBlockData;
import me.athlaeos.valhallammo.utility.EntityUtils;
import me.athlaeos.valhallammo.utility.ItemUtils;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.BrushableBlock;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.loot.LootContext;
import org.bukkit.loot.LootTable;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ArchaeologyListener
implements Listener {
    private static final NamespacedKey PREVENT_CUSTOM_GENERATION = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "generated_custom_archaeology");
    private static final Collection<String> brushable = Set.of("SUSPICIOUS_GRAVEL", "SUSPICIOUS_SAND");
    private static final Map<Block, LootTable> suspiciousLootTables = new HashMap<Block, LootTable>();

    public static boolean isBrushable(Material material) {
        if (MinecraftVersion.currentVersionNewerThan(MinecraftVersion.MINECRAFT_1_20)) {
            return brushable.contains(material.toString());
        }
        return false;
    }

    public static boolean isBrushable(BlockState state) {
        if (MinecraftVersion.currentVersionNewerThan(MinecraftVersion.MINECRAFT_1_20)) {
            return state instanceof BrushableBlock;
        }
        return false;
    }

    public static Map<Block, LootTable> getSuspiciousLootTables() {
        return suspiciousLootTables;
    }

    public static void setPreventRepeatGeneration(Block b, boolean prevent) {
        CustomBlockData customBlockData = new CustomBlockData(b, (Plugin)ValhallaMMO.getInstance());
        if (prevent) {
            customBlockData.set(PREVENT_CUSTOM_GENERATION, PersistentDataType.BYTE, (byte)0);
        } else {
            customBlockData.remove(PREVENT_CUSTOM_GENERATION);
        }
    }

    public static boolean preventRepeatGeneration(Block b) {
        CustomBlockData customBlockData = new CustomBlockData(b, (Plugin)ValhallaMMO.getInstance());
        return customBlockData.has(PREVENT_CUSTOM_GENERATION, PersistentDataType.STRING);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onBrush(PlayerInteractEvent e) {
        BlockState blockState;
        Block b = e.getClickedBlock();
        if (ValhallaMMO.isWorldBlacklisted(e.getPlayer().getWorld().getName()) || e.useInteractedBlock() == Event.Result.DENY || e.useItemInHand() == Event.Result.DENY || e.getAction() != Action.RIGHT_CLICK_BLOCK || e.getHand() != EquipmentSlot.HAND || b == null || ItemUtils.isEmpty(e.getPlayer().getInventory().getItemInMainHand()) || e.getPlayer().getInventory().getItemInMainHand().getType() != Material.BRUSH || !LootListener.getPreparedExtraDrops(b).isEmpty() || !((blockState = b.getState()) instanceof BrushableBlock)) {
            return;
        }
        BrushableBlock brushable = (BrushableBlock)blockState;
        if (ArchaeologyListener.setCustomArchaeologyDrops(b, e.getPlayer(), brushable)) {
            e.setCancelled(true);
        }
    }

    public static boolean setCustomArchaeologyDrops(Block b, Player p, BrushableBlock brushable) {
        me.athlaeos.valhallammo.loot.LootTable table;
        if (brushable.getLootTable() != null) {
            suspiciousLootTables.put(b.getLocation().getBlock(), brushable.getLootTable());
        }
        if ((table = LootTableRegistry.getLootTable(b, b.getType())) == null && brushable.getLootTable() != null) {
            table = LootTableRegistry.getLootTable(brushable.getLootTable().getKey());
        }
        if (table == null || ArchaeologyListener.preventRepeatGeneration(b)) {
            return false;
        }
        LootTableRegistry.setLootTable(b, null);
        ArchaeologyListener.setPreventRepeatGeneration(b, true);
        AttributeInstance luckInstance = p.getAttribute(Attribute.GENERIC_LUCK);
        double luck = luckInstance == null ? 0.0 : luckInstance.getValue();
        LootContext context = new LootContext.Builder(b.getLocation()).killer(null).lootedEntity((Entity)p).lootingModifier(0).luck((float)(luck += AccumulativeStatManager.getCachedStats("DIGGING_ARCHAEOLOGY_LUCK", (Entity)p, 10000L, true))).build();
        if (ArchaeologyListener.prepareArchaeologyBrushing(b, table, context)) {
            brushable.setItem(null);
            List<ItemStack> extraDrops = LootListener.getPreparedExtraDrops(b);
            if (!extraDrops.isEmpty()) {
                brushable.setItem(extraDrops.get(0));
                extraDrops.remove(0);
                brushable.update(true, false);
            }
        } else {
            return false;
        }
        if (brushable.getLootTable() != null) {
            brushable.setLootTable(null);
            brushable.update();
            return true;
        }
        return false;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBrush(BlockDropItemEvent e) {
        if (e.getBlockState() instanceof BrushableBlock) {
            BlockFace face = EntityUtils.getSelectedBlockFace(e.getPlayer());
            List<ItemStack> extraDrops = LootListener.getPreparedExtraDrops(e.getBlock());
            for (ItemStack i : extraDrops) {
                e.getBlock().getWorld().dropItem(face == null ? e.getBlock().getLocation() : e.getBlock().getRelative(face).getLocation().add(0.5, 0.5, 0.5), i);
            }
            LootListener.clear(e.getBlock());
        }
    }

    private static boolean prepareArchaeologyBrushing(Block b, me.athlaeos.valhallammo.loot.LootTable table, LootContext context) {
        LootTableRegistry.setLootTable(b, null);
        List<ItemStack> generatedLoot = LootTableRegistry.getLoot(table, context, LootTable.LootType.ARCHAEOLOGY);
        ValhallaLootPopulateEvent loottableEvent = new ValhallaLootPopulateEvent(table, context, generatedLoot);
        ValhallaMMO.getInstance().getServer().getPluginManager().callEvent((Event)loottableEvent);
        if (!loottableEvent.isCancelled()) {
            LootListener.prepareBlockDrops(b, loottableEvent.getDrops());
            return switch (loottableEvent.getPreservationType()) {
                default -> throw new IncompatibleClassChangeError();
                case LootTable.VanillaLootPreservationType.CLEAR -> true;
                case LootTable.VanillaLootPreservationType.KEEP -> false;
                case LootTable.VanillaLootPreservationType.CLEAR_UNLESS_EMPTY -> !loottableEvent.getDrops().isEmpty();
            };
        }
        return false;
    }
}

