/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.version;

import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.crafting.CustomRecipeRegistry;
import me.athlaeos.valhallammo.crafting.recipetypes.DynamicCookingRecipe;
import me.athlaeos.valhallammo.playerstats.AccumulativeStatManager;
import me.athlaeos.valhallammo.utility.BlockUtils;
import org.bukkit.block.Furnace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.FurnaceStartSmeltEvent;
import org.bukkit.inventory.CookingRecipe;
import org.bukkit.inventory.Recipe;

public class FurnaceStartSmeltListener
implements Listener {
    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onFurnaceStart(FurnaceStartSmeltEvent e) {
        if (e.getBlock().getState() instanceof Furnace) {
            Player owner;
            DynamicCookingRecipe recipe = CustomRecipeRegistry.getCookingRecipesByKey().get(e.getRecipe().getKey());
            if (recipe == null) {
                if (CustomRecipeRegistry.getDisabledRecipes().contains(e.getRecipe().getKey())) {
                    e.setTotalCookTime(Integer.MAX_VALUE);
                    return;
                }
            } else {
                Recipe r = ValhallaMMO.getInstance().getServer().getRecipe(recipe.getKey());
                if (!(r instanceof CookingRecipe)) {
                    throw new IllegalStateException("Recipe linked to dynamic cooking recipe key is not a cooking recipe");
                }
            }
            double cookingSpeedBonus = 1.0 + ((owner = BlockUtils.getOwner(e.getBlock())) == null ? 0.0 : AccumulativeStatManager.getCachedStats("COOKING_SPEED_BONUS", (Entity)owner, 10000L, true));
            e.setTotalCookTime((int)(cookingSpeedBonus <= 0.0 ? 2.147483647E9 : (double)e.getRecipe().getCookingTime() / cookingSpeedBonus));
        }
    }
}

