/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.content;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.content.ContentPackage;
import me.athlaeos.valhallammo.crafting.CustomRecipeRegistry;
import me.athlaeos.valhallammo.crafting.blockvalidations.Validation;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.DynamicItemModifier;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.IngredientChoice;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.RecipeOption;
import me.athlaeos.valhallammo.crafting.recipetypes.DynamicBrewingRecipe;
import me.athlaeos.valhallammo.crafting.recipetypes.DynamicCauldronRecipe;
import me.athlaeos.valhallammo.crafting.recipetypes.DynamicCookingRecipe;
import me.athlaeos.valhallammo.crafting.recipetypes.DynamicGridRecipe;
import me.athlaeos.valhallammo.crafting.recipetypes.DynamicSmithingRecipe;
import me.athlaeos.valhallammo.crafting.recipetypes.ImmersiveCraftingRecipe;
import me.athlaeos.valhallammo.crafting.recipetypes.ValhallaRecipe;
import me.athlaeos.valhallammo.dom.Action;
import me.athlaeos.valhallammo.dom.Weighted;
import me.athlaeos.valhallammo.item.CustomItem;
import me.athlaeos.valhallammo.item.CustomItemRegistry;
import me.athlaeos.valhallammo.loot.LootTableRegistry;
import me.athlaeos.valhallammo.loot.predicates.LootPredicate;
import me.athlaeos.valhallammo.persistence.GsonAdapter;
import me.athlaeos.valhallammo.persistence.ItemStackGSONAdapter;
import me.athlaeos.valhallammo.utility.Utils;
import org.bukkit.configuration.serialization.ConfigurationSerializable;

public class ContentPackageManager {
    private static final Gson gson = new GsonBuilder().registerTypeAdapter(RecipeOption.class, new GsonAdapter("OPTION")).registerTypeAdapter(IngredientChoice.class, new GsonAdapter("CHOICE")).registerTypeAdapter(DynamicItemModifier.class, new GsonAdapter("MOD_TYPE")).registerTypeAdapter(ValhallaRecipe.class, new GsonAdapter("RECIPE_TYPE")).registerTypeAdapter(Validation.class, new GsonAdapter("VALIDATION_TYPE")).registerTypeAdapter(LootPredicate.class, new GsonAdapter("PRED_TYPE")).registerTypeAdapter(Weighted.class, new GsonAdapter("WEIGHTED_IMPL")).registerTypeHierarchyAdapter(ConfigurationSerializable.class, (Object)new ItemStackGSONAdapter()).setPrettyPrinting().disableHtmlEscaping().enableComplexMapKeySerialization().create();

    public static ContentPackage fromFile(String path) {
        ContentPackage contentPackage;
        File f = new File(ValhallaMMO.getInstance().getDataFolder(), "/" + path + ".json");
        if (!f.exists()) {
            ValhallaMMO.logWarning("Could not load content package from " + path + ".json, it doesn't exist!");
            return null;
        }
        BufferedReader setsReader = new BufferedReader(new FileReader(f, StandardCharsets.UTF_8));
        try {
            contentPackage = (ContentPackage)gson.fromJson((Reader)setsReader, ContentPackage.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    setsReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (JsonSyntaxException | IOException | NoClassDefFoundError exception) {
                ValhallaMMO.logSevere("Could not load content package from " + path + ".json, " + exception.getMessage());
                return null;
            }
        }
        setsReader.close();
        return contentPackage;
    }

    public static void importContent(ContentPackage contentPackage, List<String> recipes, ExportMode ... importModes) {
        List<ExportMode> modes = List.of(importModes);
        if (modes.contains((Object)ExportMode.ITEMS)) {
            contentPackage.getCustomItems().values().forEach(i -> CustomItemRegistry.register(i.getId(), i));
        }
        if (modes.contains((Object)ExportMode.LOOT_TABLES)) {
            contentPackage.getLootTables().values().forEach(l -> LootTableRegistry.registerLootTable(l, true));
        }
        if (modes.contains((Object)ExportMode.LOOT_CONFIGURATION)) {
            LootTableRegistry.applyConfiguration(contentPackage.getLootTableConfiguration());
        }
        if (modes.contains((Object)ExportMode.REPLACEMENT_TABLES)) {
            contentPackage.getReplacementTables().values().forEach(l -> LootTableRegistry.registerReplacementTable(l, true));
        }
        if (modes.contains((Object)ExportMode.REPLACEMENT_CONFIGURATION)) {
            LootTableRegistry.applyConfiguration(contentPackage.getReplacementTableConfiguration());
        }
        if (modes.contains((Object)ExportMode.RECIPES_IMMERSIVE)) {
            contentPackage.getImmersiveRecipes().values().stream().filter(r -> recipes.isEmpty() || recipes.contains(r.getName())).forEach(r -> CustomRecipeRegistry.register(r, true));
        }
        if (modes.contains((Object)ExportMode.RECIPES_SMITHING)) {
            contentPackage.getSmithingRecipes().values().stream().filter(r -> recipes.isEmpty() || recipes.contains(r.getName())).forEach(r -> CustomRecipeRegistry.register(r, true));
        }
        if (modes.contains((Object)ExportMode.RECIPES_GRID)) {
            contentPackage.getGridRecipes().values().stream().filter(r -> recipes.isEmpty() || recipes.contains(r.getName())).forEach(r -> CustomRecipeRegistry.register(r, true));
        }
        if (modes.contains((Object)ExportMode.RECIPES_BREWING)) {
            contentPackage.getBrewingRecipes().values().stream().filter(r -> recipes.isEmpty() || recipes.contains(r.getName())).forEach(r -> CustomRecipeRegistry.register(r, true));
        }
        if (modes.contains((Object)ExportMode.RECIPES_COOKING)) {
            contentPackage.getCookingRecipes().values().stream().filter(r -> recipes.isEmpty() || recipes.contains(r.getName())).forEach(r -> CustomRecipeRegistry.register(r, true));
        }
        if (modes.contains((Object)ExportMode.RECIPES_CAULDRON)) {
            contentPackage.getCauldronRecipes().values().stream().filter(r -> recipes.isEmpty() || recipes.contains(r.getName())).forEach(r -> CustomRecipeRegistry.register(r, true));
        }
        CustomRecipeRegistry.setChangesMade();
    }

    public static void importContent(ContentPackage contentPackage) {
        ContentPackageManager.importContent(contentPackage, new ArrayList<String>(), ExportMode.values());
    }

    public static boolean exportContent(String packageName, List<ValhallaRecipe> recipes, List<CustomItem> items, boolean add, ExportMode ... exportModes) {
        boolean bl;
        ContentPackage contentPackage = add ? Utils.thisorDefault(ContentPackageManager.fromFile(packageName), new ContentPackage()) : new ContentPackage();
        for (ExportMode mode : exportModes) {
            mode.act(contentPackage);
        }
        for (ValhallaRecipe recipe : recipes) {
            if (recipe instanceof ImmersiveCraftingRecipe) {
                ImmersiveCraftingRecipe r = (ImmersiveCraftingRecipe)recipe;
                contentPackage.getImmersiveRecipes().put(r.getName(), r);
                continue;
            }
            if (recipe instanceof DynamicCauldronRecipe) {
                DynamicCauldronRecipe r = (DynamicCauldronRecipe)recipe;
                contentPackage.getCauldronRecipes().put(r.getName(), r);
                continue;
            }
            if (recipe instanceof DynamicGridRecipe) {
                DynamicGridRecipe r = (DynamicGridRecipe)recipe;
                contentPackage.getGridRecipes().put(r.getName(), r);
                continue;
            }
            if (recipe instanceof DynamicCookingRecipe) {
                DynamicCookingRecipe r = (DynamicCookingRecipe)recipe;
                contentPackage.getCookingRecipes().put(r.getName(), r);
                continue;
            }
            if (recipe instanceof DynamicBrewingRecipe) {
                DynamicBrewingRecipe r = (DynamicBrewingRecipe)recipe;
                contentPackage.getBrewingRecipes().put(r.getName(), r);
                continue;
            }
            if (!(recipe instanceof DynamicSmithingRecipe)) continue;
            DynamicSmithingRecipe r = (DynamicSmithingRecipe)recipe;
            contentPackage.getSmithingRecipes().put(r.getName(), r);
        }
        items.forEach(i -> contentPackage.getCustomItems().put(i.getId(), (CustomItem)i));
        File f = new File(ValhallaMMO.getInstance().getDataFolder(), "/export/" + packageName + ".json");
        try {
            if (!f.getParentFile().exists() && !f.getParentFile().mkdirs()) {
                ValhallaMMO.logWarning("Could not save items to export/" + packageName + ".json, file directory could not be created");
                return false;
            }
            if (!f.exists() && !f.createNewFile()) {
                ValhallaMMO.logWarning("Could not save items to export/" + packageName + ".json, file could not be created");
                return false;
            }
        }
        catch (IOException recipe) {
            // empty catch block
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter(f, StandardCharsets.UTF_8));
        try {
            JsonElement element = gson.toJsonTree((Object)contentPackage, ContentPackage.class);
            gson.toJson(element, (Appendable)writer);
            writer.flush();
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (JsonSyntaxException | IOException exception) {
                ValhallaMMO.logSevere("Could not save items to export/" + packageName + ".json, " + exception.getMessage());
                return false;
            }
        }
        writer.close();
        return bl;
    }

    public static void exportContent(String path) {
        ContentPackageManager.exportContent(path, new ArrayList<ValhallaRecipe>(), new ArrayList<CustomItem>(), false, ExportMode.values());
    }

    public static enum ExportMode {
        RECIPES_BREWING(p -> p.getBrewingRecipes().putAll(CustomRecipeRegistry.getBrewingRecipes())),
        RECIPES_CAULDRON(p -> p.getCauldronRecipes().putAll(CustomRecipeRegistry.getCauldronRecipes())),
        RECIPES_COOKING(p -> p.getCookingRecipes().putAll(CustomRecipeRegistry.getCookingRecipes())),
        RECIPES_GRID(p -> p.getGridRecipes().putAll(CustomRecipeRegistry.getGridRecipes())),
        RECIPES_SMITHING(p -> p.getSmithingRecipes().putAll(CustomRecipeRegistry.getSmithingRecipes())),
        RECIPES_IMMERSIVE(p -> p.getImmersiveRecipes().putAll(CustomRecipeRegistry.getImmersiveRecipes())),
        LOOT_TABLES(p -> p.getLootTables().putAll(LootTableRegistry.getLootTables())),
        LOOT_CONFIGURATION(p -> p.setLootTableConfiguration(LootTableRegistry.getLootTableConfiguration())),
        REPLACEMENT_TABLES(p -> p.getReplacementTables().putAll(LootTableRegistry.getReplacementTables())),
        REPLACEMENT_CONFIGURATION(p -> p.setReplacementTableConfiguration(LootTableRegistry.getReplacementTableConfiguration())),
        ITEMS(p -> p.getCustomItems().putAll(CustomItemRegistry.getItems()));

        private final Action<ContentPackage> action;

        private ExportMode(Action<ContentPackage> action) {
            this.action = action;
        }

        private void act(ContentPackage contentPackage) {
            this.action.act(contentPackage);
        }
    }
}

