/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.crafting.dynamicitemmodifiers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.utility.ItemUtils;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ModifierContext {
    private Player crafter;
    private Entity relativeEntity;
    private ItemBuilder item;
    private final List<ItemBuilder> otherInvolvedItems = new ArrayList<ItemBuilder>();
    private int timesExecuted = 1;
    private boolean shouldSort = false;
    private boolean shouldValidate = false;
    private boolean executeUsageMechanics = false;
    private final Map<Class<?>, Object> otherArgs = new HashMap();

    private ModifierContext(ItemBuilder item) {
        this.item = item;
    }

    public ModifierContextBuilder toBuilder() {
        return new ModifierContextBuilder(this.item.copy()).crafter(this.crafter).entity(this.relativeEntity).itemBuilders(this.otherInvolvedItems.stream().map(ItemBuilder::copy).toList()).count(this.timesExecuted).sort(this.shouldSort).validate(this.shouldValidate).setOtherTypes(this.otherArgs);
    }

    public static ModifierContextBuilder builder(ItemBuilder item) {
        return new ModifierContextBuilder(item);
    }

    public Player getCrafter() {
        return this.crafter;
    }

    public Entity getRelativeEntity() {
        return this.relativeEntity;
    }

    public ItemBuilder getItem() {
        return this.item;
    }

    public List<ItemBuilder> getOtherInvolvedItems() {
        return this.otherInvolvedItems;
    }

    public int getTimesExecuted() {
        return this.timesExecuted;
    }

    public boolean shouldSort() {
        return this.shouldSort;
    }

    public boolean shouldValidate() {
        return this.shouldValidate;
    }

    public boolean shouldExecuteUsageMechanics() {
        return this.executeUsageMechanics;
    }

    public <T> T getOtherType(Class<T> clazz) {
        Object o = this.otherArgs.get(clazz);
        if (o == null) {
            return null;
        }
        return (T)o;
    }

    public static class ModifierContextBuilder {
        private final ModifierContext context;

        private ModifierContextBuilder(ItemBuilder item) {
            this.context = new ModifierContext(item);
        }

        public ModifierContextBuilder crafter(Player crafter) {
            this.context.crafter = crafter;
            return this;
        }

        public ModifierContextBuilder entity(Entity entity) {
            this.context.relativeEntity = entity;
            return this;
        }

        public ModifierContextBuilder items(ItemStack ... items) {
            for (ItemStack i : items) {
                if (ItemUtils.isEmpty(i)) continue;
                this.context.otherInvolvedItems.add(new ItemBuilder(i));
            }
            return this;
        }

        public ModifierContextBuilder items(List<ItemStack> items) {
            for (ItemStack i : items) {
                if (ItemUtils.isEmpty(i)) continue;
                this.context.otherInvolvedItems.add(new ItemBuilder(i));
            }
            return this;
        }

        public ModifierContextBuilder itemBuilders(List<ItemBuilder> items) {
            this.context.otherInvolvedItems.clear();
            this.context.otherInvolvedItems.addAll(items);
            return this;
        }

        public ModifierContextBuilder items(ItemBuilder ... items) {
            this.context.otherInvolvedItems.addAll(Arrays.asList(items));
            return this;
        }

        public ModifierContextBuilder count(int count) {
            this.context.timesExecuted = count;
            return this;
        }

        public ModifierContextBuilder sort() {
            this.context.shouldSort = true;
            return this;
        }

        public ModifierContextBuilder sort(boolean sort) {
            this.context.shouldSort = sort;
            return this;
        }

        public ModifierContextBuilder validate() {
            this.context.shouldValidate = true;
            return this;
        }

        public ModifierContextBuilder validate(boolean validate) {
            this.context.shouldValidate = validate;
            return this;
        }

        public ModifierContextBuilder executeUsageMechanics() {
            this.context.executeUsageMechanics = true;
            return this;
        }

        public ModifierContextBuilder executeUsageMechanics(boolean execute) {
            this.context.executeUsageMechanics = execute;
            return this;
        }

        public ModifierContextBuilder item(ItemBuilder item) {
            this.context.item = item;
            return this;
        }

        public ModifierContextBuilder setOtherType(Object o) {
            this.context.otherArgs.put(o.getClass(), o);
            return this;
        }

        public ModifierContextBuilder setOtherTypes(Map<Class<?>, Object> o) {
            this.context.otherArgs.clear();
            this.context.otherArgs.putAll(o);
            return this;
        }

        public ModifierContext get() {
            return this.context;
        }
    }
}

