/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.implementations.item_misc;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.DynamicItemModifier;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierCategoryRegistry;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierContext;
import me.athlaeos.valhallammo.item.CustomFlag;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.potioneffects.PotionEffectRegistry;
import me.athlaeos.valhallammo.utility.StringUtils;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class FlagCustomAdd
extends DynamicItemModifier {
    private final CustomFlag flag;

    public FlagCustomAdd(String name, CustomFlag flag) {
        super(name);
        this.flag = flag;
    }

    @Override
    public void processItem(ModifierContext context) {
        context.getItem().flag(this.flag);
        PotionEffectRegistry.updateEffectLore(context.getItem());
    }

    @Override
    public void onButtonPress(InventoryClickEvent e, int button) {
    }

    @Override
    public Map<Integer, ItemStack> getButtons() {
        return new HashMap<Integer, ItemStack>();
    }

    @Override
    public ItemStack getModifierIcon() {
        return new ItemBuilder(switch (this.flag) {
            default -> throw new IncompatibleClassChangeError();
            case CustomFlag.UNCRAFTABLE -> Material.BARRIER;
            case CustomFlag.HIDE_TAGS -> Material.INK_SAC;
            case CustomFlag.HIDE_QUALITY -> Material.COAL;
            case CustomFlag.HIDE_DURABILITY -> Material.WOODEN_PICKAXE;
            case CustomFlag.DISPLAY_ATTRIBUTES -> Material.NAME_TAG;
            case CustomFlag.ATTRIBUTE_FOR_BOTH_HANDS -> Material.GOLDEN_SWORD;
            case CustomFlag.ATTRIBUTE_FOR_HELMET -> Material.TURTLE_HELMET;
            case CustomFlag.INFINITY_EXPLOITABLE -> Material.ARROW;
            case CustomFlag.UNENCHANTABLE -> Material.ENCHANTING_TABLE;
            case CustomFlag.TEMPORARY_POTION_DISPLAY -> Material.GLASS_BOTTLE;
            case CustomFlag.UNMENDABLE -> Material.ANVIL;
        }).get();
    }

    @Override
    public String getDisplayName() {
        return "&7Add Custom Item Flag: &e" + StringUtils.toPascalCase(this.flag.toString().toLowerCase(Locale.US).replace("_", " "));
    }

    @Override
    public String getDescription() {
        return "&fAdds the " + StringUtils.toPascalCase(this.flag.toString().toLowerCase(Locale.US).replace("_", " ")) + " item flag to the item.";
    }

    @Override
    public String getActiveDescription() {
        return "&fAdds the " + StringUtils.toPascalCase(this.flag.toString().toLowerCase(Locale.US).replace("_", " ")) + " item flag to the item.";
    }

    @Override
    public Collection<String> getCategories() {
        return Set.of(ModifierCategoryRegistry.ITEM_FLAGS.id());
    }

    @Override
    public DynamicItemModifier copy() {
        FlagCustomAdd m = new FlagCustomAdd(this.getName(), this.flag);
        m.setPriority(this.getPriority());
        return m;
    }

    @Override
    public String parseCommand(CommandSender executor, String[] args) {
        return null;
    }

    @Override
    public List<String> commandSuggestions(CommandSender executor, int currentArg) {
        return null;
    }

    @Override
    public int commandArgsRequired() {
        return 0;
    }
}

