/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.implementations.item_misc;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.DynamicItemModifier;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierCategoryRegistry;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierContext;
import me.athlaeos.valhallammo.dom.MinecraftVersion;
import me.athlaeos.valhallammo.dom.Pair;
import me.athlaeos.valhallammo.item.EquipmentClass;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.utility.ItemUtils;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class ItemEquipmentClass
extends DynamicItemModifier {
    private EquipmentClass equipmentClass = EquipmentClass.SWORD;

    public ItemEquipmentClass(String name) {
        super(name);
    }

    @Override
    public void processItem(ModifierContext context) {
        EquipmentClass.setEquipmentClass(context.getItem().getMeta(), this.equipmentClass);
    }

    @Override
    public void onButtonPress(InventoryClickEvent e, int button) {
        if (button == 12) {
            int currentRequirement = Arrays.asList(EquipmentClass.values()).indexOf((Object)this.equipmentClass);
            currentRequirement = e.isLeftClick() ? (currentRequirement + 1 >= EquipmentClass.values().length ? 0 : ++currentRequirement) : (currentRequirement - 1 < 0 ? EquipmentClass.values().length - 1 : --currentRequirement);
            this.equipmentClass = EquipmentClass.values()[currentRequirement];
        }
    }

    @Override
    public Map<Integer, ItemStack> getButtons() {
        Integer n = 12;
        return new Pair<Integer, ItemStack>(n, new ItemBuilder(switch (this.equipmentClass) {
            default -> throw new IncompatibleClassChangeError();
            case EquipmentClass.SPEAR -> {
                if (MinecraftVersion.currentVersionNewerThan(MinecraftVersion.MINECRAFT_1_21_9)) {
                    yield ItemUtils.stringToMaterial("IRON_SPEAR", Material.BARRIER);
                }
                yield Material.BARRIER;
            }
            case EquipmentClass.BOW -> Material.BOW;
            case EquipmentClass.AXE -> Material.IRON_AXE;
            case EquipmentClass.HOE -> Material.IRON_HOE;
            case EquipmentClass.BOOTS -> Material.IRON_BOOTS;
            case EquipmentClass.OTHER -> Material.PAPER;
            case EquipmentClass.SWORD -> Material.IRON_SWORD;
            case EquipmentClass.ELYTRA -> Material.ELYTRA;
            case EquipmentClass.MACE -> {
                if (MinecraftVersion.currentVersionNewerThan(MinecraftVersion.MINECRAFT_1_20_5)) {
                    yield ItemUtils.stringToMaterial("MACE", Material.BARRIER);
                }
                yield Material.BARRIER;
            }
            case EquipmentClass.HELMET -> Material.IRON_HELMET;
            case EquipmentClass.SHEARS -> Material.SHEARS;
            case EquipmentClass.SHIELD -> Material.SHIELD;
            case EquipmentClass.SHOVEL -> Material.IRON_SHOVEL;
            case EquipmentClass.PICKAXE -> Material.IRON_PICKAXE;
            case EquipmentClass.TRIDENT -> Material.TRIDENT;
            case EquipmentClass.TRINKET -> Material.GOLD_NUGGET;
            case EquipmentClass.CROSSBOW -> Material.CROSSBOW;
            case EquipmentClass.LEGGINGS -> Material.IRON_LEGGINGS;
            case EquipmentClass.CHESTPLATE -> Material.IRON_CHESTPLATE;
            case EquipmentClass.FISHING_ROD -> Material.FISHING_ROD;
            case EquipmentClass.FLINT_AND_STEEL -> Material.FLINT_AND_STEEL;
        }).name("&eWhich equipment class should it be?").lore("&fEquipment class set to &e" + String.valueOf((Object)this.equipmentClass), "&fOnly affects the type of equipment ", "&fthe item is considered by the plugin.", "&fDoes not affect usage mechanics.", "&6Click to cycle").get()).map(new HashSet());
    }

    @Override
    public ItemStack getModifierIcon() {
        return new ItemBuilder(Material.IRON_PICKAXE).get();
    }

    @Override
    public String getDisplayName() {
        return "&bEquipment Class";
    }

    @Override
    public String getDescription() {
        return "&fChanges the equipment class of an item.";
    }

    @Override
    public String getActiveDescription() {
        return "&fEquipment class set to &e" + String.valueOf((Object)this.equipmentClass);
    }

    @Override
    public Collection<String> getCategories() {
        return Set.of(ModifierCategoryRegistry.ITEM_MISC.id());
    }

    public void setEquipmentClass(EquipmentClass equipmentClass) {
        this.equipmentClass = equipmentClass;
    }

    @Override
    public DynamicItemModifier copy() {
        ItemEquipmentClass m = new ItemEquipmentClass(this.getName());
        m.setEquipmentClass(this.equipmentClass);
        m.setPriority(this.getPriority());
        return m;
    }

    @Override
    public String parseCommand(CommandSender executor, String[] args) {
        if (args.length != 1) {
            return "You must indicate the equipment class to set the item to";
        }
        try {
            this.equipmentClass = EquipmentClass.valueOf(args[0]);
        }
        catch (IllegalArgumentException ignored) {
            return "Invalid equipment class";
        }
        return null;
    }

    @Override
    public List<String> commandSuggestions(CommandSender executor, int currentArg) {
        if (currentArg == 0) {
            return Arrays.stream(EquipmentClass.values()).map(Enum::toString).toList();
        }
        return null;
    }

    @Override
    public int commandArgsRequired() {
        return 1;
    }
}

