/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.implementations.item_misc;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.DynamicItemModifier;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierCategoryRegistry;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierContext;
import me.athlaeos.valhallammo.dom.Pair;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.item.MaterialClass;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class ItemMaterialClass
extends DynamicItemModifier {
    private MaterialClass materialClass = MaterialClass.WOOD;

    public ItemMaterialClass(String name) {
        super(name);
    }

    @Override
    public void processItem(ModifierContext context) {
        MaterialClass.setMaterialType(context.getItem().getMeta(), this.materialClass);
    }

    @Override
    public void onButtonPress(InventoryClickEvent e, int button) {
        if (button == 12) {
            List<MaterialClass> weightClasses = Arrays.asList(MaterialClass.values());
            int currentClass = weightClasses.indexOf((Object)this.materialClass);
            currentClass = e.isLeftClick() ? (currentClass + 1 >= weightClasses.size() ? 0 : ++currentClass) : (currentClass - 1 < 0 ? weightClasses.size() - 1 : --currentClass);
            this.materialClass = weightClasses.get(currentClass);
        }
    }

    @Override
    public Map<Integer, ItemStack> getButtons() {
        Integer n = 12;
        return new Pair<Integer, ItemStack>(n, new ItemBuilder(switch (this.materialClass) {
            default -> throw new IncompatibleClassChangeError();
            case MaterialClass.BOW -> Material.BOW;
            case MaterialClass.GOLD -> Material.GOLDEN_SWORD;
            case MaterialClass.IRON -> Material.IRON_SWORD;
            case MaterialClass.WOOD -> Material.WOODEN_SWORD;
            case MaterialClass.OTHER -> Material.NETHER_STAR;
            case MaterialClass.STONE -> Material.STONE_SWORD;
            case MaterialClass.DIAMOND -> Material.DIAMOND_SWORD;
            case MaterialClass.ENDERIC -> Material.ELYTRA;
            case MaterialClass.LEATHER -> Material.LEATHER;
            case MaterialClass.CROSSBOW -> Material.CROSSBOW;
            case MaterialClass.COPPER -> Material.COPPER_INGOT;
            case MaterialClass.CHAINMAIL -> Material.CHAIN;
            case MaterialClass.NETHERITE -> Material.NETHERITE_SWORD;
            case MaterialClass.PRISMARINE -> Material.TRIDENT;
            case MaterialClass.CUSTOM_1 -> Material.RED_CONCRETE;
            case MaterialClass.CUSTOM_2 -> Material.ORANGE_CONCRETE;
            case MaterialClass.CUSTOM_3 -> Material.YELLOW_CONCRETE;
            case MaterialClass.CUSTOM_4 -> Material.LIME_CONCRETE;
            case MaterialClass.CUSTOM_5 -> Material.GREEN_CONCRETE;
            case MaterialClass.CUSTOM_6 -> Material.CYAN_CONCRETE;
            case MaterialClass.CUSTOM_7 -> Material.LIGHT_BLUE_CONCRETE;
            case MaterialClass.CUSTOM_8 -> Material.BLUE_CONCRETE;
            case MaterialClass.CUSTOM_9 -> Material.PURPLE_CONCRETE;
            case MaterialClass.CUSTOM_10 -> Material.MAGENTA_CONCRETE;
        }).name("&eWhich material class should it be?").lore("&fMaterial class set to &e" + String.valueOf((Object)this.materialClass), "&fMaterial classes affect which", "&fsmithing exp multiplier and", "&fquality values are used.").get()).map(new HashSet());
    }

    @Override
    public ItemStack getModifierIcon() {
        return new ItemBuilder(Material.DIAMOND_BLOCK).get();
    }

    @Override
    public String getDisplayName() {
        return "&eMaterial Class";
    }

    @Override
    public String getDescription() {
        return "&fChanges the material class of an item.";
    }

    @Override
    public String getActiveDescription() {
        return "&fMaterial class set to &e" + String.valueOf((Object)this.materialClass);
    }

    @Override
    public Collection<String> getCategories() {
        return Set.of(ModifierCategoryRegistry.ITEM_MISC.id());
    }

    public void setMaterialClass(MaterialClass materialClass) {
        this.materialClass = materialClass;
    }

    @Override
    public DynamicItemModifier copy() {
        ItemMaterialClass m = new ItemMaterialClass(this.getName());
        m.setMaterialClass(this.materialClass);
        m.setPriority(this.getPriority());
        return m;
    }

    @Override
    public String parseCommand(CommandSender executor, String[] args) {
        if (args.length != 1) {
            return "You must indicate the material class to set the item to";
        }
        try {
            this.materialClass = MaterialClass.valueOf(args[0]);
        }
        catch (IllegalArgumentException ignored) {
            return "Invalid weight class, valid classes are: " + Arrays.stream(MaterialClass.values()).map(Enum::toString).collect(Collectors.joining(", "));
        }
        return null;
    }

    @Override
    public List<String> commandSuggestions(CommandSender executor, int currentArg) {
        if (currentArg == 0) {
            return Arrays.stream(MaterialClass.values()).map(Enum::toString).toList();
        }
        return null;
    }

    @Override
    public int commandArgsRequired() {
        return 1;
    }
}

