/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.implementations.item_stats;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import me.athlaeos.valhallammo.commands.Command;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.DynamicItemModifier;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierCategoryRegistry;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierContext;
import me.athlaeos.valhallammo.dom.Pair;
import me.athlaeos.valhallammo.item.ItemAttributesRegistry;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.item.item_attributes.AttributeWrapper;
import me.athlaeos.valhallammo.utility.StringUtils;
import org.bukkit.Material;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.command.CommandSender;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class DefaultAttributeAdd
extends DynamicItemModifier {
    private final String attribute;
    private double value = 0.0;
    private boolean hidden = false;
    private boolean add = false;
    private AttributeModifier.Operation operation = AttributeModifier.Operation.ADD_NUMBER;
    private final double smallIncrement;
    private final double bigIncrement;
    private final Material icon;

    public DefaultAttributeAdd(String name, String attribute, double smallIncrement, double bigIncrement, Material icon) {
        super(name);
        this.attribute = attribute;
        this.smallIncrement = smallIncrement;
        this.bigIncrement = bigIncrement;
        this.icon = icon;
    }

    @Override
    public void processItem(ModifierContext context) {
        AttributeWrapper existingAttribute;
        AttributeWrapper attribute = ItemAttributesRegistry.getCopy(this.attribute);
        double extraValue = 0.0;
        if (this.add && (existingAttribute = ItemAttributesRegistry.getStats(context.getItem().getMeta(), false).get(this.attribute)) != null && (!existingAttribute.isVanilla() || existingAttribute.getOperation() == this.operation)) {
            extraValue = existingAttribute.getValue();
        }
        attribute.setValue(this.value + extraValue);
        attribute.setOperation(this.operation);
        attribute.setHidden(this.hidden);
        ItemAttributesRegistry.addDefaultStat(context.getItem(), attribute);
    }

    @Override
    public void onButtonPress(InventoryClickEvent e, int button) {
        AttributeWrapper attribute = ItemAttributesRegistry.getCopy(this.attribute);
        if (button == 7) {
            this.add = !this.add;
        } else if (button == 11) {
            this.value = Math.min(attribute.getMax(), Math.max(attribute.getMin(), this.value + (double)(e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? this.bigIncrement : this.smallIncrement)));
        } else if (button == (attribute.isVanilla() ? 12 : 13)) {
            this.value = Math.min(attribute.getMax(), Math.max(attribute.getMin(), this.value + (double)(e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? this.bigIncrement * 10.0 : this.smallIncrement * 5.0)));
        } else if (button == 13 && attribute.isVanilla()) {
            int currentOperation = Arrays.asList(AttributeModifier.Operation.values()).indexOf(this.operation);
            currentOperation = e.isLeftClick() ? (currentOperation + 1 >= AttributeModifier.Operation.values().length ? 0 : ++currentOperation) : (currentOperation - 1 < 0 ? AttributeModifier.Operation.values().length - 1 : --currentOperation);
            this.operation = AttributeModifier.Operation.values()[currentOperation];
        } else if (button == 17) {
            this.hidden = !this.hidden;
        }
    }

    @Override
    public Map<Integer, ItemStack> getButtons() {
        AttributeWrapper attribute = ItemAttributesRegistry.getCopy(this.attribute);
        HashSet extraButtons = new HashSet();
        extraButtons.add(new Pair<Integer, ItemStack>(7, new ItemBuilder(Material.REDSTONE_TORCH).name("&dShould this stat be added to existing stats?").lore("&fKeep in mind this also sets the actualized", "&fstat on the item, so any scalings should be", "&fapplied again.", "&e" + (this.add ? "yes" : "no"), "&6Click to toggle").get()));
        extraButtons.add(new Pair<Integer, ItemStack>(attribute.isVanilla() ? 12 : 13, new ItemBuilder(Material.PAPER).name("&dHow strong should this base stat be?").lore("&f" + attribute.getAttribute().toLowerCase(Locale.US).replace("_", " ") + " &e" + attribute.getFormat().format(this.value), "&6Click to add/subtract " + 5.0 * this.smallIncrement, "&6Shift-Click to add/subtract " + 10.0 * this.bigIncrement).get()));
        if (attribute.isVanilla()) {
            extraButtons.add(new Pair<Integer, ItemStack>(13, new ItemBuilder(Material.PAPER).name("&dWhat should the attribute's operation be?").lore("&f" + StringUtils.toPascalCase(this.operation.toString().replace("_", " ")), "&6Click to cycle").get()));
        }
        extraButtons.add(new Pair<Integer, ItemStack>(17, new ItemBuilder(Material.PAPER).name("&dShould this stat be hidden?").lore("&f" + this.hidden, "&fVanilla attributes cannot be", "&fhidden unless the HIDE_ATTRIBUTES", "&fand DISPLAY_ATTRIBUTES flags are", "&fon the item as well", "&6Click to toggle ").get()));
        return new Pair<Integer, ItemStack>(11, new ItemBuilder(Material.PAPER).name("&dHow strong should this base stat be?").lore("&f" + attribute.getAttribute().toLowerCase(Locale.US).replace("_", " ") + " &e" + attribute.getFormat().format(this.value), "&6Click to add/subtract " + this.smallIncrement, "&6Shift-Click to add/subtract " + this.bigIncrement).get()).map(extraButtons);
    }

    @Override
    public ItemStack getModifierIcon() {
        return new ItemBuilder(this.icon).get();
    }

    @Override
    public String getDisplayName() {
        AttributeWrapper attribute = ItemAttributesRegistry.getCopy(this.attribute);
        return (attribute.isVanilla() ? "&bVanilla" : "&dCustom") + " Attribute: " + attribute.getAttribute().toLowerCase(Locale.US).replace("_", " ") + " (ADD)";
    }

    @Override
    public String getDescription() {
        AttributeWrapper attribute = ItemAttributesRegistry.getCopy(this.attribute);
        return "&fAdds " + attribute.getAttribute().toLowerCase(Locale.US).replace("_", " ") + " as default stat to the item. If the item has vanilla stats by default, they are applied first";
    }

    @Override
    public String getActiveDescription() {
        AttributeWrapper attribute = ItemAttributesRegistry.getCopy(this.attribute);
        return "&fAdds " + attribute.getAttribute().toLowerCase(Locale.US).replace("_", " ") + " &e" + attribute.getFormat().format(this.value) + " as default stat to the item. ";
    }

    @Override
    public Collection<String> getCategories() {
        AttributeWrapper attribute = ItemAttributesRegistry.getCopy(this.attribute);
        return attribute.isVanilla() ? Set.of(ModifierCategoryRegistry.VANILLA_ATTRIBUTES.id()) : Set.of(ModifierCategoryRegistry.CUSTOM_ATTRIBUTES.id());
    }

    public void setOperation(AttributeModifier.Operation operation) {
        this.operation = operation;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public void setAdd(boolean add) {
        this.add = add;
    }

    @Override
    public DynamicItemModifier copy() {
        DefaultAttributeAdd m = new DefaultAttributeAdd(this.getName(), this.attribute, this.smallIncrement, this.bigIncrement, this.icon);
        m.setOperation(this.operation);
        m.setValue(this.value);
        m.setHidden(this.hidden);
        m.setAdd(this.add);
        m.setPriority(this.getPriority());
        return m;
    }

    @Override
    public String parseCommand(CommandSender executor, String[] args) {
        if (args.length != 3) {
            return "Three arguments expected: a number, an operation, and a boolean";
        }
        try {
            this.value = StringUtils.parseDouble(args[0]);
            this.operation = AttributeModifier.Operation.valueOf((String)args[1]);
            this.hidden = Boolean.parseBoolean(args[2]);
        }
        catch (NumberFormatException ignored) {
            return "Three arguments expected: a number, an operation, and a boolean. Invalid number";
        }
        catch (IllegalArgumentException ignored) {
            return "Three arguments expected: a number, an operation, and a boolean. Invalid operation or booleangiven";
        }
        return null;
    }

    @Override
    public List<String> commandSuggestions(CommandSender executor, int currentArg) {
        if (currentArg == 0) {
            return List.of("<value>");
        }
        if (currentArg == 1) {
            return Arrays.stream(AttributeModifier.Operation.values()).map(Object::toString).collect(Collectors.toList());
        }
        if (currentArg == 2) {
            return List.of("<hidden>", "true", "false");
        }
        return Command.noSubcommandArgs();
    }

    @Override
    public int commandArgsRequired() {
        return 3;
    }
}

