/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.implementations.potion_conditionals;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.DynamicItemModifier;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierCategoryRegistry;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierContext;
import me.athlaeos.valhallammo.dom.MinecraftVersion;
import me.athlaeos.valhallammo.dom.Pair;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.version.ConventionUtils;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionType;

public class PotionTypeSet
extends DynamicItemModifier {
    public static final List<PotionType> legalTypes = new ArrayList<PotionType>(List.of(PotionType.AWKWARD, PotionType.MUNDANE, PotionType.THICK));
    private PotionType potionType = MinecraftVersion.currentVersionNewerThan(MinecraftVersion.MINECRAFT_1_20_5) ? null : PotionType.valueOf((String)"UNCRAFTABLE");

    public PotionTypeSet(String name) {
        super(name);
    }

    @Override
    public void processItem(ModifierContext context) {
        ItemMeta itemMeta = context.getItem().getMeta();
        if (itemMeta instanceof PotionMeta) {
            PotionMeta meta = (PotionMeta)itemMeta;
            ValhallaMMO.getNms().setPotionType(meta, this.potionType);
        }
    }

    @Override
    public void onButtonPress(InventoryClickEvent e, int button) {
        if (button == 12) {
            int currentType = legalTypes.indexOf(this.potionType);
            currentType = e.isLeftClick() ? (currentType + 1 >= legalTypes.size() ? 0 : ++currentType) : (currentType - 1 < 0 ? legalTypes.size() - 1 : --currentType);
            this.potionType = legalTypes.get(currentType);
        }
    }

    @Override
    public Map<Integer, ItemStack> getButtons() {
        return new Pair<Integer, ItemStack>(12, new ItemBuilder(Material.POTION).name("&eWhich potion type should it be?").lore("&fPotion class set to &e" + String.valueOf(this.potionType), "&fUsed in further condition checking.", "&6Click to cycle").get()).map(new HashSet());
    }

    @Override
    public ItemStack getModifierIcon() {
        return new ItemBuilder(Material.POTION).flag(ConventionUtils.getHidePotionEffectsFlag()).get();
    }

    @Override
    public String getDisplayName() {
        return "&dSet Potion Type";
    }

    @Override
    public String getDescription() {
        return "&fChanges the potion type of the potion";
    }

    @Override
    public String getActiveDescription() {
        return "&fPotion type set to &e" + String.valueOf(this.potionType);
    }

    @Override
    public Collection<String> getCategories() {
        return Set.of(ModifierCategoryRegistry.POTION_CONDITIONALS.id());
    }

    @Override
    public DynamicItemModifier copy() {
        PotionTypeSet m = new PotionTypeSet(this.getName());
        m.setPriority(this.getPriority());
        return m;
    }

    @Override
    public String parseCommand(CommandSender executor, String[] args) {
        if (args.length != 1) {
            return "You must indicate the potion type to set the item to";
        }
        try {
            PotionType type = PotionType.valueOf((String)args[0]);
            if (!legalTypes.contains(type)) {
                return "Invalid potion type";
            }
            this.potionType = type;
        }
        catch (IllegalArgumentException ignored) {
            return "Invalid potion type";
        }
        return null;
    }

    @Override
    public List<String> commandSuggestions(CommandSender executor, int currentArg) {
        if (currentArg == 0) {
            return legalTypes.stream().map(Enum::toString).toList();
        }
        return null;
    }

    @Override
    public int commandArgsRequired() {
        return 1;
    }

    static {
        if (!MinecraftVersion.currentVersionNewerThan(MinecraftVersion.MINECRAFT_1_20_5)) {
            legalTypes.add(PotionType.valueOf((String)"UNCRAFTABLE"));
        }
    }
}

