/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.implementations.rewards;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.DynamicItemModifier;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierCategoryRegistry;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierContext;
import me.athlaeos.valhallammo.dom.Pair;
import me.athlaeos.valhallammo.hooks.VaultHook;
import me.athlaeos.valhallammo.hooks.VaultTransaction;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.utility.StringUtils;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class Money
extends DynamicItemModifier {
    private double amount = 300.0;

    public Money(String name) {
        super(name);
    }

    @Override
    public void processItem(ModifierContext context) {
        if (!context.shouldExecuteUsageMechanics() || !ValhallaMMO.isHookFunctional(VaultHook.class)) {
            return;
        }
        VaultTransaction.addBalance(context.getCrafter(), this.amount * (double)context.getTimesExecuted());
    }

    @Override
    public void onButtonPress(InventoryClickEvent e, int button) {
        if (button == 10) {
            this.amount = Math.max(0.0, this.amount + (double)(e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? 0.1 : 0.01));
        } else if (button == 11) {
            this.amount = Math.max(0.0, this.amount + (double)(e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? 10.0 : 1.0));
        } else if (button == 12) {
            this.amount = Math.max(0.0, this.amount + (double)(e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? 1000.0 : 100.0));
        } else if (button == 13) {
            this.amount = Math.max(0.0, this.amount + (double)(e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? 100000.0 : 10000.0));
        } else if (button == 14) {
            this.amount = Math.max(0.0, this.amount + (double)(e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? 1.0E7 : 1000000.0));
        } else if (button == 15) {
            this.amount = Math.max(0.0, this.amount + (double)(e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? 1.0E9 : 1.0E8));
        } else if (button == 16) {
            this.amount = Math.max(0.0, this.amount + (double)(e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? 1.0E11 : 1.0E10));
        } else if (button == 17) {
            this.amount = Math.max(0.0, this.amount + (double)(e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? 1.0E13 : 1.0E12));
        } else if (button == 18) {
            this.amount = Math.max(0.0, this.amount + (double)(e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? 1.0E15 : 1.0E14));
        } else if (button == 19) {
            this.amount = Math.max(0.0, this.amount + (double)(e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? 1.0E17 : 1.0E16));
        }
    }

    @Override
    public Map<Integer, ItemStack> getButtons() {
        return new Pair<Integer, ItemStack>(10, new ItemBuilder(Material.IRON_NUGGET).name("&eHow much money should be given?").lore(String.format("&fSet to &e%,.2f$", this.amount), "&6Click to add/subtract 0.01$", "&6Shift-Click to add/subtract 0.1$").get()).map(Set.of(new Pair<Integer, ItemStack>(11, new ItemBuilder(Material.IRON_INGOT).name("&eHow much money should be given?").lore(String.format("&fSet to &e%,.2f$", this.amount), "&6Click to add/subtract 1$", "&6Shift-Click to add/subtract 10$").get()), new Pair<Integer, ItemStack>(12, new ItemBuilder(Material.IRON_BLOCK).name("&eHow much money should be given?").lore(String.format("&fSet to &e%,.2f$", this.amount), "&6Click to add/subtract 100$", "&6Shift-Click to add/subtract 1K$").get()), new Pair<Integer, ItemStack>(13, new ItemBuilder(Material.GOLD_NUGGET).name("&eHow much money should be given?").lore(String.format("&fSet to &e%,.2f$", this.amount), "&6Click to add/subtract 10K$", "&6Shift-Click to add/subtract 100K$").get()), new Pair<Integer, ItemStack>(14, new ItemBuilder(Material.GOLD_INGOT).name("&eHow much money should be given?").lore(String.format("&fSet to &e%,.2f$", this.amount), "&6Click to add/subtract 1M$", "&6Shift-Click to add/subtract 10M$").get()), new Pair<Integer, ItemStack>(15, new ItemBuilder(Material.GOLD_BLOCK).name("&eHow much money should be given?").lore(String.format("&fSet to &e%,.2f$", this.amount), "&6Click to add/subtract 100M$", "&6Shift-Click to add/subtract 1B$").get()), new Pair<Integer, ItemStack>(16, new ItemBuilder(Material.DIAMOND).name("&eHow much money should be given?").lore(String.format("&fSet to &e%,.2f$", this.amount), "&6Click to add/subtract 10B$", "&6Shift-Click to add/subtract 100B$").get()), new Pair<Integer, ItemStack>(17, new ItemBuilder(Material.DIAMOND_BLOCK).name("&eHow much money should be given?").lore(String.format("&fSet to &e%,.2f$", this.amount), "&6Click to add/subtract 1T$", "&6Shift-Click to add/subtract 10T$").get()), new Pair<Integer, ItemStack>(18, new ItemBuilder(Material.NETHERITE_INGOT).name("&eHow much money should be given?").lore(String.format("&fSet to &e%,.2f$", this.amount), "&6Click to add/subtract 100T$", "&6Shift-Click to add/subtract 1Q$").get()), new Pair<Integer, ItemStack>(19, new ItemBuilder(Material.NETHERITE_BLOCK).name("&eHow much money should be given?").lore(String.format("&fSet to &e%,.2f$", this.amount), "&6Click to add/subtract 10Q$", "&6Shift-Click to add/subtract 100Q$").get())));
    }

    @Override
    public boolean requiresPlayer() {
        return true;
    }

    @Override
    public ItemStack getModifierIcon() {
        return new ItemBuilder(Material.GOLD_NUGGET).get();
    }

    @Override
    public String getDisplayName() {
        return "&2MONEY!!";
    }

    @Override
    public String getDescription() {
        return "&fGives the player an amount of cash";
    }

    @Override
    public String getActiveDescription() {
        return String.format("&fGives the player %,.2f$", this.amount);
    }

    @Override
    public Collection<String> getCategories() {
        return Set.of(ModifierCategoryRegistry.REWARDS.id());
    }

    public void setAmount(double amount) {
        this.amount = amount;
    }

    @Override
    public DynamicItemModifier copy() {
        Money m = new Money(this.getName());
        m.setAmount(this.amount);
        m.setPriority(this.getPriority());
        return m;
    }

    @Override
    public String parseCommand(CommandSender executor, String[] args) {
        if (args.length != 1) {
            return "One argument is expected: a double";
        }
        try {
            this.amount = StringUtils.parseDouble(args[0]);
        }
        catch (NumberFormatException ignored) {
            return "One argument is expected: a double. It was not a number";
        }
        return null;
    }

    @Override
    public List<String> commandSuggestions(CommandSender executor, int currentArg) {
        if (currentArg == 0) {
            return List.of("<amount>");
        }
        return null;
    }

    @Override
    public int commandArgsRequired() {
        return 1;
    }
}

