/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.crafting.recipetypes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.DynamicItemModifier;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierContext;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ResultChangingModifier;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.SlotEntry;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.implementations.MaterialChoice;
import me.athlaeos.valhallammo.crafting.recipetypes.ValhallaKeyedRecipe;
import me.athlaeos.valhallammo.crafting.recipetypes.ValhallaRecipe;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.Utils;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.BlastingRecipe;
import org.bukkit.inventory.CampfireRecipe;
import org.bukkit.inventory.CookingRecipe;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.SmokingRecipe;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class DynamicCookingRecipe
implements ValhallaRecipe,
ValhallaKeyedRecipe {
    private final NamespacedKey key;
    private final String name;
    private String displayName = null;
    private String description = null;
    private SlotEntry input = new SlotEntry(new ItemBuilder(Material.IRON_ORE).name("&r&fReplace me!").lore("&7I'm just a placeholder &einput&7 item!").get(), new MaterialChoice());
    private ItemStack result = new ItemBuilder(Material.IRON_INGOT).name("&r&fReplace me!").lore("&7I'm just a placeholder &eresult&7 item!").get();
    private boolean tinker = false;
    private int cookTime = 200;
    private boolean hiddenFromBook = false;
    private boolean requireValhallaTools = false;
    private List<DynamicItemModifier> modifiers = new ArrayList<DynamicItemModifier>();
    private float experience = 1.0f;
    private Collection<String> validations = new HashSet<String>();
    private boolean unlockedForEveryone = false;
    private final CookingRecipeType type;

    public DynamicCookingRecipe(String name, CookingRecipeType type) {
        this.name = name;
        this.key = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "cookingrecipe_" + name);
        this.type = type;
    }

    @Override
    @NotNull
    public NamespacedKey getKey() {
        return this.key;
    }

    @Override
    public void registerRecipe() {
        CookingRecipe<?> recipe = this.generateRecipe();
        if (ValhallaMMO.getInstance().getServer().getRecipe(this.key) != null) {
            ValhallaMMO.getInstance().getServer().removeRecipe(this.key);
        }
        if (recipe != null) {
            ValhallaMMO.getInstance().getServer().addRecipe(recipe);
        }
    }

    @Override
    public void unregisterRecipe() {
        if (ValhallaMMO.getInstance().getServer().getRecipe(this.key) != null) {
            ValhallaMMO.getInstance().getServer().removeRecipe(this.key);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public SlotEntry getInput() {
        return this.input;
    }

    @Override
    public ItemStack getResult() {
        return this.result;
    }

    public boolean tinker() {
        return this.tinker;
    }

    public int getCookTime() {
        return this.cookTime;
    }

    public boolean requireValhallaTools() {
        return this.requireValhallaTools;
    }

    public List<DynamicItemModifier> getModifiers() {
        return this.modifiers;
    }

    public float getExperience() {
        return this.experience;
    }

    public Collection<String> getValidations() {
        return this.validations;
    }

    @Override
    public boolean isUnlockedForEveryone() {
        return this.unlockedForEveryone;
    }

    public CookingRecipeType getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public boolean isHiddenFromBook() {
        return this.hiddenFromBook;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setInput(SlotEntry input) {
        this.input = input;
    }

    public void setResult(ItemStack result) {
        this.result = result;
    }

    public void setTinker(boolean tinker) {
        this.tinker = tinker;
    }

    public void setCookTime(int cookTime) {
        this.cookTime = cookTime;
    }

    public void setRequireValhallaTools(boolean requireValhallaTools) {
        this.requireValhallaTools = requireValhallaTools;
    }

    public void setModifiers(List<DynamicItemModifier> modifiers) {
        this.modifiers = modifiers;
        DynamicItemModifier.sortModifiers(this.modifiers);
    }

    public void setExperience(float experience) {
        this.experience = experience;
    }

    public void setValidations(Collection<String> validations) {
        this.validations = validations;
    }

    public void setUnlockedForEveryone(boolean unlockedForEveryone) {
        this.unlockedForEveryone = unlockedForEveryone;
    }

    public void setHiddenFromBook(boolean hiddenFromBook) {
        this.hiddenFromBook = hiddenFromBook;
    }

    public CookingRecipe<?> generateRecipe() {
        if (this.input == null || ItemUtils.isEmpty(this.input.getItem()) || ItemUtils.isEmpty(this.result)) {
            return null;
        }
        if (this.input.getOption() == null) {
            this.input.setOption(new MaterialChoice());
        }
        ItemStack i = this.tinker ? this.input.getItem() : this.result.clone();
        ResultChangingModifier changer = this.modifiers.stream().filter(m -> m instanceof ResultChangingModifier).reduce((first, second) -> second).orElse(null);
        if (changer != null) {
            i = Utils.thisorDefault(changer.getNewResult(ModifierContext.builder(new ItemBuilder(i)).get()), i);
        }
        i = new ItemBuilder(i).translate().get();
        return switch (this.type.ordinal()) {
            case 0 -> new SmokingRecipe(this.key, i, this.input.getOption().getChoice(this.input.getItem()), this.experience, this.cookTime);
            case 2 -> new BlastingRecipe(this.key, i, this.input.getOption().getChoice(this.input.getItem()), this.experience, this.cookTime);
            case 3 -> new CampfireRecipe(this.key, i, this.input.getOption().getChoice(this.input.getItem()), this.experience, this.cookTime);
            default -> new FurnaceRecipe(this.key, i, this.input.getOption().getChoice(this.input.getItem()), this.experience, this.cookTime);
        };
    }

    private ItemStack recipeBookIcon(ItemStack i) {
        List<String> def = TranslationManager.getListTranslation("default_recipe_description_cooking");
        String tinkerFormat = TranslationManager.getTranslation("tinker_result_format");
        ItemBuilder result = new ItemBuilder(this.result);
        return new ItemBuilder(i).lore(Arrays.asList(this.description == null ? def.toArray(new String[0]) : this.description.replace("%input%", SlotEntry.toString(this.input)).replace("%tinker%", this.tinker ? SlotEntry.toString(this.input) : ItemUtils.getItemName(result)).replace("%result%", this.tinker ? tinkerFormat.replace("%item%", SlotEntry.toString(this.input)) : ItemUtils.getItemName(result)).split("/n"))).name(this.displayName == null ? (this.tinker ? tinkerFormat.replace("%item%", SlotEntry.toString(this.input)) : ItemUtils.getItemName(result)) : this.displayName).translate().get();
    }

    public static enum CookingRecipeType {
        SMOKER("smoking"),
        FURNACE("furnace"),
        BLAST_FURNACE("blasting"),
        CAMPFIRE("campfire");

        private final String category;

        private CookingRecipeType(String category) {
            this.category = category;
        }

        public String getCategory() {
            return this.category;
        }
    }
}

