/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.gui;

import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.configuration.ConfigManager;
import me.athlaeos.valhallammo.gui.MenuListener;
import me.athlaeos.valhallammo.gui.PlayerMenuUtility;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public abstract class Menu {
    protected Inventory inventory;
    protected PlayerMenuUtility playerMenuUtility;

    public Menu(PlayerMenuUtility playerMenuUtility) {
        this.playerMenuUtility = playerMenuUtility;
    }

    public abstract String getMenuName();

    public abstract int getSlots();

    public abstract void handleMenu(InventoryClickEvent var1);

    public abstract void handleMenu(InventoryDragEvent var1);

    public abstract void setMenuItems();

    public void open() {
        this.inventory = Bukkit.createInventory(null, (int)this.getSlots(), (String)this.getMenuName());
        this.setMenuItems();
        MenuListener.setActiveMenu(this.playerMenuUtility.getOwner(), this);
        this.playerMenuUtility.getOwner().openInventory(this.inventory);
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    protected static ItemStack getButtonData(String path, Material def) {
        return Menu.getButtonData(path, "gui_details.yml", def);
    }

    protected static ItemStack getButtonData(String path, String config, Material def) {
        String value = ConfigManager.getConfig(config).get().getString(path, "");
        if (StringUtils.isEmpty(value)) {
            ValhallaMMO.logWarning(config + ":" + path + " was called, but has no value!");
        }
        return ItemUtils.parseCustomModelItem(value, def);
    }

    public void onClose() {
    }

    public PlayerMenuUtility getPlayerMenuUtility() {
        return this.playerMenuUtility;
    }
}

