/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.gui.implementations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.crafting.CustomRecipeRegistry;
import me.athlaeos.valhallammo.crafting.blockvalidations.Validation;
import me.athlaeos.valhallammo.crafting.blockvalidations.ValidationRegistry;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.DynamicItemModifier;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.IngredientChoice;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.RecipeOption;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.SlotEntry;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.implementations.MaterialChoice;
import me.athlaeos.valhallammo.crafting.recipetypes.DynamicCookingRecipe;
import me.athlaeos.valhallammo.dom.Action;
import me.athlaeos.valhallammo.dom.Question;
import me.athlaeos.valhallammo.dom.Questionnaire;
import me.athlaeos.valhallammo.gui.Menu;
import me.athlaeos.valhallammo.gui.PlayerMenuUtility;
import me.athlaeos.valhallammo.gui.SetModifiersMenu;
import me.athlaeos.valhallammo.gui.SetRecipeOptionMenu;
import me.athlaeos.valhallammo.gui.SetValidationsMenu;
import me.athlaeos.valhallammo.gui.implementations.DynamicModifierMenu;
import me.athlaeos.valhallammo.gui.implementations.RecipeOptionMenu;
import me.athlaeos.valhallammo.gui.implementations.RecipeOverviewMenu;
import me.athlaeos.valhallammo.gui.implementations.ValidationSelectionMenu;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.StringUtils;
import me.athlaeos.valhallammo.utility.Utils;
import me.athlaeos.valhallammo.version.EnchantmentMappings;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.DragType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;

public class CookingRecipeEditor
extends Menu
implements SetModifiersMenu,
SetRecipeOptionMenu,
SetValidationsMenu {
    private static final NamespacedKey BUTTON_ACTION_KEY = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "button_action");
    private static final int inputIndex = 21;
    private static final int resultIndex = 23;
    private static final ItemStack filler = new ItemBuilder(Material.GRAY_STAINED_GLASS_PANE).name("&r").get();
    private final DynamicCookingRecipe recipe;
    private final DynamicCookingRecipe.CookingRecipeType type;
    private SlotEntry input;
    private ItemStack result;
    private boolean requireValhallaTools;
    private boolean tinker;
    private List<DynamicItemModifier> modifiers;
    private boolean unlockedForEveryone;
    private boolean hidden;
    private int cookTime;
    private float experience;
    private Collection<String> validations;
    private String displayName;
    private String description;
    private static final ItemStack toggleValhallaToolRequirementButton = new ItemBuilder(CookingRecipeEditor.getButtonData("editor_recipe_cooking_valhallatoolrequirement", Material.DIAMOND_PICKAXE)).name("&eValhalla Tools").stringTag(BUTTON_ACTION_KEY, "toggleValhallaToolRequirementButton").lore("&7If enabled, the armors or tools", "&7in the recipe need to have ValhallaMMO ", "&7custom attributes. If disabled, vanilla ", "&7equipment can be used too.", "&eClick to toggle on/off").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack toggleTinkerButton = new ItemBuilder(CookingRecipeEditor.getButtonData("editor_recipe_cooking_toggletinker", Material.ANVIL)).name("&eTinker Tools").stringTag(BUTTON_ACTION_KEY, "toggleTinkerButton").lore("&7If enabled, the recipe will", "&7improve the input item of the recipe.", "&7Otherwise, it will simply produce the", "&7item specified as the result.", "&eClick to toggle on/off").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack toggleHiddenButton = new ItemBuilder(CookingRecipeEditor.getButtonData("editor_recipe_cooking_togglehidden", Material.ANVIL)).name("&eHidden from Recipe Book").stringTag(BUTTON_ACTION_KEY, "toggleHiddenButton").lore("&7If enabled, the recipe will", "&7not be visible in the recipe book.", "&eClick to toggle on/off").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack selectValidationButton = new ItemBuilder(CookingRecipeEditor.getButtonData("editor_recipe_cooking_selectvalidation", Material.BARRIER)).name("&eBlock condition").stringTag(BUTTON_ACTION_KEY, "selectValidationButton").lore("&7Block conditions are checks", "&7to allow/disallow recipes based on", "&7block environment.", "&7These conditions may also change", "&7the environment after crafting.", "&eClick to open the menu", "&8&m                <>                ", "%description%").get();
    private static final ItemStack cookTimeButton = new ItemBuilder(CookingRecipeEditor.getButtonData("editor_recipe_cooking_cooktime", Material.CLOCK)).name("&eCooking Time").stringTag(BUTTON_ACTION_KEY, "cookTimeButton").lore("&7How long it takes to cook this item.", "&7Typical campfire time: &a600 ticks", "&7Typical furnace time: &a200 ticks", "&7Typical blasting/smoking time: &a100 ticks", "&eClick to increase/decrease by 1 tick", "&eShift-click to increase/decrease by 20 ticks").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack experienceButton = new ItemBuilder(CookingRecipeEditor.getButtonData("editor_recipe_cooking_experience", Material.EXPERIENCE_BOTTLE)).name("&aExperience").stringTag(BUTTON_ACTION_KEY, "experienceButton").lore("&7How much EXP is rewarded on cooking.", "&7Typically cooking recipes provide", "&a1 experience &7per cook.", "&eClick to increase/decrease by 0.1", "&eShift-click to increase/decrease by 1").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack modifierButton = new ItemBuilder(CookingRecipeEditor.getButtonData("editor_recipe_cooking_modifiers", Material.WRITABLE_BOOK)).name("&dDynamic Item Modifiers").stringTag(BUTTON_ACTION_KEY, "modifierButton").lore("&7Modifiers are functions to edit", "&7the output item based on player", "&7stats or to apply crafting conditions.", "&eClick to open the menu", "&8&m                <>                ", "%modifiers%").get();
    private static final ItemStack recipeOptionsButton = new ItemBuilder(CookingRecipeEditor.getButtonData("editor_recipe_cooking_recipeoptions", Material.WRITABLE_BOOK)).name("&bIngredient Options").stringTag(BUTTON_ACTION_KEY, "recipeOptionsButton").lore("&7Ingredient options are ingredient", "&7flags you can put on an ingredient", "&7to change its behavior during crafting.", "&eClick to open the menu").get();
    private static final ItemStack toggleUnlockedForEveryoneButton = new ItemBuilder(CookingRecipeEditor.getButtonData("editor_recipe_cooking_unlockedforeveryone", Material.PAPER)).name("&eUnlocked for Everyone").stringTag(BUTTON_ACTION_KEY, "toggleUnlockedForEveryoneButton").lore("&7If enabled, the recipe will", "&7available to everyone regardless", "&7if unlocked or not. Otherwise it", "&7will have to be unlocked through", "&7perk rewards.", "&eClick to toggle on/off").get();
    private static final ItemStack setDisplayNameButton = new ItemBuilder(CookingRecipeEditor.getButtonData("editor_recipe_cooking_setdisplayname", Material.NAME_TAG)).name("&aSet Display Name").stringTag(BUTTON_ACTION_KEY, "setDisplayNameButton").lore("&7Sets the display name of the recipe.", "&7The display name is visible in the", "&7recipe book and is usually used", "&7to roughly describe the purpose of", "&7tinkering recipes since the output is", "&7non-descriptive.", "&eLeft-Click to set display name", "&cRight-Click to nullify display name", "&7A nullified display name defaults to", "&7the name of the input/output", "&8&m                <>                ", "&7Currently set to: %display_name%").get();
    private static final ItemStack setDescriptionButton = new ItemBuilder(CookingRecipeEditor.getButtonData("editor_recipe_cooking_setdescription", Material.WRITABLE_BOOK)).name("&aSet Description").stringTag(BUTTON_ACTION_KEY, "setDescriptionButton").lore("&7Sets the description of the recipe.", "&7The description is visible in the", "&7recipe book as lore.", "&eLeft-Click to set description", "&cRight-Click to nullify description", "&7A nullified description defaults to", "&7a default default recipe format in", "&7the language file.", "&8&m                <>                ", "&7Currently set to: %description%").get();
    private static final ItemStack confirmButton = new ItemBuilder(CookingRecipeEditor.getButtonData("editor_save", Material.STRUCTURE_VOID)).name("&aConfirm").stringTag(BUTTON_ACTION_KEY, "confirmButton").lore("&aRight-click &7to save changes").get();
    private boolean confirmDeletion = false;
    private static final ItemStack deleteButton = new ItemBuilder(CookingRecipeEditor.getButtonData("editor_delete", Material.BARRIER)).stringTag(BUTTON_ACTION_KEY, "deleteButton").name("&cDelete Recipe").get();
    private static final ItemStack deleteConfirmButton = new ItemBuilder(CookingRecipeEditor.getButtonData("editor_deleteconfirm", Material.BARRIER)).name("&cDelete Recipe").stringTag(BUTTON_ACTION_KEY, "deleteConfirmButton").enchant(EnchantmentMappings.UNBREAKING.getEnchantment(), 1).lore("&aRight-click &7to confirm recipe deletion").flag(ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ENCHANTS).get();
    private static final ItemStack backToMenuButton = new ItemBuilder(CookingRecipeEditor.getButtonData("editor_backtomenu", Material.BOOK)).stringTag(BUTTON_ACTION_KEY, "backToMenuButton").name("&fBack to Menu").get();

    public CookingRecipeEditor(PlayerMenuUtility playerMenuUtility, DynamicCookingRecipe recipe) {
        super(playerMenuUtility);
        IngredientChoice ingredientChoice;
        this.type = recipe.getType();
        this.recipe = recipe;
        this.input = recipe.getInput();
        IngredientChoice ingredientChoice2 = this.input.getOption();
        if (ingredientChoice2 instanceof RecipeOption) {
            RecipeOption o = (RecipeOption)ingredientChoice2;
            ingredientChoice = o.getNew();
        } else {
            ingredientChoice = this.input.getOption();
        }
        this.input.setOption(ingredientChoice);
        this.result = recipe.getResult();
        this.requireValhallaTools = recipe.requireValhallaTools();
        this.tinker = recipe.tinker();
        this.cookTime = recipe.getCookTime();
        this.experience = recipe.getExperience();
        this.modifiers = recipe.getModifiers();
        this.unlockedForEveryone = recipe.isUnlockedForEveryone();
        this.validations = recipe.getValidations();
        this.displayName = recipe.getDisplayName();
        this.description = recipe.getDescription();
        this.hidden = recipe.isHiddenFromBook();
    }

    public CookingRecipeEditor(PlayerMenuUtility playerMenuUtility, DynamicCookingRecipe recipe, String newName) {
        super(playerMenuUtility);
        this.type = recipe.getType();
        this.recipe = new DynamicCookingRecipe(newName, recipe.getType());
        this.input = new SlotEntry(recipe.getInput().getItem().clone(), recipe.getInput().getOption());
        this.result = recipe.getResult().clone();
        this.requireValhallaTools = recipe.requireValhallaTools();
        this.tinker = recipe.tinker();
        this.cookTime = recipe.getCookTime();
        this.experience = recipe.getExperience();
        this.modifiers = new ArrayList<DynamicItemModifier>(recipe.getModifiers().stream().map(DynamicItemModifier::copy).toList());
        this.unlockedForEveryone = recipe.isUnlockedForEveryone();
        this.validations = new HashSet<String>(recipe.getValidations());
        this.displayName = recipe.getDisplayName();
        this.description = recipe.getDescription();
        this.hidden = recipe.isHiddenFromBook();
    }

    @Override
    public String getMenuName() {
        return Utils.chat(ValhallaMMO.isResourcePackConfigForced() ? "&f\uf808\uf202\uf80c\uf80a\uf808\uf802&8%recipe%" : TranslationManager.getTranslation("editormenu_cookingrecipes")).replace("%recipe%", this.recipe.getName());
    }

    @Override
    public int getSlots() {
        return 54;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        e.setCancelled(!(e.getClickedInventory() instanceof PlayerInventory));
        ItemStack cursor = e.getCursor();
        ItemStack clicked = e.getCurrentItem();
        String action = ItemUtils.getPDCString(BUTTON_ACTION_KEY, clicked, "");
        if (!StringUtils.isEmpty(action)) {
            switch (action) {
                case "backToMenuButton": {
                    new RecipeOverviewMenu(this.playerMenuUtility, this.type.getCategory()).open();
                    return;
                }
                case "modifierButton": {
                    this.playerMenuUtility.setPreviousMenu(this);
                    new DynamicModifierMenu(this.playerMenuUtility, this).open();
                    return;
                }
                case "recipeOptionsButton": {
                    this.playerMenuUtility.setPreviousMenu(this);
                    new RecipeOptionMenu(this.playerMenuUtility, this).open();
                    return;
                }
                case "deleteButton": {
                    this.confirmDeletion = true;
                    Utils.sendMessage((CommandSender)e.getWhoClicked(), "&cAre you sure you want to delete this recipe?");
                    this.setMenuItems();
                    return;
                }
                case "deleteConfirmButton": {
                    if (!e.isRightClick()) break;
                    CustomRecipeRegistry.unregister(this.recipe.getName());
                    new RecipeOverviewMenu(this.playerMenuUtility, this.type.getCategory()).open();
                    return;
                }
                case "selectValidationButton": {
                    this.playerMenuUtility.setPreviousMenu(this);
                    new ValidationSelectionMenu(this.playerMenuUtility, this, switch (this.type) {
                        default -> throw new IncompatibleClassChangeError();
                        case DynamicCookingRecipe.CookingRecipeType.CAMPFIRE -> Material.CAMPFIRE;
                        case DynamicCookingRecipe.CookingRecipeType.BLAST_FURNACE -> Material.BLAST_FURNACE;
                        case DynamicCookingRecipe.CookingRecipeType.SMOKER -> Material.SMOKER;
                        case DynamicCookingRecipe.CookingRecipeType.FURNACE -> Material.FURNACE;
                    }).open();
                    return;
                }
                case "setDisplayNameButton": {
                    if (e.isLeftClick()) {
                        this.playerMenuUtility.setPreviousMenu(this);
                        e.getWhoClicked().closeInventory();
                        Questionnaire questionaire = new Questionnaire((Player)e.getWhoClicked(), null, null, new Question[]{new Question("&aWhat should the display name be? (type 'cancel' to cancel)", null, "")}){

                            @Override
                            public Action<Player> getOnFinish() {
                                if (this.getQuestions().isEmpty()) {
                                    return super.getOnFinish();
                                }
                                Question question = this.getQuestions().get(0);
                                if (question.getAnswer() == null) {
                                    return super.getOnFinish();
                                }
                                return p -> {
                                    String answer = Utils.chat(question.getAnswer());
                                    if (!answer.contains("cancel")) {
                                        CookingRecipeEditor.this.displayName = answer;
                                    }
                                    CookingRecipeEditor.this.playerMenuUtility.getPreviousMenu().open();
                                };
                            }
                        };
                        Questionnaire.startQuestionnaire((Player)e.getWhoClicked(), questionaire);
                        break;
                    }
                    this.displayName = null;
                    break;
                }
                case "setDescriptionButton": {
                    if (e.isLeftClick()) {
                        this.playerMenuUtility.setPreviousMenu(this);
                        e.getWhoClicked().closeInventory();
                        Questionnaire questionnaire = new Questionnaire((Player)e.getWhoClicked(), null, null, new Question[]{new Question("&aWhat should the description be? Use '/n' to separate lines. (type 'cancel' to cancel)", null, "")}){

                            @Override
                            public Action<Player> getOnFinish() {
                                if (this.getQuestions().isEmpty()) {
                                    return super.getOnFinish();
                                }
                                Question question = this.getQuestions().get(0);
                                if (question.getAnswer() == null) {
                                    return super.getOnFinish();
                                }
                                return p -> {
                                    String answer = Utils.chat(question.getAnswer());
                                    if (!answer.contains("cancel")) {
                                        CookingRecipeEditor.this.description = answer;
                                    }
                                    CookingRecipeEditor.this.playerMenuUtility.getPreviousMenu().open();
                                };
                            }
                        };
                        Questionnaire.startQuestionnaire((Player)e.getWhoClicked(), questionnaire);
                        Utils.sendMessage((CommandSender)e.getWhoClicked(), "&aValid placeholders are:");
                        Utils.sendMessage((CommandSender)e.getWhoClicked(), "          &2%input% &afor the input item");
                        Utils.sendMessage((CommandSender)e.getWhoClicked(), "          &2%result% &afor a preformatted result");
                        Utils.sendMessage((CommandSender)e.getWhoClicked(), "          &2%tinker% &afor the raw name of the tinkered result");
                        break;
                    }
                    this.description = null;
                    break;
                }
                case "confirmButton": {
                    if (this.input == null || ItemUtils.isEmpty(this.input.getItem()) || ItemUtils.isEmpty(this.result)) {
                        Utils.sendMessage((CommandSender)e.getWhoClicked(), "&cAn input and output are required!");
                        this.setMenuItems();
                        return;
                    }
                    this.recipe.setInput(this.input);
                    this.recipe.setResult(this.result);
                    this.recipe.setModifiers(this.modifiers);
                    this.recipe.setTinker(this.tinker);
                    this.recipe.setRequireValhallaTools(this.requireValhallaTools);
                    this.recipe.setUnlockedForEveryone(this.unlockedForEveryone);
                    this.recipe.setCookTime(this.cookTime);
                    this.recipe.setExperience(this.experience);
                    this.recipe.setValidations(this.validations);
                    this.recipe.setDescription(this.description);
                    this.recipe.setDisplayName(this.displayName);
                    this.recipe.setHiddenFromBook(this.hidden);
                    CustomRecipeRegistry.register(this.recipe, true);
                    CustomRecipeRegistry.setChangesMade();
                    new RecipeOverviewMenu(this.playerMenuUtility, this.type.getCategory()).open();
                    return;
                }
                case "cookTimeButton": {
                    this.cookTime = Math.max(0, this.cookTime + (e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? 20 : 1));
                    break;
                }
                case "toggleHiddenButton": {
                    this.hidden = !this.hidden;
                    break;
                }
                case "experienceButton": {
                    this.experience = Math.max(0.0f, this.experience + (float)(e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? 1.0f : 0.1f));
                    break;
                }
                case "toggleValhallaToolRequirementButton": {
                    this.requireValhallaTools = !this.requireValhallaTools;
                    break;
                }
                case "toggleTinkerButton": {
                    this.tinker = !this.tinker;
                    break;
                }
                case "toggleUnlockedForEveryoneButton": {
                    boolean bl = this.unlockedForEveryone = !this.unlockedForEveryone;
                }
            }
        }
        if (23 == e.getRawSlot() || 21 == e.getRawSlot()) {
            if (e.getRawSlot() == 23 && !this.tinker && !ItemUtils.isEmpty(cursor)) {
                this.result = cursor.clone();
            } else if (21 == e.getRawSlot()) {
                if (!ItemUtils.isEmpty(cursor)) {
                    this.input = new SlotEntry(new ItemBuilder(cursor.clone()).amount(1).get(), new MaterialChoice());
                } else if (this.input != null) {
                    this.input.setOption(null);
                }
            }
        }
        this.confirmDeletion = false;
        this.setMenuItems();
    }

    @Override
    public void handleMenu(InventoryDragEvent e) {
        e.setCancelled(true);
        if (e.getRawSlots().size() == 1) {
            ClickType type = e.getType() == DragType.EVEN ? ClickType.LEFT : ClickType.RIGHT;
            InventoryAction action = e.getType() == DragType.EVEN ? InventoryAction.DROP_ALL_CURSOR : InventoryAction.DROP_ONE_CURSOR;
            this.handleMenu(new InventoryClickEvent(e.getView(), InventoryType.SlotType.CONTAINER, ((Integer)new ArrayList(e.getRawSlots()).get(0)).intValue(), type, action));
        }
    }

    @Override
    public void setMenuItems() {
        this.inventory.clear();
        if (!ValhallaMMO.getPluginConfig().getBoolean("admin_gui_filler_removal")) {
            for (int i = 0; i < 54; ++i) {
                this.inventory.setItem(i, filler);
            }
        }
        this.inventory.setItem(21, null);
        ItemStack icon = new ItemBuilder(this.input.getItem().clone()).appendLore(SlotEntry.getOptionLore(this.input)).get();
        this.inventory.setItem(21, icon);
        if (!this.tinker) {
            this.inventory.setItem(23, this.result.clone());
        } else {
            this.inventory.setItem(23, new ItemBuilder(this.input.getItem()).name("&dTinkered Input").get());
        }
        ArrayList<String> validationLore = new ArrayList<String>();
        if (!this.validations.isEmpty()) {
            for (String v : this.validations) {
                Validation validation = ValidationRegistry.getValidation(v);
                validationLore.add(validation.activeDescription());
            }
        } else {
            validationLore.add("&aNo special conditions required");
        }
        ArrayList<String> modifierLore = new ArrayList<String>();
        this.modifiers.forEach(m -> modifierLore.addAll(StringUtils.separateStringIntoLines("&d> " + m.getActiveDescription(), 40)));
        ItemBuilder resultBuilder = new ItemBuilder(this.result);
        String tinkerFormat = TranslationManager.getTranslation("tinker_result_format");
        List<String> description = Arrays.asList(this.description == null ? "&eDefault".split("/n") : this.description.replace("%input%", SlotEntry.toString(this.input)).replace("%tinker%", this.tinker ? SlotEntry.toString(this.input) : ItemUtils.getItemName(resultBuilder)).replace("%result%", this.tinker ? tinkerFormat.replace("%item%", SlotEntry.toString(this.input)) : ItemUtils.getItemName(resultBuilder)).split("/n"));
        this.inventory.setItem(0, new ItemBuilder(setDisplayNameButton).lore(ItemUtils.setListPlaceholder(ItemUtils.getLore(setDisplayNameButton), "%display_name%", List.of(this.displayName == null ? "&eDefault" : this.displayName))).get());
        this.inventory.setItem(1, new ItemBuilder(setDescriptionButton).lore(ItemUtils.setListPlaceholder(ItemUtils.getLore(setDescriptionButton), "%description%", description)).get());
        this.inventory.setItem(5, new ItemBuilder(toggleUnlockedForEveryoneButton).name("&eUnlocked for Everyone " + (this.unlockedForEveryone ? "&aYes" : "&fNo")).get());
        this.inventory.setItem(8, new ItemBuilder(toggleHiddenButton).name("&eHidden from Recipe Book: " + (this.hidden ? "&aYes" : "&fNo")).get());
        this.inventory.setItem(10, new ItemBuilder(selectValidationButton).lore(ItemUtils.setListPlaceholder(ItemUtils.getLore(selectValidationButton), "%description%", validationLore)).get());
        this.inventory.setItem(17, new ItemBuilder(toggleValhallaToolRequirementButton).name("&eValhalla Tools: " + (this.requireValhallaTools ? "&aYes" : "&fNo")).get());
        this.inventory.setItem(20, recipeOptionsButton);
        this.inventory.setItem(24, new ItemBuilder(modifierButton).lore(modifierLore).get());
        this.inventory.setItem(30, new ItemBuilder(cookTimeButton).name(String.format("&fTime to cook: &e%d, %ss", this.cookTime, StringUtils.toTimeStamp2(this.cookTime, 20L))).get());
        this.inventory.setItem(32, new ItemBuilder(experienceButton).name(String.format("&fExperience: &e%.1f", Float.valueOf(this.experience))).get());
        this.inventory.setItem(35, new ItemBuilder(toggleTinkerButton).name("&eTinker: " + (this.tinker ? "&aYes" : "&fNo")).get());
        this.inventory.setItem(45, this.confirmDeletion ? deleteConfirmButton : deleteButton);
        this.inventory.setItem(49, backToMenuButton);
        this.inventory.setItem(53, confirmButton);
    }

    @Override
    public void setResultModifiers(List<DynamicItemModifier> resultModifiers) {
        this.modifiers = resultModifiers;
    }

    @Override
    public List<DynamicItemModifier> getResultModifiers() {
        return this.modifiers;
    }

    @Override
    public void setRecipeOption(RecipeOption option) {
        if (option == null) {
            return;
        }
        if (!option.isCompatible(this.input.getItem()) || !option.isCompatibleWithInputItem(true)) {
            Utils.sendMessage((CommandSender)this.playerMenuUtility.getOwner(), "&cNot compatible with this item");
        } else {
            this.input.setOption(option);
        }
    }

    @Override
    public void setValidations(Collection<String> validations) {
        this.validations = validations;
    }

    @Override
    public Collection<String> getValidations() {
        return this.validations;
    }
}

