/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.gui.implementations.recipecategories;

import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.crafting.CustomRecipeRegistry;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.SlotEntry;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.implementations.MaterialChoice;
import me.athlaeos.valhallammo.dom.MinecraftVersion;
import me.athlaeos.valhallammo.gui.implementations.RecipeOverviewMenu;
import me.athlaeos.valhallammo.gui.implementations.recipecategories.RecipeCategory;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.StringUtils;
import me.athlaeos.valhallammo.utility.Utils;
import me.athlaeos.valhallammo.version.ConventionUtils;
import me.athlaeos.valhallammo.version.SmithingTransformRecipeWrapper;
import org.bukkit.ChatColor;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.CookingRecipe;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.SmithingRecipe;
import org.bukkit.plugin.Plugin;

public class DisabledRecipesCategory
extends RecipeCategory {
    private static final NamespacedKey SORT_PRIORITY = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "recipe_category_priority");
    private static final MaterialChoice choice = new MaterialChoice();

    public DisabledRecipesCategory(int position) {
        super("disabled", new ItemBuilder(Material.BARRIER).name("&cDisabled Vanilla Recipes").get(), position, Utils.chat(ValhallaMMO.isResourcePackConfigForced() ? "&f\uf808\uf30e\uf80c\uf80a\uf808\uf802" : TranslationManager.getTranslation("editormenu_recipecategory_disabled")));
    }

    @Override
    public List<ItemStack> getRecipeButtons() {
        ArrayList<ItemStack> icons = new ArrayList<ItemStack>();
        Iterator recipes = ValhallaMMO.getInstance().getServer().recipeIterator();
        while (recipes.hasNext()) {
            String prefix;
            int priority;
            Recipe recipe = (Recipe)recipes.next();
            if (!(recipe instanceof Keyed)) continue;
            Keyed k = (Keyed)recipe;
            if (ItemUtils.isEmpty(recipe.getResult()) || CustomRecipeRegistry.getAllKeyedRecipes().containsKey(k.getKey()) || !k.getKey().getNamespace().equalsIgnoreCase("minecraft")) continue;
            ArrayList<String> lore = new ArrayList<String>();
            if (recipe instanceof ShapedRecipe) {
                ShapedRecipe r = (ShapedRecipe)recipe;
                priority = 0;
                prefix = "&7[&eShaped&7] ";
                ShapeDetails details = this.getRecipeShapeStrings(r);
                for (String shapeLine : details.getShape()) {
                    lore.add("&7[&e" + shapeLine + "&7]&7");
                }
                for (Character c : details.getItems().keySet()) {
                    if (details.getItems().get(c) == null) continue;
                    lore.add("&e" + c + "&7: &e" + ItemUtils.getItemName(new ItemBuilder(details.getItems().get(c))));
                }
            } else if (recipe instanceof ShapelessRecipe) {
                ShapelessRecipe r = (ShapelessRecipe)recipe;
                priority = 1;
                prefix = "&7[&aShapeless&7] ";
                Map<SlotEntry, Integer> contents = ItemUtils.getItemTotals(r.getIngredientList().stream().map(i -> new SlotEntry((ItemStack)i, choice)).collect(Collectors.toList()));
                for (SlotEntry entry : contents.keySet()) {
                    int amount = contents.get(entry);
                    lore.add("&e" + amount + "&7x &e" + SlotEntry.toString(entry));
                }
            } else if (recipe instanceof CookingRecipe) {
                CookingRecipe r = (CookingRecipe)recipe;
                priority = 2;
                prefix = "&7[&6Cooking&7] ";
                ItemStack base = this.convertChoice(r.getInputChoice());
                lore.add("&e" + choice.ingredientDescription(base) + " &f>>> &e" + ItemUtils.getItemName(new ItemBuilder(r.getResult())));
            } else {
                if (!(recipe instanceof SmithingRecipe)) continue;
                SmithingRecipe r = (SmithingRecipe)recipe;
                priority = 3;
                prefix = "&7[&8Smithing&7] ";
                boolean templateCompatible = MinecraftVersion.currentVersionNewerThan(MinecraftVersion.MINECRAFT_1_20);
                ItemStack template = templateCompatible ? SmithingTransformRecipeWrapper.getTemplate(r) : null;
                ItemStack base = this.convertChoice(r.getBase());
                ItemStack addition = this.convertChoice(r.getAddition());
                if (templateCompatible && template != null) {
                    lore.add("&eTemplate: &f" + choice.ingredientDescription(template));
                }
                lore.add("&eBase: &f" + choice.ingredientDescription(base));
                lore.add("&eAddition: &f" + choice.ingredientDescription(addition));
                lore.add("&f&m                          &r&f =");
                lore.add("&e" + ItemUtils.getItemName(new ItemBuilder(r.getResult())));
            }
            boolean enabled = !CustomRecipeRegistry.getDisabledRecipes().contains(k.getKey());
            icons.add(new ItemBuilder(recipe.getResult()).name(prefix + (enabled ? "&a" : "&c") + StringUtils.toPascalCase(k.getKey().getKey().replace("-", " ").replace("_", " "))).lore(lore).intTag(SORT_PRIORITY, priority).flag(ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ENCHANTS, ConventionUtils.getHidePotionEffectsFlag(), ItemFlag.HIDE_DYE).stringTag(RecipeOverviewMenu.KEY_RECIPE, k.getKey().getKey()).get());
        }
        icons.sort(Comparator.comparingInt(i -> ItemUtils.getPDCInt(SORT_PRIORITY, i, 999)).thenComparing(ItemStack::getType).thenComparing(item -> ChatColor.stripColor((String)ItemUtils.getItemName(new ItemBuilder((ItemStack)item)))));
        return icons;
    }

    private ItemStack convertChoice(RecipeChoice choice) {
        if (choice instanceof RecipeChoice.MaterialChoice) {
            RecipeChoice.MaterialChoice m = (RecipeChoice.MaterialChoice)choice;
            return m.getItemStack();
        }
        if (choice instanceof RecipeChoice.ExactChoice) {
            RecipeChoice.ExactChoice m = (RecipeChoice.ExactChoice)choice;
            return m.getItemStack();
        }
        return null;
    }

    @Override
    public void onRecipeButtonClick(String recipe, Player editor) {
        try {
            NamespacedKey keyToToggle = NamespacedKey.minecraft((String)recipe);
            if (CustomRecipeRegistry.getDisabledRecipes().contains(keyToToggle)) {
                CustomRecipeRegistry.removeDisabledRecipe(keyToToggle);
            } else {
                CustomRecipeRegistry.addDisabledRecipe(keyToToggle);
            }
            CustomRecipeRegistry.setChangesMade();
            RecipeOverviewMenu.resetCache(RecipeOverviewMenu.DISABLED.getId());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private ShapeDetails getRecipeShapeStrings(ShapedRecipe recipe) {
        List<String> shape = new ArrayList<String>();
        HashBiMap ingredientMap = HashBiMap.create();
        StringBuilder usedChars = new StringBuilder();
        for (String row : recipe.getShape()) {
            StringBuilder newRow = new StringBuilder();
            for (char c : row.toCharArray()) {
                ItemStack charItem = (ItemStack)recipe.getIngredientMap().get(Character.valueOf(c));
                Character itemChar = (Character)ingredientMap.inverse().get((Object)charItem);
                if (itemChar == null) {
                    itemChar = Character.valueOf(this.getItemChar(charItem, usedChars.toString()));
                }
                newRow.append(itemChar);
                if (ingredientMap.containsValue((Object)charItem)) continue;
                usedChars.append(itemChar);
                ingredientMap.put((Object)itemChar, (Object)charItem);
            }
            shape.add(newRow.toString());
        }
        if (((String)shape.get(0)).equalsIgnoreCase("   ") && ((String)shape.get(1)).equalsIgnoreCase("   ")) {
            shape.remove(0);
            shape.remove(0);
        } else if (((String)shape.get(0)).equalsIgnoreCase("   ")) {
            shape.remove(0);
        }
        if (shape.size() == 3 && ((String)shape.get(shape.size() - 1)).equalsIgnoreCase("   ") && ((String)shape.get(shape.size() - 2)).equalsIgnoreCase("   ")) {
            shape.remove(shape.size() - 1);
            shape.remove(shape.size() - 1);
        } else if (((String)shape.get(shape.size() - 1)).equalsIgnoreCase("   ")) {
            shape.remove(shape.size() - 1);
        }
        if (shape.stream().allMatch(s -> s.endsWith("  "))) {
            shape = shape.stream().map(s -> s.substring(0, s.length() - 2)).collect(Collectors.toList());
        }
        if (shape.stream().allMatch(s -> s.endsWith(" "))) {
            shape = shape.stream().map(s -> s.substring(0, s.length() - 1)).collect(Collectors.toList());
        }
        if (shape.stream().allMatch(s -> s.startsWith("  "))) {
            shape = shape.stream().map(s -> s.substring(2)).collect(Collectors.toList());
        }
        if (shape.stream().allMatch(s -> s.startsWith(" "))) {
            shape = shape.stream().map(s -> s.substring(1)).collect(Collectors.toList());
        }
        return new ShapeDetails(shape.toArray(new String[0]), (Map<Character, ItemStack>)ingredientMap);
    }

    private char getItemChar(ItemStack i, String usedChars) {
        if (ItemUtils.isEmpty(i)) {
            return ' ';
        }
        String itemName = ChatColor.stripColor((String)ItemUtils.getItemName(new ItemBuilder(i)));
        char possibleCharacter = (itemName.isEmpty() ? i.getType().toString() : itemName).toUpperCase(Locale.US).charAt(0);
        if (usedChars.contains(String.valueOf(possibleCharacter)) && usedChars.contains(String.valueOf(possibleCharacter = i.getType().toString().toUpperCase(Locale.US).charAt(0)))) {
            for (Character c : Arrays.asList(Character.valueOf('A'), Character.valueOf('B'), Character.valueOf('C'), Character.valueOf('D'), Character.valueOf('E'), Character.valueOf('F'), Character.valueOf('G'), Character.valueOf('H'), Character.valueOf('I'))) {
                if (usedChars.contains(String.valueOf(c))) continue;
                return c.charValue();
            }
        }
        return possibleCharacter;
    }

    @Override
    public void createNew(String name, Player editor) {
    }

    private static class ShapeDetails {
        String[] shape;
        Map<Character, ItemStack> items;

        public ShapeDetails(String[] shape, Map<Character, ItemStack> items) {
            this.shape = shape;
            this.items = items;
        }

        public String[] getShape() {
            return this.shape;
        }

        public Map<Character, ItemStack> getItems() {
            return this.items;
        }
    }
}

