/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.item;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.StringUtils;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public enum CustomFlag {
    HIDE_TAGS,
    HIDE_QUALITY,
    DISPLAY_ATTRIBUTES,
    HIDE_DURABILITY,
    ATTRIBUTE_FOR_BOTH_HANDS,
    ATTRIBUTE_FOR_HELMET,
    INFINITY_EXPLOITABLE,
    UNCRAFTABLE,
    TEMPORARY_POTION_DISPLAY,
    UNENCHANTABLE,
    UNMENDABLE;

    private static final NamespacedKey FLAG;

    public static Collection<CustomFlag> getItemFlags(ItemMeta meta) {
        String[] stringFlags;
        HashSet<CustomFlag> flags = new HashSet<CustomFlag>();
        String value = ItemUtils.getPDCString(FLAG, meta, null);
        if (StringUtils.isEmpty(value)) {
            return flags;
        }
        for (String s : stringFlags = value.split(";")) {
            try {
                flags.add(CustomFlag.valueOf(s));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return flags;
    }

    public static void setItemFlags(ItemMeta meta, Collection<CustomFlag> flags) {
        if (meta == null) {
            return;
        }
        if (flags == null || flags.isEmpty()) {
            meta.getPersistentDataContainer().remove(FLAG);
        } else {
            meta.getPersistentDataContainer().set(FLAG, PersistentDataType.STRING, (Object)String.join((CharSequence)";", flags.stream().map(Enum::toString).collect(Collectors.toSet())));
        }
    }

    public static void setItemFlags(ItemMeta meta, CustomFlag ... flags) {
        CustomFlag.setItemFlags(meta, Set.of(flags));
    }

    public static boolean hasFlag(ItemMeta meta, CustomFlag flag) {
        return CustomFlag.getItemFlags(meta).contains((Object)flag);
    }

    public static void addItemFlag(ItemMeta meta, CustomFlag ... flag) {
        Collection<CustomFlag> flags = CustomFlag.getItemFlags(meta);
        flags.addAll(Set.of(flag));
        CustomFlag.setItemFlags(meta, flags);
    }

    public static void removeItemFlag(ItemMeta meta, CustomFlag flag) {
        Collection<CustomFlag> flags = CustomFlag.getItemFlags(meta);
        flags.remove((Object)flag);
        CustomFlag.setItemFlags(meta, flags);
    }

    static {
        FLAG = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "item_flags");
    }
}

