/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.item;

import java.util.HashMap;
import java.util.Map;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.dom.Scaling;
import me.athlaeos.valhallammo.utility.Utils;
import me.athlaeos.valhallammo.version.EnchantmentMappings;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.enchantments.EnchantmentOffer;

public class EnchantingItemPropertyManager {
    private static final Map<Enchantment, Scaling> enchantmentScaling = new HashMap<Enchantment, Scaling>();

    public static void registerScaling(Enchantment e, Scaling scaling) {
        if (e == null) {
            return;
        }
        if (scaling == null) {
            ValhallaMMO.logWarning("Could not register scaling for " + String.valueOf(e) + ", it's not a valid enchantment!");
            return;
        }
        enchantmentScaling.put(e, scaling);
    }

    public static Scaling getScaling(Enchantment enchantment) {
        return enchantmentScaling.get(enchantment);
    }

    public static int getScaledLevel(Enchantment enchantment, int skill, int originalLevel) {
        Scaling scaling = EnchantingItemPropertyManager.getScaling(enchantment);
        if (scaling == null || enchantment.getMaxLevel() <= 1) {
            return originalLevel;
        }
        return (int)Math.max(1.0, Math.floor(scaling.evaluate(scaling.getExpression().replace("%rating%", String.valueOf(skill)), originalLevel)));
    }

    public static void scaleEnchantmentOffers(int skill, EnchantmentOffer[] enchantments, double chanceForApplication) {
        for (EnchantmentOffer offer : enchantments) {
            if (offer == null || !Utils.proc(chanceForApplication, 0.0, false)) continue;
            offer.setEnchantmentLevel(EnchantingItemPropertyManager.getScaledLevel(offer.getEnchantment(), skill, offer.getEnchantmentLevel()));
        }
    }

    public static int getScaledAnvilLevel(Enchantment enchantment, int skill) {
        return EnchantingItemPropertyManager.getScaledLevel(enchantment, skill, enchantment.getMaxLevel());
    }

    static {
        String config = "skills/enchanting.yml";
        EnchantingItemPropertyManager.registerScaling(EnchantmentMappings.POWER.getEnchantment(), Scaling.fromConfig(config, "scalings.power"));
        EnchantingItemPropertyManager.registerScaling(EnchantmentMappings.PUNCH.getEnchantment(), Scaling.fromConfig(config, "scalings.punch"));
        EnchantingItemPropertyManager.registerScaling(EnchantmentMappings.SHARPNESS.getEnchantment(), Scaling.fromConfig(config, "scalings.sharpness"));
        EnchantingItemPropertyManager.registerScaling(EnchantmentMappings.BANE_OF_ARTHROPODS.getEnchantment(), Scaling.fromConfig(config, "scalings.bane_of_arthropods"));
        EnchantingItemPropertyManager.registerScaling(EnchantmentMappings.SMITE.getEnchantment(), Scaling.fromConfig(config, "scalings.smite"));
        EnchantingItemPropertyManager.registerScaling(EnchantmentMappings.DEPTH_STRIDER.getEnchantment(), Scaling.fromConfig(config, "scalings.depth_strider"));
        EnchantingItemPropertyManager.registerScaling(EnchantmentMappings.EFFICIENCY.getEnchantment(), Scaling.fromConfig(config, "scalings.efficiency"));
        EnchantingItemPropertyManager.registerScaling(EnchantmentMappings.UNBREAKING.getEnchantment(), Scaling.fromConfig(config, "scalings.unbreaking"));
        EnchantingItemPropertyManager.registerScaling(EnchantmentMappings.FIRE_ASPECT.getEnchantment(), Scaling.fromConfig(config, "scalings.fire_aspect"));
        EnchantingItemPropertyManager.registerScaling(EnchantmentMappings.FROST_WALKER.getEnchantment(), Scaling.fromConfig(config, "scalings.frost_walker"));
        EnchantingItemPropertyManager.registerScaling(EnchantmentMappings.IMPALING.getEnchantment(), Scaling.fromConfig(config, "scalings.impaling"));
        EnchantingItemPropertyManager.registerScaling(EnchantmentMappings.KNOCKBACK.getEnchantment(), Scaling.fromConfig(config, "scalings.knockback"));
        EnchantingItemPropertyManager.registerScaling(EnchantmentMappings.FORTUNE.getEnchantment(), Scaling.fromConfig(config, "scalings.fortune"));
        EnchantingItemPropertyManager.registerScaling(EnchantmentMappings.LOOTING.getEnchantment(), Scaling.fromConfig(config, "scalings.looting"));
        EnchantingItemPropertyManager.registerScaling(EnchantmentMappings.LOYALTY.getEnchantment(), Scaling.fromConfig(config, "scalings.loyalty"));
        EnchantingItemPropertyManager.registerScaling(EnchantmentMappings.LUCK_OF_THE_SEA.getEnchantment(), Scaling.fromConfig(config, "scalings.luck"));
        EnchantingItemPropertyManager.registerScaling(EnchantmentMappings.LURE.getEnchantment(), Scaling.fromConfig(config, "scalings.lure"));
        EnchantingItemPropertyManager.registerScaling(EnchantmentMappings.RESPIRATION.getEnchantment(), Scaling.fromConfig(config, "scalings.respiration"));
        EnchantingItemPropertyManager.registerScaling(EnchantmentMappings.PIERCING.getEnchantment(), Scaling.fromConfig(config, "scalings.piercing"));
        EnchantingItemPropertyManager.registerScaling(EnchantmentMappings.PROTECTION.getEnchantment(), Scaling.fromConfig(config, "scalings.protection"));
        EnchantingItemPropertyManager.registerScaling(EnchantmentMappings.PROJECTILE_PROTECTION.getEnchantment(), Scaling.fromConfig(config, "scalings.projectile_protection"));
        EnchantingItemPropertyManager.registerScaling(EnchantmentMappings.BLAST_PROTECTION.getEnchantment(), Scaling.fromConfig(config, "scalings.blast_protection"));
        EnchantingItemPropertyManager.registerScaling(EnchantmentMappings.FIRE_PROTECTION.getEnchantment(), Scaling.fromConfig(config, "scalings.fire_protection"));
        EnchantingItemPropertyManager.registerScaling(EnchantmentMappings.FEATHER_FALLING.getEnchantment(), Scaling.fromConfig(config, "scalings.feather_falling"));
        EnchantingItemPropertyManager.registerScaling(EnchantmentMappings.QUICK_CHARGE.getEnchantment(), Scaling.fromConfig(config, "scalings.quick_charge"));
        EnchantingItemPropertyManager.registerScaling(EnchantmentMappings.RIPTIDE.getEnchantment(), Scaling.fromConfig(config, "scalings.riptide"));
        EnchantingItemPropertyManager.registerScaling(EnchantmentMappings.SOUL_SPEED.getEnchantment(), Scaling.fromConfig(config, "scalings.soul_speed"));
        EnchantingItemPropertyManager.registerScaling(EnchantmentMappings.SWEEPING_EDGE.getEnchantment(), Scaling.fromConfig(config, "scalings.sweeping"));
        EnchantingItemPropertyManager.registerScaling(EnchantmentMappings.THORNS.getEnchantment(), Scaling.fromConfig(config, "scalings.thorns"));
        EnchantingItemPropertyManager.registerScaling(EnchantmentMappings.SWIFT_SNEAK.getEnchantment(), Scaling.fromConfig(config, "scalings.swift_sneak"));
        EnchantingItemPropertyManager.registerScaling(EnchantmentMappings.BREACH.getEnchantment(), Scaling.fromConfig(config, "scalings.breach"));
        EnchantingItemPropertyManager.registerScaling(EnchantmentMappings.WIND_BURST.getEnchantment(), Scaling.fromConfig(config, "scalings.wind_burst"));
        EnchantingItemPropertyManager.registerScaling(EnchantmentMappings.DENSITY.getEnchantment(), Scaling.fromConfig(config, "scalings.density"));
    }
}

