/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.item;

import java.util.Collection;
import java.util.HashSet;
import me.athlaeos.valhallammo.dom.MinecraftVersion;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.enchantments.Enchantment;

public enum EnchantmentClassification {
    OFFENSIVE("thorns", "bane_of_arthropods", "smite", "sharpness", "knockback", "fire_aspect", "impaling", "sweeping_edge", "channeling", "flame", "impaling", "infinity", "loyalty", "multishot", "piercing", "power", "punch", "quick_charge"),
    DEFENSIVE("projectile_protection", "feather_falling", "fire_protection", "projectile_protection", "protection"),
    UTILITY("mending", "unbreaking", "aqua_affinity", "depth_strider", "frost_walker", "respiration", "soul_speed", "swift_sneak", "efficiency", "looting", "fortune", "riptide", "luck_of_the_sea", "lure", "silk_touch"),
    CURSE("curse_of_vanishing", "curse_of_binding"),
    UNDEFINED(new String[0]);

    private final Collection<Enchantment> matches = new HashSet<Enchantment>();

    private EnchantmentClassification(String ... matches) {
        for (String m : matches) {
            Enchantment match;
            Enchantment enchantment = match = MinecraftVersion.currentVersionNewerThan(MinecraftVersion.MINECRAFT_1_20_5) ? (Enchantment)Registry.ENCHANTMENT.get(NamespacedKey.minecraft((String)m)) : Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)m));
            if (match == null) continue;
            this.matches.add(match);
        }
    }

    public Collection<Enchantment> getMatches() {
        return this.matches;
    }

    public static EnchantmentClassification getClassification(Enchantment e) {
        for (EnchantmentClassification classification : EnchantmentClassification.values()) {
            if (!classification.getMatches().contains(e)) continue;
            return classification;
        }
        return UNDEFINED;
    }
}

