/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.item;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.dom.Catch;
import me.athlaeos.valhallammo.dom.MinecraftVersion;
import me.athlaeos.valhallammo.item.CustomFlag;
import me.athlaeos.valhallammo.item.ItemAttributesRegistry;
import me.athlaeos.valhallammo.item.MiningSpeed;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.Utils;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ColorableArmorMeta;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.persistence.PersistentDataType;

public class ItemBuilder {
    private ItemStack item;
    private ItemMeta meta;
    private String name;
    private List<String> lore;
    private boolean translate = false;
    private Collection<MiningSpeed.EmbeddedTool> embeddedTools;

    public ItemBuilder copy() {
        return new ItemBuilder(this.item.clone(), this.meta.clone());
    }

    public ItemBuilder(Material m) {
        this.item = new ItemStack(m);
        this.meta = ItemUtils.getItemMeta(this.item);
        this.embeddedTools = MiningSpeed.getEmbeddedTools(this.meta);
    }

    public ItemBuilder(ItemStack i, ItemMeta m) {
        this.item = i.clone();
        this.meta = m.clone();
        this.embeddedTools = MiningSpeed.getEmbeddedTools(this.meta);
        if (this.meta.hasLore() && this.meta.getLore() != null) {
            this.lore = new ArrayList<String>(this.meta.getLore());
        }
        if (this.meta.hasDisplayName()) {
            this.name = this.meta.getDisplayName();
        }
    }

    public ItemBuilder(ItemStack i) {
        this.item = i.clone();
        this.meta = ItemUtils.getItemMeta(this.item);
        this.embeddedTools = MiningSpeed.getEmbeddedTools(this.meta);
        if (this.meta.hasLore() && this.meta.getLore() != null) {
            this.lore = new ArrayList<String>(this.meta.getLore());
        }
        if (this.meta.hasDisplayName()) {
            this.name = this.meta.getDisplayName();
        }
    }

    public ItemBuilder type(Material type) {
        this.item.setType(type);
        ItemUtils.setMetaNoClone(this.item, this.meta);
        this.meta = ItemUtils.getItemMeta(this.item);
        return this;
    }

    public ItemBuilder translate() {
        this.translate = true;
        return this;
    }

    public Collection<MiningSpeed.EmbeddedTool> getEmbeddedTools() {
        return new HashSet<MiningSpeed.EmbeddedTool>(this.embeddedTools);
    }

    public ItemBuilder data(int data) {
        if (data > 0) {
            this.meta.setCustomModelData(Integer.valueOf(data));
        } else {
            this.meta.setCustomModelData(null);
        }
        return this;
    }

    public ItemBuilder model(String model) {
        int asInteger = Catch.catchOrElse(() -> Integer.parseInt(model), -1);
        if (asInteger < 0 || MinecraftVersion.currentVersionNewerThan(MinecraftVersion.MINECRAFT_1_21_4)) {
            ValhallaMMO.getNms().setItemModel(this.meta, model);
        } else {
            this.meta.setCustomModelData(Integer.valueOf(asInteger));
        }
        return this;
    }

    public ItemBuilder intTag(NamespacedKey key, int tag) {
        this.meta.getPersistentDataContainer().set(key, PersistentDataType.INTEGER, (Object)tag);
        return this;
    }

    public ItemBuilder floatTag(NamespacedKey key, float tag) {
        this.meta.getPersistentDataContainer().set(key, PersistentDataType.FLOAT, (Object)Float.valueOf(tag));
        return this;
    }

    public ItemBuilder doubleTag(NamespacedKey key, double tag) {
        this.meta.getPersistentDataContainer().set(key, PersistentDataType.DOUBLE, (Object)tag);
        return this;
    }

    public ItemBuilder stringTag(NamespacedKey key, String tag) {
        this.meta.getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)tag);
        return this;
    }

    public ItemBuilder name(String name) {
        this.name = name;
        return this;
    }

    public ItemBuilder lore(List<String> lore) {
        if (lore == null) {
            return this;
        }
        this.lore = new ArrayList<String>(lore);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public ItemBuilder lore(String ... lore) {
        if (lore == null) {
            return this;
        }
        return this.lore(new ArrayList<String>(Arrays.asList(lore)));
    }

    public ItemBuilder appendLore(List<String> lore) {
        if (lore == null) {
            return this;
        }
        ArrayList<String> l = this.lore == null ? new ArrayList<String>() : new ArrayList<String>(this.lore);
        l.addAll(lore);
        this.lore = l;
        return this;
    }

    public ItemBuilder prependLore(List<String> lore) {
        if (lore == null) {
            return this;
        }
        lore = new ArrayList<String>(lore);
        if (this.lore != null) {
            lore.addAll(this.lore);
        }
        this.lore = lore;
        return this;
    }

    public ItemBuilder placeholderLore(String placeholder, List<String> replaceWith) {
        return this.lore(ItemUtils.setListPlaceholder(this.lore != null ? this.lore : new ArrayList<String>(), placeholder, replaceWith));
    }

    public ItemBuilder placeholderLore(String placeholder, String replaceWith) {
        return this.lore(ItemUtils.setListPlaceholder(this.lore != null ? this.lore : new ArrayList<String>(), placeholder, replaceWith));
    }

    public ItemBuilder placeholderName(String placeholder, String replaceWith) {
        if (this.name == null) {
            return this;
        }
        return this.name(this.name.replace(placeholder, replaceWith));
    }

    public ItemBuilder appendLore(String ... lore) {
        if (lore == null) {
            return this;
        }
        return this.appendLore(new ArrayList<String>(Arrays.asList(lore)));
    }

    public ItemBuilder prependLore(String ... lore) {
        if (lore == null) {
            return this;
        }
        return this.prependLore(new ArrayList<String>(Arrays.asList(lore)));
    }

    public List<String> getLore() {
        return this.lore;
    }

    public ItemBuilder amount(int amount) {
        this.item.setAmount(Math.min(amount, 64));
        return this;
    }

    public ItemBuilder flag(ItemFlag ... flags) {
        this.meta.addItemFlags(flags);
        return this;
    }

    public ItemBuilder flag(CustomFlag ... flags) {
        CustomFlag.addItemFlag(this.meta, flags);
        return this;
    }

    public ItemBuilder color(Color color) {
        ItemMeta itemMeta;
        ItemMeta itemMeta2 = this.meta;
        if (itemMeta2 instanceof LeatherArmorMeta) {
            LeatherArmorMeta m = (LeatherArmorMeta)itemMeta2;
            m.setColor(color);
        } else {
            itemMeta2 = this.meta;
            if (itemMeta2 instanceof PotionMeta) {
                PotionMeta m = (PotionMeta)itemMeta2;
                m.setColor(color);
            }
        }
        if (MinecraftVersion.currentVersionNewerThan(MinecraftVersion.MINECRAFT_1_21) && (itemMeta = this.meta) instanceof ColorableArmorMeta) {
            ColorableArmorMeta c = (ColorableArmorMeta)itemMeta;
            c.setColor(color);
        }
        return this;
    }

    public ItemBuilder disEnchant() {
        ItemMeta itemMeta = this.meta;
        if (itemMeta instanceof EnchantmentStorageMeta) {
            EnchantmentStorageMeta m = (EnchantmentStorageMeta)itemMeta;
            m.getStoredEnchants().keySet().forEach(arg_0 -> ((EnchantmentStorageMeta)m).removeStoredEnchant(arg_0));
        } else {
            this.item.getEnchantments().keySet().forEach(arg_0 -> ((ItemStack)this.item).removeEnchantment(arg_0));
        }
        return this;
    }

    public ItemBuilder disEnchant(Enchantment e) {
        ItemMeta itemMeta = this.meta;
        if (itemMeta instanceof EnchantmentStorageMeta) {
            EnchantmentStorageMeta m = (EnchantmentStorageMeta)itemMeta;
            m.removeStoredEnchant(e);
        } else {
            this.meta.removeEnchant(e);
        }
        return this;
    }

    public ItemBuilder enchant(Enchantment e, int level) {
        ItemMeta itemMeta = this.meta;
        if (itemMeta instanceof EnchantmentStorageMeta) {
            EnchantmentStorageMeta m = (EnchantmentStorageMeta)itemMeta;
            m.addStoredEnchant(e, level, true);
        } else {
            this.meta.addEnchant(e, level, true);
        }
        return this;
    }

    public ItemStack get() {
        if (ItemUtils.isEmpty(this.item)) {
            return null;
        }
        if (this.translate) {
            TranslationManager.translateItem(this);
        }
        if (this.name != null) {
            this.meta.setDisplayName(Utils.chat(this.name));
        }
        if (this.lore != null) {
            this.meta.setLore(Utils.chat(this.lore));
        }
        ItemUtils.setMetaNoClone(this.item, this.meta);
        ItemUtils.storeType(this.meta, this.item.getType());
        return this.item;
    }

    public ItemBuilder attribute(String attribute, double value, AttributeModifier.Operation operation) {
        ItemAttributesRegistry.addDefaultStat(this, ItemAttributesRegistry.getCopy(attribute).setOperation(operation).setValue(value));
        return this;
    }

    public ItemBuilder attribute(String attribute, double value) {
        ItemAttributesRegistry.addDefaultStat(this, ItemAttributesRegistry.getCopy(attribute).setOperation(AttributeModifier.Operation.ADD_NUMBER).setValue(value));
        return this;
    }

    public ItemBuilder wipeAttributes() {
        this.meta.setAttributeModifiers(null);
        return this;
    }

    public ItemBuilder modifyMeta(Consumer<ItemMeta> function) {
        function.accept(this.meta);
        return this;
    }

    public ItemBuilder modifyItem(Consumer<ItemStack> function) {
        function.accept(this.item);
        return this;
    }

    public ItemBuilder modifyBuilder(Consumer<ItemBuilder> function) {
        function.accept(this);
        return this;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public ItemMeta getMeta() {
        return this.meta;
    }

    public ItemBuilder setItem(ItemStack item) {
        this.item = item;
        return this;
    }

    public ItemBuilder setMeta(ItemMeta meta) {
        this.meta = meta;
        this.embeddedTools = MiningSpeed.getEmbeddedTools(meta);
        this.lore = this.meta.hasLore() && this.meta.getLore() != null ? new ArrayList(this.meta.getLore()) : new ArrayList();
        this.name = this.meta.hasDisplayName() ? this.meta.getDisplayName() : null;
        return this;
    }
}

