/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.item;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.playerstats.profiles.Profile;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileCache;
import me.athlaeos.valhallammo.skills.skills.Skill;
import me.athlaeos.valhallammo.skills.skills.SkillRegistry;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.StringUtils;
import me.athlaeos.valhallammo.utility.Timer;
import me.athlaeos.valhallammo.utility.Utils;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ItemSkillRequirements {
    private static final NamespacedKey SKILL_REQUIREMENT = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "item_skill_requirement");
    private static final NamespacedKey REQUIREMENT_TYPE = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "item_skill_requirement_type");
    private static final String penaltyScaling;
    private static final Map<String, Double> attributePenalties;
    private static final String warningTooAdvanced;
    private static final int warningDisplayType;
    private static final int warningDisplayCooldown;

    public static double getPenalty(Player p, ItemBuilder item, String attribute) {
        if (!item.getMeta().getPersistentDataContainer().has(SKILL_REQUIREMENT, PersistentDataType.STRING) || !attributePenalties.containsKey(attribute)) {
            return 0.0;
        }
        double maxPenalty = attributePenalties.get(attribute);
        Collection<SkillRequirement> requirements = ItemSkillRequirements.getSkillRequirements(item.getMeta());
        boolean shouldFulfillAny = ItemSkillRequirements.requireAnySkillMatch(item.getMeta());
        for (SkillRequirement r : requirements) {
            Profile profile = ProfileCache.getOrCache(p, r.skill.getProfileType());
            if (shouldFulfillAny) {
                if (profile.getLevel() < r.levelRequirement) continue;
                return 0.0;
            }
            if (profile.getLevel() >= r.levelRequirement) continue;
            Material stored = item.getItem().getType();
            double fractionLevel = (double)profile.getLevel() / (double)r.levelRequirement;
            double formulaResult = Utils.eval(penaltyScaling.replace("%fraction_level%", String.format("%.3f", fractionLevel)));
            if (Timer.isCooldownPassed(p.getUniqueId(), "cooldown_warning_overleveled_item_" + stored.toString().toLowerCase(Locale.US))) {
                String message = warningTooAdvanced.replace("%item%", ItemUtils.getItemName(item)).replace("%skill%", r.skill.getDisplayName()).replace("%level%", "" + r.levelRequirement);
                if (warningDisplayType == 1 || warningDisplayType == 2) {
                    switch (warningDisplayType) {
                        case 1: {
                            Utils.sendActionBar(p, message);
                            break;
                        }
                        case 2: {
                            Utils.sendMessage((CommandSender)p, message);
                        }
                    }
                    Timer.setCooldown(p.getUniqueId(), warningDisplayCooldown, "cooldown_warning_overleveled_item_" + stored.toString().toLowerCase(Locale.US));
                }
            }
            return maxPenalty * Math.max(0.0, Math.min(1.0, formulaResult));
        }
        return 0.0;
    }

    public static boolean requireAnySkillMatch(ItemMeta meta) {
        return meta.getPersistentDataContainer().has(REQUIREMENT_TYPE, PersistentDataType.INTEGER);
    }

    public static void setAnySkillMatch(ItemMeta meta, boolean requirement) {
        if (requirement) {
            meta.getPersistentDataContainer().set(REQUIREMENT_TYPE, PersistentDataType.INTEGER, (Object)1);
        } else {
            meta.getPersistentDataContainer().remove(REQUIREMENT_TYPE);
        }
    }

    public static void addSkillRequirement(ItemMeta meta, Skill forSkill, int required) {
        Collection<SkillRequirement> existingRequirements = ItemSkillRequirements.getSkillRequirements(meta);
        existingRequirements.add(new SkillRequirement(forSkill, required));
        ItemSkillRequirements.setSkillRequirements(meta, existingRequirements);
    }

    public static void removeSkillRequirements(ItemMeta meta) {
        ItemSkillRequirements.setSkillRequirements(meta, null);
        ItemSkillRequirements.setAnySkillMatch(meta, false);
    }

    public static void removeSkillRequirement(ItemMeta meta, String skill) {
        Collection<SkillRequirement> existingRequirements = ItemSkillRequirements.getSkillRequirements(meta);
        existingRequirements.removeIf(skillRequirement -> skillRequirement.skill.getType().equals(skill));
        ItemSkillRequirements.setSkillRequirements(meta, existingRequirements);
    }

    public static void setSkillRequirements(ItemMeta meta, Collection<SkillRequirement> requirements) {
        if (requirements == null || requirements.isEmpty()) {
            meta.getPersistentDataContainer().remove(SKILL_REQUIREMENT);
        } else {
            meta.getPersistentDataContainer().set(SKILL_REQUIREMENT, PersistentDataType.STRING, (Object)requirements.stream().map(r -> r.skill.getType() + ":" + r.levelRequirement).collect(Collectors.joining(";")));
        }
    }

    public static Collection<SkillRequirement> getSkillRequirements(ItemMeta meta) {
        String[] stringRequirements;
        HashSet<SkillRequirement> requirements = new HashSet<SkillRequirement>();
        if (meta == null) {
            return requirements;
        }
        String storedValue = ItemUtils.getPDCString(SKILL_REQUIREMENT, meta, "");
        if (StringUtils.isEmpty(storedValue)) {
            return requirements;
        }
        for (String requirement : stringRequirements = storedValue.split(";")) {
            String[] args = requirement.split(":");
            if (args.length < 2) continue;
            try {
                int level = Integer.parseInt(args[1]);
                Skill skill = SkillRegistry.getSkill(args[0]);
                if (skill == null) continue;
                requirements.add(new SkillRequirement(skill, level));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return requirements;
    }

    static {
        attributePenalties = new HashMap<String, Double>();
        YamlConfiguration c = ValhallaMMO.getPluginConfig();
        penaltyScaling = c.getString("item_skill_requirement_formula");
        ConfigurationSection valuesSection = c.getConfigurationSection("item_skill_requirement_penalties");
        if (valuesSection != null) {
            for (String type : valuesSection.getKeys(false)) {
                attributePenalties.put(type, c.getDouble("item_skill_requirement_penalties." + type));
            }
        }
        warningDisplayType = switch (c.getString("item_skill_requirement_warning", "CHAT")) {
            case "CHAT" -> 2;
            case "ACTION_BAR" -> 1;
            default -> 0;
        };
        warningTooAdvanced = TranslationManager.getTranslation("warning_item_too_advanced");
        warningDisplayCooldown = c.getInt("item_skill_requirement_warning_delay", 600000);
    }

    public record SkillRequirement(Skill skill, int levelRequirement) {
    }
}

