/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.listeners;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.animations.Animation;
import me.athlaeos.valhallammo.animations.AnimationRegistry;
import me.athlaeos.valhallammo.dom.Catch;
import me.athlaeos.valhallammo.dom.CombatLog;
import me.athlaeos.valhallammo.dom.CombatType;
import me.athlaeos.valhallammo.dom.CustomDamageType;
import me.athlaeos.valhallammo.dom.Pair;
import me.athlaeos.valhallammo.entities.Dummy;
import me.athlaeos.valhallammo.entities.EntityAttributeStats;
import me.athlaeos.valhallammo.entities.EntityClassification;
import me.athlaeos.valhallammo.entities.damageindicators.DamageIndicatorRegistry;
import me.athlaeos.valhallammo.event.EntityCriticallyHitEvent;
import me.athlaeos.valhallammo.event.EntityDodgeAttackEvent;
import me.athlaeos.valhallammo.hooks.WorldGuardHook;
import me.athlaeos.valhallammo.item.EquipmentClass;
import me.athlaeos.valhallammo.item.ItemAttributesRegistry;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.item.SweepStatus;
import me.athlaeos.valhallammo.item.item_attributes.AttributeWrapper;
import me.athlaeos.valhallammo.listeners.EntityDamagedListener;
import me.athlaeos.valhallammo.listeners.MovementListener;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.playerstats.AccumulativeStatManager;
import me.athlaeos.valhallammo.playerstats.EntityCache;
import me.athlaeos.valhallammo.playerstats.EntityProperties;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileCache;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.PowerProfile;
import me.athlaeos.valhallammo.potioneffects.CustomPotionEffect;
import me.athlaeos.valhallammo.potioneffects.PotionEffectRegistry;
import me.athlaeos.valhallammo.potioneffects.PotionEffectWrapper;
import me.athlaeos.valhallammo.potioneffects.implementations.Stun;
import me.athlaeos.valhallammo.utility.Bleeder;
import me.athlaeos.valhallammo.utility.EntityUtils;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.MathUtils;
import me.athlaeos.valhallammo.utility.Parryer;
import me.athlaeos.valhallammo.utility.Timer;
import me.athlaeos.valhallammo.utility.Utils;
import org.bukkit.EntityEffect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Trident;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.util.Vector;

public class EntityAttackListener
implements Listener {
    private static final double facingAngleCos = MathUtils.cos(ValhallaMMO.getPluginConfig().getDouble("facing_angle", 70.0));
    private final boolean requireFacingForDodge = ValhallaMMO.getPluginConfig().getBoolean("prevent_dodge_not_facing_attacker", true);
    private final Particle dodgeParticle = Catch.catchOrElse(() -> Particle.valueOf((String)ValhallaMMO.getPluginConfig().getString("dodge_effect")), Particle.SWEEP_ATTACK, "Invalid dodge particle effect given, used default");
    private final String dodgeMessage = TranslationManager.getTranslation(ValhallaMMO.getPluginConfig().getString("dodge_message", ""));
    private final EntityDamageEvent.DamageCause reflectDamageType = Catch.catchOrElse(() -> EntityDamageEvent.DamageCause.valueOf((String)ValhallaMMO.getPluginConfig().getString("reflect_damage_type")), EntityDamageEvent.DamageCause.THORNS, "Invalid reflect damage type given, used default");
    private final Sound critSound = Utils.getSound(ValhallaMMO.getPluginConfig().getString("crit_sound_effect"), Sound.ENCHANT_THORNS_HIT, "Invalid crit sound effect given, used default");
    private Animation critAnimation = ValhallaMMO.getPluginConfig().getBoolean("crit_particle_effect", true) ? AnimationRegistry.getAnimation(AnimationRegistry.ENTITY_FLASH.id()) : null;
    private final boolean skillGapPvPPrevention = ValhallaMMO.getPluginConfig().getBoolean("skill_gap_pvp_prevention");
    private final int skillGapPvPLevel = ValhallaMMO.getPluginConfig().getInt("skill_gap_pvp_level");
    private final double tridentThrownDamage = ValhallaMMO.getPluginConfig().getDouble("trident_damage_ranged");
    private final double tridentThrownLoyalDamage = ValhallaMMO.getPluginConfig().getDouble("trident_damage_ranged_loyalty");
    private final double rangedDamage = ValhallaMMO.getPluginConfig().getDouble("trident_impaling_damage_ranged");
    private final double meleeDamage = ValhallaMMO.getPluginConfig().getDouble("trident_impaling_damage_melee");
    private final boolean tridentImpalingDamageOnlyInWater = ValhallaMMO.getPluginConfig().getBoolean("trident_impaling_damage_water");
    private final double velocityDamageConstant = ValhallaMMO.getPluginConfig().getDouble("velocity_damage_constant");
    private static final boolean multiplyDamageNumbers = ValhallaMMO.getPluginConfig().getBoolean("damage_multipliers_multiplicative");
    private static final Collection<UUID> critNextAttack = new HashSet<UUID>();
    private static final Collection<UUID> bleedNextAttack = new HashSet<UUID>();
    public static Map<UUID, CombatLog> playersInCombat = new HashMap<UUID, CombatLog>();

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onSkillGapDamage(EntityDamageByEntityEvent e) {
        Entity entity;
        if (ValhallaMMO.isWorldBlacklisted(e.getEntity().getWorld().getName()) || !((entity = e.getEntity()) instanceof LivingEntity)) {
            return;
        }
        LivingEntity v = (LivingEntity)entity;
        Entity trueDamager = EntityUtils.getTrueDamager(e);
        if (v instanceof Player) {
            Player pV = (Player)v;
            if (trueDamager instanceof Player) {
                Player pA = (Player)trueDamager;
                if (this.skillGapPvPPrevention && !pA.hasPermission("valhalla.ignorenoobprotection")) {
                    PowerProfile victimProfile = ProfileCache.getOrCache(pV, PowerProfile.class);
                    PowerProfile attackerProfile = ProfileCache.getOrCache(pA, PowerProfile.class);
                    if (Math.abs(attackerProfile.getLevel() - victimProfile.getLevel()) > this.skillGapPvPLevel) {
                        Utils.sendMessage((CommandSender)pA, TranslationManager.getTranslation("skill_gap_prevention_message"));
                        e.setCancelled(true);
                    }
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onAttack(EntityDamageByEntityEvent e) {
        Player p;
        Entity trueDamager;
        LivingEntity v;
        block51: {
            float attackCooldown;
            CombatType combatType;
            double victimLuck;
            double damagerLuck;
            double damageMultiplier;
            block52: {
                block53: {
                    Entity entity;
                    double dismountChance;
                    double stunChance;
                    LivingEntity a;
                    int impalingLevel;
                    ItemStack hand;
                    LivingEntity l;
                    Entity tridentMeta;
                    LivingEntity le;
                    boolean facing;
                    Entity a2;
                    Entity entity2;
                    int shieldDisabling;
                    AttributeInstance attributeInstance;
                    ItemMeta mainHand;
                    LivingEntity a3;
                    boolean sweep;
                    if (ValhallaMMO.isWorldBlacklisted(e.getEntity().getWorld().getName())) return;
                    Entity entity3 = e.getEntity();
                    if (!(entity3 instanceof LivingEntity)) return;
                    v = (LivingEntity)entity3;
                    if (e.getDamager() instanceof EnderPearl) {
                        return;
                    }
                    if (e.getDamager() instanceof EnderDragon && v.getNoDamageTicks() > 0) {
                        e.setCancelled(true);
                        return;
                    }
                    trueDamager = EntityUtils.getTrueDamager(e);
                    damageMultiplier = 1.0;
                    String cause = EntityDamagedListener.getLastDamageCause(v);
                    boolean bl = sweep = e.getCause() == EntityDamageEvent.DamageCause.ENTITY_SWEEP_ATTACK || cause != null && cause.equals("ENTITY_SWEEP_ATTACK");
                    if (sweep && trueDamager instanceof LivingEntity && (a3 = (LivingEntity)trueDamager).getEquipment() != null && !ItemUtils.isEmpty(a3.getEquipment().getItemInMainHand()) && SweepStatus.preventSweeping(mainHand = ItemUtils.getItemMeta(a3.getEquipment().getItemInMainHand()))) {
                        e.setCancelled(true);
                        return;
                    }
                    if (trueDamager instanceof LivingEntity) {
                        LivingEntity a4 = (LivingEntity)trueDamager;
                        attributeInstance = a4.getAttribute(Attribute.GENERIC_LUCK);
                    } else {
                        attributeInstance = null;
                    }
                    AttributeInstance dL = attributeInstance;
                    damagerLuck = dL != null ? dL.getValue() : 0.0;
                    AttributeInstance vL = v.getAttribute(Attribute.GENERIC_LUCK);
                    double d = victimLuck = vL != null ? vL.getValue() : 0.0;
                    if (v instanceof Player && (shieldDisabling = (int)Math.round(AccumulativeStatManager.getCachedAttackerRelationalStats("SHIELD_DISARMING", (Entity)(p = (Player)v), trueDamager, 10000L, true))) != 0 && p.getCooldown(Material.SHIELD) <= 0 && p.isBlocking() && e.getFinalDamage() == 0.0 && (!((entity2 = e.getDamager()) instanceof Player) || (double)(a2 = (Player)entity2).getAttackCooldown() >= 0.9)) {
                        ValhallaMMO.getInstance().getServer().getScheduler().runTaskLater((Plugin)ValhallaMMO.getInstance(), () -> {
                            p.setCooldown(Material.SHIELD, p.getCooldown(Material.SHIELD) + shieldDisabling);
                            p.playEffect(EntityEffect.SHIELD_BREAK);
                            ItemStack temp = ItemUtils.isEmpty(p.getInventory().getItemInMainHand()) ? null : p.getInventory().getItemInMainHand().clone();
                            p.getInventory().setItemInMainHand(p.getInventory().getItemInOffHand());
                            p.getInventory().setItemInOffHand(temp);
                            ValhallaMMO.getInstance().getServer().getScheduler().runTaskLater((Plugin)ValhallaMMO.getInstance(), () -> {
                                ItemStack temp2 = ItemUtils.isEmpty(p.getInventory().getItemInMainHand()) ? null : p.getInventory().getItemInMainHand().clone();
                                p.getInventory().setItemInMainHand(p.getInventory().getItemInOffHand());
                                p.getInventory().setItemInOffHand(temp2);
                            }, 1L);
                        }, 1L);
                    }
                    if (sweep) break block51;
                    boolean bl2 = facing = EntityUtils.isEntityFacing(v, e.getDamager().getLocation(), facingAngleCos) || (a2 = e.getDamager()) instanceof LivingEntity && EntityUtils.isEntityFacing(v, (le = (LivingEntity)a2).getEyeLocation(), facingAngleCos);
                    if (facing) {
                        double facingDamageMultiplier = 1.0 + AccumulativeStatManager.getCachedRelationalStats("FRONT_PROTECTION", (Entity)v, e.getDamager(), 10000L, true);
                        e.setDamage(e.getDamage() * facingDamageMultiplier);
                    } else {
                        double facingAwayDamageMultiplier = 1.0 + AccumulativeStatManager.getCachedRelationalStats("BACK_PROTECTION", (Entity)v, e.getDamager(), 10000L, true);
                        e.setDamage(e.getDamage() * facingAwayDamageMultiplier);
                    }
                    if ((facing || !this.requireFacingForDodge) && Utils.proc(AccumulativeStatManager.getCachedRelationalStats("DODGE_CHANCE", (Entity)v, e.getDamager(), 10000L, true), 0.0, false)) {
                        EntityDodgeAttackEvent event = new EntityDodgeAttackEvent(e.getEntity(), e);
                        ValhallaMMO.getInstance().getServer().getPluginManager().callEvent((Event)event);
                        if (!event.isCancelled()) {
                            if (this.dodgeParticle != null) {
                                event.getEntity().getWorld().spawnParticle(this.dodgeParticle, event.getEntity().getLocation().add(0.0, 1.0, 0.0), 10, 0.2, 0.5, 0.2);
                            }
                            if ((entity2 = event.getEntity()) instanceof Player) {
                                Player p2 = (Player)entity2;
                                Utils.sendActionBar(p2, this.dodgeMessage);
                            }
                            e.setCancelled(true);
                            return;
                        }
                    }
                    boolean isInWater = e.getEntity().getLocation().getBlock().getLightFromSky() > 14 && !e.getEntity().getWorld().isClearWeather() && e.getEntity().getLocation().getBlock().getType() == Material.WATER;
                    entity2 = e.getDamager();
                    if (entity2 instanceof Trident) {
                        int impalingLevel2;
                        Trident t = (Trident)entity2;
                        tridentMeta = ItemUtils.getItemMeta(t.getItem());
                        AttributeWrapper damageWrapper = ItemAttributesRegistry.getAttribute((ItemMeta)tridentMeta, "GENERIC_ATTACK_DAMAGE", false);
                        if (damageWrapper != null) {
                            if (t.getItem().containsEnchantment(Enchantment.LOYALTY)) {
                                e.setDamage(damageWrapper.getValue() * this.tridentThrownLoyalDamage);
                            } else {
                                e.setDamage(damageWrapper.getValue() * this.tridentThrownDamage);
                            }
                        }
                        if ((impalingLevel2 = t.getItem().getEnchantmentLevel(Enchantment.IMPALING)) > 0 && (!this.tridentImpalingDamageOnlyInWater || isInWater)) {
                            e.setDamage(e.getDamage() + (double)impalingLevel2 * this.rangedDamage);
                        }
                    }
                    if ((tridentMeta = e.getDamager()) instanceof LivingEntity && (l = (LivingEntity)tridentMeta).getEquipment() != null && !ItemUtils.isEmpty(hand = l.getEquipment().getItemInMainHand()) && (impalingLevel = hand.getEnchantmentLevel(Enchantment.IMPALING)) > 0 && (!this.tridentImpalingDamageOnlyInWater || isInWater)) {
                        e.setDamage(e.getDamage() + (double)impalingLevel * this.meleeDamage);
                    }
                    CombatType combatType2 = e.getDamager() instanceof Projectile ? CombatType.RANGED : (combatType = trueDamager instanceof LivingEntity && (a = (LivingEntity)trueDamager).getEquipment() != null && (!ItemUtils.isEmpty(a.getEquipment().getItemInMainHand()) || EntityUtils.isUnarmed(a)) ? CombatType.MELEE_UNARMED : CombatType.MELEE_ARMED);
                    if (trueDamager instanceof LivingEntity) {
                        a = (LivingEntity)trueDamager;
                        if (facing) {
                            damageMultiplier = EntityAttackListener.getDamageMultiplier(damageMultiplier, Parryer.handleParry(e));
                        }
                        Timer.setCooldown(a.getUniqueId(), 0, "parry_effective");
                        if (trueDamager.getVehicle() instanceof LivingEntity) {
                            damageMultiplier = EntityAttackListener.getDamageMultiplier(damageMultiplier, 1.0 + AccumulativeStatManager.getCachedAttackerRelationalStats("MOUNTED_DAMAGE_DEALT", e.getEntity(), e.getDamager(), 10000L, true));
                        }
                    }
                    if (Utils.proc(stunChance = AccumulativeStatManager.getCachedAttackerRelationalStats("STUN_CHANCE", (Entity)v, e.getDamager(), 10000L, true), damagerLuck - victimLuck, false)) {
                        LivingEntity l2;
                        Stun.attemptStun(v, trueDamager instanceof LivingEntity ? (l2 = (LivingEntity)trueDamager) : null);
                    }
                    double knockbackBonus = AccumulativeStatManager.getCachedAttackerRelationalStats("KNOCKBACK_BONUS", (Entity)v, e.getDamager(), 10000L, true);
                    AttributeInstance knockbackInstance = v.getAttribute(Attribute.GENERIC_KNOCKBACK_RESISTANCE);
                    double knockbackResistance = (knockbackInstance == null ? 0.0 : knockbackInstance.getValue()) - Math.min(0.0, knockbackBonus);
                    if (knockbackBonus > 0.0) {
                        knockbackBonus *= 1.0 - knockbackResistance;
                    }
                    if (knockbackResistance > 0.0) {
                        EntityUtils.addUniqueAttribute(v, EntityAttributeStats.NEGATIVE_KNOCKBACK, "valhalla_negative_knockback_taken", Attribute.GENERIC_KNOCKBACK_RESISTANCE, knockbackResistance, AttributeModifier.Operation.ADD_NUMBER);
                    }
                    if (knockbackBonus != 0.0) {
                        double finalKnockbackBonus = knockbackBonus;
                        ValhallaMMO.getInstance().getServer().getScheduler().runTaskLater((Plugin)ValhallaMMO.getInstance(), () -> {
                            if (knockbackResistance > 0.0) {
                                EntityUtils.removeUniqueAttribute(v, "valhalla_negative_knockback_taken", Attribute.GENERIC_KNOCKBACK_RESISTANCE);
                            } else if (finalKnockbackBonus > 0.0) {
                                Vector vector;
                                Entity patt0$temp = e.getDamager();
                                if (patt0$temp instanceof LivingEntity) {
                                    LivingEntity a = (LivingEntity)patt0$temp;
                                    vector = a.getEyeLocation().getDirection().normalize();
                                } else {
                                    vector = e.getDamager().getVelocity().normalize();
                                }
                                Vector lookingDirection = vector;
                                lookingDirection.setX(lookingDirection.getX() * finalKnockbackBonus);
                                lookingDirection.setY(0);
                                lookingDirection.setZ(lookingDirection.getZ() * finalKnockbackBonus);
                                Vector vel = v.getVelocity().add(lookingDirection);
                                try {
                                    vel.checkFinite();
                                    v.setVelocity(vel);
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    // empty catch block
                                }
                            }
                        }, 1L);
                    } else if (knockbackResistance > 0.0) {
                        ValhallaMMO.getInstance().getServer().getScheduler().runTaskLater((Plugin)ValhallaMMO.getInstance(), () -> EntityUtils.removeUniqueAttribute(v, "valhalla_negative_knockback_taken", Attribute.GENERIC_KNOCKBACK_RESISTANCE), 1L);
                    }
                    if (v.getVehicle() != null && Utils.proc(dismountChance = AccumulativeStatManager.getCachedAttackerRelationalStats("DISMOUNT_CHANCE", (Entity)v, e.getDamager(), 10000L, true), damagerLuck - victimLuck, false)) {
                        v.getVehicle().eject();
                    }
                    if ((entity = e.getDamager()) instanceof Player) {
                        Player p3 = (Player)entity;
                        v5 = p3.getAttackCooldown();
                    } else {
                        v5 = attackCooldown = 1.0f;
                    }
                    if (!(e.getDamage() > 0.0) && !Dummy.isDummy(v)) break block51;
                    damageMultiplier = EntityAttackListener.getDamageMultiplier(damageMultiplier, 1.0 + AccumulativeStatManager.getCachedAttackerRelationalStats("DAMAGE_DEALT", (Entity)v, e.getDamager(), 10000L, true));
                    if (e.getDamager() instanceof Projectile) {
                        damageMultiplier = EntityAttackListener.getDamageMultiplier(damageMultiplier, 1.0 + AccumulativeStatManager.getCachedAttackerRelationalStats("RANGED_DAMAGE_DEALT", (Entity)v, e.getDamager(), 10000L, true));
                    } else {
                        Entity entity4;
                        double velocityBonus;
                        damageMultiplier = EntityAttackListener.getDamageMultiplier(damageMultiplier, 1.0 + AccumulativeStatManager.getCachedAttackerRelationalStats(combatType == CombatType.MELEE_UNARMED ? "UNARMED_DAMAGE_DEALT" : "MELEE_DAMAGE_DEALT", (Entity)v, e.getDamager(), 10000L, true));
                        if ((cause == null || EntityDamagedListener.getPhysicalDamageTypes().containsKey(cause)) && (velocityBonus = AccumulativeStatManager.getRelationalStats("VELOCITY_DAMAGE_BONUS", (Entity)v, e.getDamager(), true)) > 0.0 && (entity4 = e.getDamager()) instanceof LivingEntity) {
                            LivingEntity l3 = (LivingEntity)entity4;
                            Vector moveSpeedDirection = MovementListener.getLastMovementVectors().get(e.getDamager().getUniqueId());
                            if (moveSpeedDirection != null) {
                                double speed = moveSpeedDirection.length();
                                double multiplier = Math.max(0.0, l3.getEyeLocation().getDirection().dot(moveSpeedDirection));
                                if (!Double.isNaN(speed) && !Double.isNaN(multiplier)) {
                                    damageMultiplier = EntityAttackListener.getDamageMultiplier(damageMultiplier, 1.0 + speed / this.velocityDamageConstant * multiplier);
                                }
                            }
                        }
                    }
                    EntityProperties victimProperties = EntityCache.getAndCacheProperties(v);
                    damageMultiplier = EntityAttackListener.getDamageMultiplier(damageMultiplier, 1.0 + (double)victimProperties.getLightArmorCount() * AccumulativeStatManager.getCachedAttackerRelationalStats("LIGHT_ARMOR_DAMAGE_BONUS", (Entity)v, e.getDamager(), 10000L, true));
                    damageMultiplier = EntityAttackListener.getDamageMultiplier(damageMultiplier, 1.0 + (double)victimProperties.getHeavyArmorCount() * AccumulativeStatManager.getCachedAttackerRelationalStats("HEAVY_ARMOR_DAMAGE_BONUS", (Entity)v, e.getDamager(), 10000L, true));
                    if (!((double)attackCooldown >= 0.9)) break block52;
                    if (!(trueDamager instanceof Player)) break block53;
                    Player p4 = (Player)trueDamager;
                    if (WorldGuardHook.inDisabledRegion(v.getLocation(), p4, "vmmo-combat-crit")) break block52;
                }
                double critChanceResistance = AccumulativeStatManager.getCachedRelationalStats("CRIT_CHANCE_RESISTANCE", (Entity)v, e.getDamager(), 10000L, true);
                double critChance = AccumulativeStatManager.getCachedAttackerRelationalStats("CRIT_CHANCE", (Entity)v, e.getDamager(), 10000L, true) * (1.0 - critChanceResistance);
                if (critNextAttack.contains(trueDamager.getUniqueId()) || Utils.proc(critChance, damagerLuck - victimLuck, false)) {
                    critNextAttack.remove(trueDamager.getUniqueId());
                    double critDamageResistance = AccumulativeStatManager.getCachedRelationalStats("CRIT_DAMAGE_RESISTANCE", (Entity)v, e.getDamager(), 10000L, true);
                    double critDamage = 1.0 + AccumulativeStatManager.getCachedAttackerRelationalStats("CRIT_DAMAGE", (Entity)v, e.getDamager(), 10000L, true) * (1.0 - critDamageResistance);
                    EntityCriticallyHitEvent event = new EntityCriticallyHitEvent(v, e.getDamager(), combatType, e.getDamage(), critDamage);
                    ValhallaMMO.getInstance().getServer().getPluginManager().callEvent((Event)event);
                    if (!event.isCancelled()) {
                        e.setDamage(event.getDamageBeforeCrit());
                        damageMultiplier = EntityAttackListener.getDamageMultiplier(damageMultiplier, event.getCritMultiplier());
                        DamageIndicatorRegistry.markCriticallyHit(v);
                        if (this.critAnimation != null) {
                            Vector vector;
                            Location location = v.getEyeLocation().add(0.0, -v.getHeight() / 2.0, 0.0);
                            Entity entity = e.getDamager();
                            if (entity instanceof LivingEntity) {
                                LivingEntity l = (LivingEntity)entity;
                                vector = l.getEyeLocation().getDirection();
                            } else {
                                vector = e.getDamager().getVelocity();
                            }
                            this.critAnimation.animate(v, location, vector, 0);
                        }
                        if (this.critSound != null) {
                            v.getWorld().playSound(v.getEyeLocation(), this.critSound, 1.0f, 1.0f);
                        }
                    }
                }
            }
            e.setDamage(Math.max(0.0, e.getDamage() * damageMultiplier));
            if (this.reflectDamageType != null && !EntityUtils.hasActiveDamageProcess((Entity)v) && e.getCause() != this.reflectDamageType && trueDamager instanceof LivingEntity) {
                Player p5;
                LivingEntity a = (LivingEntity)trueDamager;
                if (!(v instanceof Player && WorldGuardHook.inDisabledRegion((p5 = (Player)v).getLocation(), p5, "vmmo-combat-reflect") || !Utils.proc(AccumulativeStatManager.getCachedRelationalStats("REFLECT_CHANCE", (Entity)v, e.getDamager(), 10000L, true), victimLuck - damagerLuck, false))) {
                    double reflectFraction = AccumulativeStatManager.getCachedRelationalStats("REFLECT_FRACTION", (Entity)v, e.getDamager(), 10000L, true);
                    double reflectDamage = e.getDamage() * reflectFraction;
                    a.playEffect(EntityEffect.THORNS_HURT);
                    EntityUtils.damage(a, (Entity)v, reflectDamage, this.reflectDamageType.toString(), true);
                }
            }
            if (!EntityUtils.hasActiveDamageProcess((Entity)v)) {
                EntityDamageEvent.DamageCause originalCause = e.getCause();
                double cooldownDamageMultiplier = EntityUtils.cooldownDamageMultiplier(attackCooldown);
                ArrayList<Pair<CustomDamageType, Double>> damageInstances = new ArrayList<Pair<CustomDamageType, Double>>();
                for (CustomDamageType damageType : CustomDamageType.getRegisteredTypes().values()) {
                    double d = damageType.damageAdder() == null ? 0.0 : AccumulativeStatManager.getCachedAttackerRelationalStats(damageType.damageAdder(), (Entity)v, e.getDamager(), 10000L, true);
                    double baseDamage = d;
                    double elementalDamage = baseDamage * cooldownDamageMultiplier;
                    if (!(elementalDamage > 0.0)) continue;
                    damageInstances.add(new Pair<CustomDamageType, Double>(damageType, elementalDamage));
                }
                if (!damageInstances.isEmpty()) {
                    EntityDamagedListener.markNextDamageInstanceNoImmunity((Entity)v, e.getCause().toString());
                }
                ValhallaMMO.getInstance().getServer().getScheduler().runTaskLater((Plugin)ValhallaMMO.getInstance(), () -> {
                    LivingEntity a;
                    if (attackCooldown >= 0.9f) {
                        double bleedChance = AccumulativeStatManager.getCachedAttackerRelationalStats("BLEED_CHANCE", (Entity)v, e.getDamager(), 10000L, true);
                        if (bleedNextAttack.contains(trueDamager.getUniqueId()) || Utils.proc(bleedChance, damagerLuck - victimLuck, false)) {
                            bleedNextAttack.remove(trueDamager.getUniqueId());
                            Bleeder.inflictBleed(v, e.getDamager(), combatType);
                        }
                    }
                    double lifeSteal = AccumulativeStatManager.getCachedAttackerRelationalStats("LIFE_STEAL", (Entity)v, trueDamager, 10000L, true);
                    double lifeStealValue = e.getDamage() * lifeSteal;
                    double powerAttackMultiplier = 1.0;
                    Entity patt0$temp = e.getDamager();
                    if (patt0$temp instanceof LivingEntity && (a = (LivingEntity)patt0$temp).getFallDistance() > 0.0f && a instanceof Player) {
                        Player p = (Player)a;
                        if (!WorldGuardHook.inDisabledRegion(a.getLocation(), p, "vmmo-combat-powerattack")) {
                            powerAttackMultiplier = 1.5 + AccumulativeStatManager.getCachedAttackerRelationalStats("POWER_ATTACK_DAMAGE_MULTIPLIER", (Entity)v, (Entity)a, 10000L, true);
                            double baseDamage = e.getDamage() / 1.5;
                            e.setDamage(baseDamage * powerAttackMultiplier);
                            double radius = AccumulativeStatManager.getCachedAttackerRelationalStats("POWER_ATTACK_RADIUS", (Entity)v, (Entity)a, 10000L, true);
                            double fraction = AccumulativeStatManager.getCachedAttackerRelationalStats("POWER_ATTACK_DAMAGE_FRACTION", (Entity)v, (Entity)a, 10000L, true);
                            double damage = e.getDamage() * fraction;
                            if (damage > 0.0 && radius > 0.0) {
                                for (Entity entity : e.getEntity().getWorld().getNearbyEntities(e.getEntity().getLocation(), radius, radius, radius, en -> en instanceof LivingEntity)) {
                                    if (EntityClassification.matchesClassification(entity.getType(), EntityClassification.UNALIVE) || entity.equals((Object)a)) continue;
                                    EntityUtils.damage((LivingEntity)entity, (Entity)a, damage, "ENTITY_SWEEP_ATTACK", false);
                                }
                            }
                        }
                    }
                    for (int i = 0; i < damageInstances.size(); ++i) {
                        Pair pair = (Pair)damageInstances.get(i);
                        if (i < damageInstances.size() - 1) {
                            EntityDamagedListener.markNextDamageInstanceNoImmunity((Entity)v, ((CustomDamageType)pair.getOne()).getType());
                        }
                        double damage = (Double)pair.getTwo();
                        if (((CustomDamageType)pair.getOne()).benefitsFromPowerAttacks()) {
                            damage *= powerAttackMultiplier;
                        }
                        EntityDamagedListener.prepareDamageInstance((Entity)v, ((CustomDamageType)pair.getOne()).getType(), damage);
                        EntityUtils.damage(v, e.getDamager(), damage, ((CustomDamageType)pair.getOne()).getType(), false);
                        if (!((CustomDamageType)pair.getOne()).canLifeSteal()) continue;
                        lifeStealValue += (Double)pair.getTwo() * lifeSteal;
                    }
                    EntityDamagedListener.setCustomDamageCause(v.getUniqueId(), originalCause.toString());
                    if (lifeStealValue > 0.0 && trueDamager instanceof LivingEntity) {
                        LivingEntity td = (LivingEntity)trueDamager;
                        if (!EntityClassification.matchesClassification(v.getType(), EntityClassification.UNALIVE)) {
                            AttributeInstance maxHealth;
                            EntityRegainHealthEvent healEvent = new EntityRegainHealthEvent((Entity)td, lifeStealValue, EntityRegainHealthEvent.RegainReason.CUSTOM);
                            ValhallaMMO.getInstance().getServer().getPluginManager().callEvent((Event)healEvent);
                            if (!healEvent.isCancelled() && (maxHealth = td.getAttribute(Attribute.GENERIC_MAX_HEALTH)) != null) {
                                td.setHealth(Math.min(maxHealth.getValue(), td.getHealth() + lifeStealValue));
                            }
                        }
                    }
                }, 2L);
            }
        }
        if (trueDamager instanceof Player) {
            p = (Player)trueDamager;
            if (v instanceof Monster) {
                EntityAttackListener.combatAction(p);
                return;
            }
        }
        if (!(v instanceof Player)) return;
        Player p6 = (Player)v;
        EntityAttackListener.combatAction(p6);
    }

    public static double getDamageMultiplier(double original, double multiplier) {
        if (multiplier == 1.0) {
            return original;
        }
        return multiplyDamageNumbers ? original * multiplier : original + (multiplier - 1.0);
    }

    public static void critNextAttack(LivingEntity entity) {
        critNextAttack.add(entity.getUniqueId());
    }

    public static void bleedNextAttack(LivingEntity entity) {
        bleedNextAttack.add(entity.getUniqueId());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPotionAttack(EntityDamageByEntityEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getEntity().getWorld().getName())) {
            return;
        }
        Entity entity = e.getDamager();
        if (entity instanceof LivingEntity) {
            LivingEntity a = (LivingEntity)entity;
            entity = e.getEntity();
            if (entity instanceof LivingEntity) {
                LivingEntity v = (LivingEntity)entity;
                if (a.getEquipment() != null) {
                    ItemStack hand;
                    if (a instanceof Player) {
                        Player p = (Player)a;
                        if (WorldGuardHook.inDisabledRegion(a.getLocation(), p, "vmmo-combat-weaponcoating")) {
                            return;
                        }
                    }
                    if (ItemUtils.isEmpty(hand = a.getEquipment().getItemInMainHand())) {
                        return;
                    }
                    ItemBuilder weapon = new ItemBuilder(hand);
                    if (hand.getType().isEdible() || weapon.getMeta() instanceof PotionMeta || !EquipmentClass.isHandHeld(weapon.getMeta())) {
                        return;
                    }
                    ValhallaMMO.getInstance().getServer().getScheduler().runTaskLater((Plugin)ValhallaMMO.getInstance(), () -> {
                        if (!e.getEntity().isValid() || e.getEntity().isDead()) {
                            return;
                        }
                        boolean updatedMeta = false;
                        for (PotionEffectWrapper wrapper : PotionEffectRegistry.getStoredEffects(weapon.getMeta(), false).values()) {
                            if (!PotionEffectRegistry.spendCharge(weapon, wrapper.getEffect())) continue;
                            if (wrapper.isVanilla()) {
                                v.addPotionEffect(new PotionEffect(wrapper.getVanillaEffect(), (int)wrapper.getDuration(), (int)wrapper.getAmplifier(), false));
                            } else {
                                PotionEffectRegistry.addEffect(v, a, new CustomPotionEffect(wrapper, (int)wrapper.getDuration(), wrapper.getAmplifier()), false, 1.0, EntityPotionEffectEvent.Cause.ARROW);
                            }
                            updatedMeta = true;
                        }
                        if (updatedMeta) {
                            hand.setItemMeta(weapon.getMeta());
                            a.getEquipment().setItemInMainHand(weapon.get(), true);
                        }
                    }, 1L);
                }
            }
        }
    }

    public static void combatAction(Player who) {
        playersInCombat.putIfAbsent(who.getUniqueId(), new CombatLog(who));
        playersInCombat.get(who.getUniqueId()).combatAction();
    }

    public static void updateCombatStatus(Player who) {
        CombatLog log = playersInCombat.get(who.getUniqueId());
        if (log != null) {
            log.checkPlayerLeftCombat();
        }
    }

    public static long timePlayerInCombat(Player who) {
        CombatLog log = playersInCombat.get(who.getUniqueId());
        if (log == null) {
            return 0L;
        }
        return log.getTimeInCombat();
    }

    public static boolean isInCombat(Player who) {
        CombatLog log = playersInCombat.get(who.getUniqueId());
        if (log == null) {
            return false;
        }
        log.checkPlayerLeftCombat();
        return log.isInCombat();
    }

    public void setCritAnimation(Animation critAnimation) {
        this.critAnimation = critAnimation;
    }

    public static double getFacingAngleCos() {
        return facingAngleCos;
    }
}

