/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.playerstats.profiles.implementations;

import java.util.Collection;
import java.util.UUID;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.playerstats.format.StatFormat;
import me.athlaeos.valhallammo.playerstats.profiles.Profile;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileRegistry;
import me.athlaeos.valhallammo.playerstats.profiles.properties.BooleanProperties;
import me.athlaeos.valhallammo.playerstats.profiles.properties.PropertyBuilder;
import me.athlaeos.valhallammo.potioneffects.EffectClass;
import me.athlaeos.valhallammo.skills.skills.Skill;
import me.athlaeos.valhallammo.skills.skills.implementations.AlchemySkill;
import org.bukkit.NamespacedKey;
import org.bukkit.plugin.Plugin;

public class AlchemyProfile
extends Profile {
    private static final NamespacedKey key = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "profile_alchemy");

    public int getTransmutationRadius() {
        return this.getInt("transmutationRadius");
    }

    public void setTransmutationRadius(int value) {
        this.setInt("transmutationRadius", value);
    }

    public Collection<String> getUnlockedTransmutations() {
        return this.getStringSet("unlockedTransmutations");
    }

    public void setUnlockedTransmutations(Collection<String> value) {
        this.setStringSet("unlockedTransmutations", value);
    }

    public boolean isPotionCombiningUnlocked() {
        return this.getBoolean("potionCombiningUnlocked");
    }

    public void setPotionCombiningUnlocked(boolean value) {
        this.setBoolean("potionCombiningUnlocked", value);
    }

    public float getPotionCombiningAmplifierMultiplier() {
        return this.getFloat("potionCombiningAmplifierMultiplier");
    }

    public void setPotionCombiningAmplifierMultiplier(float volume) {
        this.setFloat("potionCombiningAmplifierMultiplier", volume);
    }

    public float getPotionCombiningDurationMultiplier() {
        return this.getFloat("potionCombiningDurationMultiplier");
    }

    public void setPotionCombiningDurationMultiplier(float volume) {
        this.setFloat("potionCombiningDurationMultiplier", volume);
    }

    public int getPotionCombiningMaxCombinations() {
        return this.getInt("potionCombiningMaxCombinations");
    }

    public void setPotionCombiningMaxCombinations(int volume) {
        this.setInt("potionCombiningMaxCombinations", volume);
    }

    public int getBrewingSkill(EffectClass effectClass) {
        if (effectClass == null) {
            return this.getInt("genericBrewingSkill");
        }
        return switch (effectClass) {
            case EffectClass.BUFF -> this.getInt("buffBrewingSkill");
            case EffectClass.DEBUFF -> this.getInt("debuffBrewingSkill");
            default -> 0;
        };
    }

    public void setBrewingSkill(EffectClass effectClass, int value) {
        if (effectClass == null) {
            this.setInt("genericBrewingSkill", value);
        } else {
            switch (effectClass) {
                case BUFF: {
                    this.setInt("buffBrewingSkill", value);
                    break;
                }
                case DEBUFF: {
                    this.setInt("debuffBrewingSkill", value);
                }
            }
        }
    }

    public float getBrewingSkillMultiplier(EffectClass effectClass) {
        if (effectClass == null) {
            return this.getFloat("genericBrewingSkillFractionBonus");
        }
        return switch (effectClass) {
            case EffectClass.BUFF -> this.getFloat("buffBrewingSkillFractionBonus");
            case EffectClass.DEBUFF -> this.getFloat("debuffBrewingSkillFractionBonus");
            default -> 0.0f;
        };
    }

    public void setBrewingSkillMultiplier(EffectClass effectClass, int value) {
        if (effectClass == null) {
            this.setFloat("genericBrewingSkillFractionBonus", value);
        } else {
            switch (effectClass) {
                case BUFF: {
                    this.setFloat("buffBrewingSkillFractionBonus", value);
                    break;
                }
                case DEBUFF: {
                    this.setFloat("debuffBrewingSkillFractionBonus", value);
                }
            }
        }
    }

    public float getBrewingTimeReduction() {
        return this.getFloat("brewingTimeReduction");
    }

    public void setBrewingTimeReduction(float volume) {
        this.setFloat("brewingTimeReduction", volume);
    }

    public float getPotionSaveChance() {
        return this.getFloat("potionSaveChance");
    }

    public void setPotionSaveChance(float volume) {
        this.setFloat("potionSaveChance", volume);
    }

    public float getBrewingIngredientSaveChance() {
        return this.getFloat("brewingIngredientSaveChance");
    }

    public void setBrewingIngredientSaveChance(float volume) {
        this.setFloat("brewingIngredientSaveChance", volume);
    }

    public float getThrowVelocity() {
        return this.getFloat("throwVelocity");
    }

    public void setThrowVelocity(float volume) {
        this.setFloat("throwVelocity", volume);
    }

    public double getAlchemyEXPMultiplier() {
        return this.getDouble("alchemyEXPMultiplier");
    }

    public void setAlchemyEXPMultiplier(double value) {
        this.setDouble("alchemyEXPMultiplier", value);
    }

    public float getLlingeringRadiusMultiplier() {
        return this.getFloat("lingeringRadiusMultiplier");
    }

    public void setLlingeringRadiusMultiplier(float volume) {
        this.setFloat("lingeringRadiusMultiplier", volume);
    }

    public float getLingeringDurationMultiplier() {
        return this.getFloat("lingeringDurationMultiplier");
    }

    public void setLingeringDurationMultiplier(float volume) {
        this.setFloat("lingeringDurationMultiplier", volume);
    }

    public float getSplashIntensityMinimum() {
        return this.getFloat("splashIntensityMinimum");
    }

    public void setSplashIntensityMinimum(float volume) {
        this.setFloat("splashIntensityMinimum", volume);
    }

    public AlchemyProfile(UUID owner) {
        super(owner);
        this.floatStat("genericBrewingSkill", new PropertyBuilder().format(StatFormat.FLOAT_P2).min(0.0).perkReward().create());
        this.floatStat("buffBrewingSkill", new PropertyBuilder().format(StatFormat.FLOAT_P2).min(0.0).perkReward().create());
        this.floatStat("debuffBrewingSkill", new PropertyBuilder().format(StatFormat.FLOAT_P2).min(0.0).perkReward().create());
        this.floatStat("genericBrewingSkillFractionBonus", new PropertyBuilder().format(StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("buffBrewingSkillFractionBonus", new PropertyBuilder().format(StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("debuffBrewingSkillFractionBonus", new PropertyBuilder().format(StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("brewingTimeReduction", new PropertyBuilder().format(StatFormat.PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("potionSaveChance", new PropertyBuilder().format(StatFormat.PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("brewingIngredientSaveChance", new PropertyBuilder().format(StatFormat.PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("throwVelocity", new PropertyBuilder().format(StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("lingeringRadiusMultiplier", new PropertyBuilder().format(StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("lingeringDurationMultiplier", new PropertyBuilder().format(StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("splashIntensityMinimum", new PropertyBuilder().format(StatFormat.PERCENTILE_BASE_1_P1).perkReward().create());
        this.booleanStat("potionCombiningUnlocked", false, new BooleanProperties(true, true));
        this.intStat("potionCombiningMaxCombinations", new PropertyBuilder().format(StatFormat.INT).perkReward().create());
        this.floatStat("potionCombiningAmplifierMultiplier", new PropertyBuilder().format(StatFormat.PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("potionCombiningDurationMultiplier", new PropertyBuilder().format(StatFormat.PERCENTILE_BASE_1_P1).perkReward().create());
        this.intStat("transmutationRadius", new PropertyBuilder().format(StatFormat.INT).perkReward().create());
        this.stringSetStat("unlockedTransmutations");
        this.doubleStat("alchemyEXPMultiplier", new PropertyBuilder().format(StatFormat.PERCENTILE_BASE_1_P2).perkReward().create());
    }

    @Override
    public String getTableName() {
        return "profiles_alchemy";
    }

    @Override
    public Profile getBlankProfile(UUID owner) {
        return ProfileRegistry.copyDefaultStats(new AlchemyProfile(owner));
    }

    @Override
    public Class<? extends Skill> getSkillType() {
        return AlchemySkill.class;
    }
}

