/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.playerstats.statsources;

import me.athlaeos.valhallammo.playerstats.AccumulativeStatSource;
import me.athlaeos.valhallammo.playerstats.EntityCache;
import me.athlaeos.valhallammo.playerstats.EntityProperties;
import me.athlaeos.valhallammo.potioneffects.CustomPotionEffect;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;

public class PotionEffectSource
implements AccumulativeStatSource {
    private final String potionEffect;
    private final boolean negative;

    public PotionEffectSource(String potionEffect, boolean negative) {
        this.potionEffect = potionEffect;
        this.negative = negative;
    }

    public PotionEffectSource(String potionEffect) {
        this.potionEffect = potionEffect;
        this.negative = false;
    }

    @Override
    public double fetch(Entity statPossessor, boolean use) {
        if (statPossessor instanceof LivingEntity) {
            LivingEntity l = (LivingEntity)statPossessor;
            EntityProperties properties = EntityCache.getAndCacheProperties(l);
            CustomPotionEffect effect = properties.getActivePotionEffects().get(this.potionEffect);
            return effect == null ? 0.0 : (this.negative ? -effect.getAmplifier() : effect.getAmplifier());
        }
        return 0.0;
    }
}

