/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.playerstats.statsources;

import java.util.UUID;
import me.athlaeos.valhallammo.playerstats.AccumulativeStatSource;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileCache;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileRegistry;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.WoodcuttingProfile;
import me.athlaeos.valhallammo.skills.skills.SkillRegistry;
import me.athlaeos.valhallammo.skills.skills.implementations.WoodcuttingSkill;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class WoodcuttingStatSource
implements AccumulativeStatSource {
    private final String stat;
    private final Class<? extends Number> numberType;
    private final double def;

    public WoodcuttingStatSource(String stat) {
        this.stat = stat;
        WoodcuttingProfile baseProfile = ProfileRegistry.getBlankProfile((UUID)null, WoodcuttingProfile.class);
        if (baseProfile.intStatNames().contains(stat)) {
            this.def = baseProfile.getDefaultInt(stat);
            this.numberType = Integer.class;
        } else if (baseProfile.floatStatNames().contains(stat)) {
            this.def = baseProfile.getDefaultFloat(stat);
            this.numberType = Float.class;
        } else if (baseProfile.doubleStatNames().contains(stat)) {
            this.def = baseProfile.getDefaultDouble(stat);
            this.numberType = Double.class;
        } else {
            this.def = 0.0;
            this.numberType = null;
        }
        if (this.numberType == null) {
            throw new IllegalArgumentException("WoodcuttingStatSource:" + WoodcuttingProfile.class.getSimpleName() + " with stat " + stat + " was initialized, but this profile type does not have such a stat");
        }
    }

    @Override
    public double fetch(Entity statPossessor, boolean use) {
        WoodcuttingSkill woodcuttingSkill;
        WoodcuttingSkill woodcuttingSkill2 = woodcuttingSkill = SkillRegistry.isRegistered(WoodcuttingSkill.class) ? (WoodcuttingSkill)SkillRegistry.getSkill(WoodcuttingSkill.class) : null;
        if (statPossessor instanceof Player) {
            Player p = (Player)statPossessor;
            if (woodcuttingSkill != null) {
                Block b = p.getTargetBlockExact(8);
                if (b == null || !woodcuttingSkill.getDropsExpValues().containsKey(b.getType())) {
                    return this.def;
                }
                WoodcuttingProfile profile = ProfileCache.getOrCache(p, WoodcuttingProfile.class);
                if (this.numberType.equals(Integer.class)) {
                    return profile.getInt(this.stat);
                }
                if (this.numberType.equals(Float.class)) {
                    return profile.getFloat(this.stat);
                }
                return profile.getDouble(this.stat);
            }
        }
        return this.def;
    }
}

