/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.potioneffects.effect_triggers;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import me.athlaeos.valhallammo.dom.CustomDamageType;
import me.athlaeos.valhallammo.potioneffects.effect_triggers.EffectTrigger;
import me.athlaeos.valhallammo.potioneffects.effect_triggers.implementations.Constant;
import me.athlaeos.valhallammo.potioneffects.effect_triggers.implementations.DayTimeOrLightExposure;
import me.athlaeos.valhallammo.potioneffects.effect_triggers.implementations.OnAttack;
import me.athlaeos.valhallammo.potioneffects.effect_triggers.implementations.OnDamageTick;
import me.athlaeos.valhallammo.potioneffects.effect_triggers.implementations.Submerged;
import me.athlaeos.valhallammo.potioneffects.effect_triggers.implementations.WhileCombatStatus;
import me.athlaeos.valhallammo.potioneffects.effect_triggers.implementations.WhileMovementModifier;
import me.athlaeos.valhallammo.potioneffects.effect_triggers.implementations.WhileStandingStill;
import org.bukkit.entity.LivingEntity;

public class EffectTriggerRegistry {
    private static final Map<UUID, Collection<String>> entitiesAffectedCache = new HashMap<UUID, Collection<String>>();
    private static final Map<String, EffectTrigger> registeredTriggers = new HashMap<String, EffectTrigger>();

    public static void register(EffectTrigger trigger) {
        if (trigger.id() == null) {
            return;
        }
        registeredTriggers.put(trigger.id(), trigger);
        trigger.onRegister();
    }

    public static EffectTrigger getTrigger(String id) {
        return registeredTriggers.get(id);
    }

    public static Map<String, EffectTrigger> getRegisteredTriggers() {
        return new HashMap<String, EffectTrigger>(registeredTriggers);
    }

    public static boolean isEntityAffectedByTrigger(LivingEntity entity, String triggerType) {
        return ((Collection)entitiesAffectedCache.getOrDefault(entity.getUniqueId(), new HashSet())).contains(triggerType);
    }

    public static void setEntityAffected(LivingEntity entity, String triggerType, boolean affected) {
        Collection affectedByTriggers = entitiesAffectedCache.getOrDefault(entity.getUniqueId(), new HashSet());
        if (affected) {
            affectedByTriggers.add(triggerType);
        } else {
            affectedByTriggers.remove(triggerType);
        }
        if (affectedByTriggers.isEmpty()) {
            entitiesAffectedCache.remove(entity.getUniqueId());
        } else {
            entitiesAffectedCache.put(entity.getUniqueId(), affectedByTriggers);
        }
    }

    public static void setEntityTriggerTypesAffected(LivingEntity entity, Collection<String> affectedByTriggers) {
        if (affectedByTriggers.isEmpty()) {
            entitiesAffectedCache.remove(entity.getUniqueId());
        } else {
            entitiesAffectedCache.put(entity.getUniqueId(), affectedByTriggers);
        }
    }

    static {
        EffectTriggerRegistry.register(new Constant());
        for (CustomDamageType type : CustomDamageType.getRegisteredTypes().values()) {
            EffectTriggerRegistry.register(new OnDamageTick(type));
        }
        EffectTriggerRegistry.register(new OnDamageTick(null));
        EffectTriggerRegistry.register(new OnAttack(false, false));
        EffectTriggerRegistry.register(new OnAttack(false, true));
        EffectTriggerRegistry.register(new OnAttack(true, false));
        EffectTriggerRegistry.register(new OnAttack(true, true));
        EffectTriggerRegistry.register(new WhileMovementModifier(null));
        EffectTriggerRegistry.register(new WhileMovementModifier(true));
        EffectTriggerRegistry.register(new WhileMovementModifier(false));
        EffectTriggerRegistry.register(new WhileStandingStill(true));
        EffectTriggerRegistry.register(new WhileStandingStill(false));
        EffectTriggerRegistry.register(new WhileCombatStatus(true));
        EffectTriggerRegistry.register(new WhileCombatStatus(false));
        EffectTriggerRegistry.register(new DayTimeOrLightExposure(null, true, null));
        EffectTriggerRegistry.register(new DayTimeOrLightExposure(true, null, null));
        EffectTriggerRegistry.register(new DayTimeOrLightExposure(null, false, null));
        EffectTriggerRegistry.register(new DayTimeOrLightExposure(false, null, null));
        EffectTriggerRegistry.register(new DayTimeOrLightExposure(false, false, null));
        EffectTriggerRegistry.register(new DayTimeOrLightExposure(false, true, null));
        EffectTriggerRegistry.register(new DayTimeOrLightExposure(true, false, null));
        EffectTriggerRegistry.register(new DayTimeOrLightExposure(true, true, null));
        EffectTriggerRegistry.register(new DayTimeOrLightExposure(null, true, true));
        EffectTriggerRegistry.register(new DayTimeOrLightExposure(null, true, false));
        EffectTriggerRegistry.register(new DayTimeOrLightExposure(true, null, true));
        EffectTriggerRegistry.register(new DayTimeOrLightExposure(true, null, false));
        EffectTriggerRegistry.register(new DayTimeOrLightExposure(null, false, true));
        EffectTriggerRegistry.register(new DayTimeOrLightExposure(null, false, false));
        EffectTriggerRegistry.register(new DayTimeOrLightExposure(false, null, true));
        EffectTriggerRegistry.register(new DayTimeOrLightExposure(false, null, false));
        EffectTriggerRegistry.register(new DayTimeOrLightExposure(false, false, true));
        EffectTriggerRegistry.register(new DayTimeOrLightExposure(false, false, false));
        EffectTriggerRegistry.register(new DayTimeOrLightExposure(false, true, true));
        EffectTriggerRegistry.register(new DayTimeOrLightExposure(false, true, false));
        EffectTriggerRegistry.register(new DayTimeOrLightExposure(true, false, true));
        EffectTriggerRegistry.register(new DayTimeOrLightExposure(true, false, false));
        EffectTriggerRegistry.register(new DayTimeOrLightExposure(true, true, true));
        EffectTriggerRegistry.register(new DayTimeOrLightExposure(true, true, false));
        EffectTriggerRegistry.register(new Submerged(true));
        EffectTriggerRegistry.register(new Submerged(false));
    }
}

