/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.potioneffects.implementations;

import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.dom.CombatType;
import me.athlaeos.valhallammo.item.CustomFlag;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.playerstats.format.StatFormat;
import me.athlaeos.valhallammo.potioneffects.EffectClass;
import me.athlaeos.valhallammo.potioneffects.PotionEffectWrapper;
import me.athlaeos.valhallammo.utility.Bleeder;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.StringUtils;
import me.athlaeos.valhallammo.version.ConventionUtils;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.meta.PotionMeta;

public class Bleed
extends PotionEffectWrapper {
    private final String defaultIcon;

    public Bleed(String effect, String defaultIcon) {
        super(effect, false, true, null);
        this.defaultIcon = defaultIcon;
    }

    @Override
    public void onApply(ItemBuilder i) {
        boolean customFlag = CustomFlag.hasFlag(i.getMeta(), CustomFlag.DISPLAY_ATTRIBUTES);
        boolean vanillaFlag = i.getMeta().hasItemFlag(ConventionUtils.getHidePotionEffectsFlag());
        boolean temporaryCoatingDisplay = CustomFlag.hasFlag(i.getMeta(), CustomFlag.TEMPORARY_POTION_DISPLAY);
        if (this.isVanilla && i.getMeta() instanceof PotionMeta && (!customFlag || !vanillaFlag) || !this.isVanilla && (!temporaryCoatingDisplay || this.charges == 0) && vanillaFlag && !customFlag) {
            this.onRemove(i);
        } else {
            String translation = this.getEffectName();
            if (StringUtils.isEmpty(translation)) {
                return;
            }
            String prefix = this.prefix();
            String charges = TranslationManager.getTranslation("potion_effect_charges_format").replace("%prefix%", prefix).replace("%charges_roman%", this.charges >= 0 ? StringUtils.toRoman(this.charges) : "").replace("%charges_numeric%", String.valueOf(this.charges));
            int stacks = (int)Math.max(1.0, Math.floor(this.amplifier));
            double damage = (this.amplifier - (double)stacks) * 10.0;
            i.appendLore(prefix + (translation.replace("%icon%", this.getEffectIcon() + prefix).replace("%value%", String.format("%s %.1f", StringUtils.toRoman(Math.max(1, stacks)), damage)).replace("%duration%", String.format("(%s)", StringUtils.toTimeStamp(this.duration, 20L))) + (this.charges <= 0 ? "" : charges)).trim());
        }
    }

    @Override
    public void onInflict(LivingEntity p, LivingEntity causedBy, double amplifier, int duration, double intensity) {
        int stacks = (int)Math.max(1.0, Math.floor(amplifier));
        double damage = (amplifier - (double)stacks) * 10.0;
        Bleeder.inflictBleed(p, (Entity)causedBy, (int)(intensity * (double)duration), damage, stacks, CombatType.RANGED);
    }

    @Override
    public void onRemove(ItemBuilder i) {
        String translation = this.getEffectName();
        if (StringUtils.isEmpty(translation)) {
            return;
        }
        ItemUtils.removeIfLoreContains(i, translation.replace("%icon%", "").replace("%value%", "").replace("%duration%", "").trim());
    }

    @Override
    public void onExpire(LivingEntity entity) {
    }

    @Override
    public EffectClass getClassification(double amplifier) {
        return EffectClass.DEBUFF;
    }

    @Override
    public String getEffectIcon() {
        return StringUtils.isEmpty(super.getEffectIcon()) ? (ValhallaMMO.isResourcePackConfigForced() ? "&f" + this.defaultIcon : super.getEffectIcon()) : super.getEffectIcon();
    }

    @Override
    public boolean isSingleUse() {
        return false;
    }

    @Override
    public PotionEffectWrapper copy() {
        return new Bleed(this.getEffect(), this.defaultIcon).setCharges(this.charges).setDuration(this.duration).setAmplifier(this.amplifier);
    }

    private String prefix() {
        return TranslationManager.getTranslation("stat_potion_negative_prefix");
    }

    @Override
    public StatFormat getFormat() {
        return StatFormat.ROMAN;
    }
}

