/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.skills.skills.implementations;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.configuration.ConfigManager;
import me.athlaeos.valhallammo.dom.Catch;
import me.athlaeos.valhallammo.dom.CombatType;
import me.athlaeos.valhallammo.entities.EntityClassification;
import me.athlaeos.valhallammo.event.EntityCriticallyHitEvent;
import me.athlaeos.valhallammo.event.PlayerSkillExperienceGainEvent;
import me.athlaeos.valhallammo.hooks.WorldGuardHook;
import me.athlaeos.valhallammo.item.CustomFlag;
import me.athlaeos.valhallammo.item.EquipmentClass;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.item.WeightClass;
import me.athlaeos.valhallammo.listeners.EntityAttackListener;
import me.athlaeos.valhallammo.listeners.EntityDamagedListener;
import me.athlaeos.valhallammo.listeners.EntitySpawnListener;
import me.athlaeos.valhallammo.playerstats.AccumulativeStatManager;
import me.athlaeos.valhallammo.playerstats.EntityCache;
import me.athlaeos.valhallammo.playerstats.profiles.Profile;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileCache;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.HeavyWeaponsProfile;
import me.athlaeos.valhallammo.potioneffects.PotionEffectRegistry;
import me.athlaeos.valhallammo.potioneffects.PotionEffectWrapper;
import me.athlaeos.valhallammo.potioneffects.implementations.Stun;
import me.athlaeos.valhallammo.skills.ChunkEXPNerf;
import me.athlaeos.valhallammo.skills.skills.Skill;
import me.athlaeos.valhallammo.utility.Bleeder;
import me.athlaeos.valhallammo.utility.EntityUtils;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.Timer;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Trident;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;

public class HeavyWeaponsSkill
extends Skill
implements Listener {
    private final Collection<Material> validCoatingItems = new HashSet<Material>();
    private final Map<EntityType, Double> entityExpMultipliers = new HashMap<EntityType, Double>();
    private double expPerDamage = 0.0;
    private double spawnerMultiplier = 0.0;
    private double maceExpMultiplier = 0.0;
    private boolean maxHealthLimitation = false;
    private double pvpMultiplier = 0.1;
    private boolean isChunkNerfed = true;

    public HeavyWeaponsSkill(String type) {
        super(type);
    }

    @Override
    public void loadConfiguration() {
        ValhallaMMO.getInstance().save("skills/heavy_weapons_progression.yml");
        ValhallaMMO.getInstance().save("skills/heavy_weapons.yml");
        YamlConfiguration skillConfig = ConfigManager.getConfig("skills/heavy_weapons.yml").get();
        YamlConfiguration progressionConfig = ConfigManager.getConfig("skills/heavy_weapons_progression.yml").get();
        this.loadCommonConfig(skillConfig, progressionConfig);
        this.validCoatingItems.addAll(ItemUtils.getMaterialSet(skillConfig.getStringList("valid_coating_items")));
        ConfigurationSection entitySection = progressionConfig.getConfigurationSection("experience.exp_enemies_nerfed");
        if (entitySection != null) {
            entitySection.getKeys(false).forEach(s -> {
                EntityType e = Catch.catchOrElse(() -> EntityType.valueOf((String)s), null, "Invalid entity type given in skills/heavy_weapons_progression.yml experience.entity_exp_multipliers." + s);
                if (e == null) {
                    return;
                }
                double multiplier = progressionConfig.getDouble("experience.entity_exp_multipliers." + s);
                this.entityExpMultipliers.put(e, multiplier);
            });
        }
        this.expPerDamage = progressionConfig.getDouble("experience.exp_per_damage");
        this.spawnerMultiplier = progressionConfig.getDouble("experience.spawner_spawned_multiplier");
        this.maceExpMultiplier = progressionConfig.getDouble("experience.mace_exp_multiplier");
        this.maxHealthLimitation = progressionConfig.getBoolean("experience.max_health_limitation");
        this.pvpMultiplier = progressionConfig.getDouble("experience.pvp_multiplier");
        this.isChunkNerfed = progressionConfig.getBoolean("experience.is_chunk_nerfed", true);
        ValhallaMMO.getInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)ValhallaMMO.getInstance());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onCoatingApply(InventoryClickEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getWhoClicked().getWorld().getName()) || !Timer.isCooldownPassed(e.getWhoClicked().getUniqueId(), "delay_heavy_coating_attempts") || WorldGuardHook.inDisabledRegion(e.getWhoClicked().getLocation(), (Player)e.getWhoClicked(), "vmmo-skill-heavyweapons")) {
            return;
        }
        if (!(e.getClickedInventory() instanceof PlayerInventory) || !e.isRightClick()) {
            return;
        }
        if (!this.hasPermissionAccess((Player)e.getWhoClicked())) {
            return;
        }
        Timer.setCooldown(e.getWhoClicked().getUniqueId(), 500, "delay_heavy_coating_attempts");
        if (ItemUtils.isEmpty(e.getCurrentItem()) || ItemUtils.isEmpty(e.getCursor())) {
            return;
        }
        if (!this.validCoatingItems.contains(e.getCursor().getType())) {
            return;
        }
        HeavyWeaponsProfile profile = ProfileCache.getOrCache((Player)e.getWhoClicked(), HeavyWeaponsProfile.class);
        if (!profile.isCoatingUnlocked()) {
            return;
        }
        ItemBuilder clicked = new ItemBuilder(e.getCurrentItem());
        if (!PotionEffectRegistry.getStoredEffects(clicked.getMeta(), false).isEmpty()) {
            return;
        }
        ItemBuilder cursor = new ItemBuilder(e.getCursor());
        if (WeightClass.getWeightClass(clicked.getMeta()) != WeightClass.HEAVY || !EquipmentClass.isHandHeld(clicked.getMeta())) {
            return;
        }
        Map<String, PotionEffectWrapper> effects = PotionEffectRegistry.getStoredEffects(cursor.getMeta(), false);
        if (effects.isEmpty()) {
            return;
        }
        HashMap<String, PotionEffectWrapper> newEffects = new HashMap<String, PotionEffectWrapper>();
        for (PotionEffectWrapper wrapper : effects.values()) {
            newEffects.put(wrapper.getEffect(), wrapper.setAmplifier((double)(1.0f + profile.getCoatingAmplifierMultiplier()) * wrapper.getAmplifier()).setDuration((int)Math.floor((1.0f + profile.getCoatingDurationMultiplier()) * (float)wrapper.getDuration())).setCharges(profile.getCoatingCharges()));
        }
        clicked.flag(CustomFlag.TEMPORARY_POTION_DISPLAY);
        PotionEffectRegistry.setDefaultStoredEffects(clicked, newEffects);
        PotionEffectRegistry.setActualStoredEffects(clicked, newEffects);
        e.setCurrentItem(clicked.get());
        e.setCancelled(true);
        e.getWhoClicked().getWorld().playSound(e.getWhoClicked().getLocation(), Sound.BLOCK_FIRE_EXTINGUISH, 1.0f, 1.0f);
        e.getWhoClicked().getWorld().playSound(e.getWhoClicked().getLocation(), Sound.BLOCK_BREWING_STAND_BREW, 1.0f, 1.0f);
        if (cursor.getItem().getAmount() == 1) {
            e.getWhoClicked().setItemOnCursor(null);
        } else {
            e.getCursor().setAmount(e.getCursor().getAmount() - 1);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onAttack(EntityDamageByEntityEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getEntity().getWorld().getName())) {
            return;
        }
        Entity trueDamager = EntityUtils.getTrueDamager(e);
        if (trueDamager instanceof Player) {
            Entity entity;
            Player p = (Player)trueDamager;
            if ((!(e.getDamager() instanceof AbstractArrow) || e.getDamager() instanceof Trident) && (entity = e.getEntity()) instanceof LivingEntity) {
                boolean facing;
                Trident t;
                ItemBuilder weapon;
                LivingEntity l = (LivingEntity)entity;
                if (WorldGuardHook.inDisabledRegion(p.getLocation(), p, "vmmo-skill-heavyweapons")) {
                    return;
                }
                Entity entity2 = e.getDamager();
                ItemBuilder itemBuilder = weapon = entity2 instanceof Trident && !ItemUtils.isEmpty((t = (Trident)entity2).getItem()) ? new ItemBuilder(t.getItem()) : EntityCache.getAndCacheProperties((LivingEntity)p).getMainHand();
                if (weapon == null || WeightClass.getWeightClass(weapon.getMeta()) != WeightClass.HEAVY) {
                    return;
                }
                HeavyWeaponsProfile profile = ProfileCache.getOrCache(p, HeavyWeaponsProfile.class);
                if (profile.doesCritOnBleed() && Bleeder.getBleedingEntities().containsKey(l.getUniqueId())) {
                    EntityAttackListener.critNextAttack((LivingEntity)p);
                } else if (profile.doesCritOnStun() && Stun.isStunned(l)) {
                    EntityAttackListener.critNextAttack((LivingEntity)p);
                } else if (profile.doesCritOnStealth() && !(facing = EntityUtils.isEntityFacing(l, e.getDamager().getLocation(), EntityAttackListener.getFacingAngleCos())) && p.isSneaking() && !EntityAttackListener.isInCombat(p)) {
                    EntityAttackListener.critNextAttack((LivingEntity)p);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onExpAttack(EntityDamageEvent e) {
        Player pl;
        Trident t;
        ProjectileSource projectileSource;
        Player p;
        Player pl2;
        LivingEntity l;
        Entity entity;
        if (ValhallaMMO.isWorldBlacklisted(e.getEntity().getWorld().getName()) || EntityClassification.matchesClassification(e.getEntityType(), EntityClassification.UNALIVE) || e.getCause() == EntityDamageEvent.DamageCause.ENTITY_SWEEP_ATTACK || !((entity = e.getEntity()) instanceof LivingEntity) || EntityClassification.matchesClassification((l = (LivingEntity)entity).getType(), EntityClassification.PASSIVE)) {
            return;
        }
        Entity damager = EntityDamagedListener.getLastDamager(l);
        Object object = damager instanceof Player ? (pl2 = (Player)damager) : (p = damager instanceof Trident && (projectileSource = (t = (Trident)damager).getShooter()) instanceof Player ? (pl = (Player)projectileSource) : null);
        if (p != null) {
            ItemBuilder weapon;
            if (WorldGuardHook.inDisabledRegion(p.getLocation(), p, "vmmo-skill-heavyweapons")) {
                return;
            }
            if (damager instanceof Trident) {
                t = (Trident)damager;
                v1 = new ItemBuilder(t.getItem());
            } else {
                v1 = weapon = EntityCache.getAndCacheProperties((LivingEntity)p).getMainHand();
            }
            if (weapon == null || WeightClass.getWeightClass(weapon.getMeta()) != WeightClass.HEAVY) {
                return;
            }
            ValhallaMMO.getInstance().getServer().getScheduler().runTaskLater((Plugin)ValhallaMMO.getInstance(), () -> {
                double pvpMult;
                IronGolem g;
                if (!p.isOnline() || l instanceof IronGolem && (g = (IronGolem)l).isPlayerCreated()) {
                    return;
                }
                if (e.getDamage() > 1000000.0) {
                    return;
                }
                double chunkNerf = !this.isChunkNerfed || EntitySpawnListener.isTrialSpawned((Entity)l) ? 1.0 : ChunkEXPNerf.getChunkEXPNerf(l.getLocation().getChunk(), p, "weapons");
                double entityExpMultiplier = this.entityExpMultipliers.getOrDefault(l.getType(), 1.0);
                double d = pvpMult = e.getEntity() instanceof Player ? this.pvpMultiplier : 1.0;
                this.addEXP(p, this.maxHealthLimitation ? Math.min(EntityUtils.getMaxHP(l), e.getDamage()) : e.getDamage() * (weapon.getItem().getType().toString().equals("MACE") ? this.maceExpMultiplier : 1.0) * this.expPerDamage * pvpMult * entityExpMultiplier * chunkNerf * (EntitySpawnListener.getSpawnReason((Entity)l) == CreatureSpawnEvent.SpawnReason.SPAWNER ? this.spawnerMultiplier : 1.0), false, PlayerSkillExperienceGainEvent.ExperienceGainReason.SKILL_ACTION);
                if (this.isChunkNerfed && !EntitySpawnListener.isTrialSpawned((Entity)l)) {
                    ChunkEXPNerf.increment(l.getLocation().getChunk(), p, "weapons");
                }
            }, 2L);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onCrit(EntityCriticallyHitEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getEntity().getWorld().getName())) {
            return;
        }
        Entity entity = e.getCritter();
        if (entity instanceof Player) {
            Player p = (Player)entity;
            entity = e.getEntity();
            if (entity instanceof LivingEntity) {
                LivingEntity l = (LivingEntity)entity;
                if (WorldGuardHook.inDisabledRegion(p.getLocation(), p, "vmmo-skill-heavyweapons")) {
                    return;
                }
                ItemBuilder weapon = EntityCache.getAndCacheProperties((LivingEntity)p).getMainHand();
                if (weapon == null || WeightClass.getWeightClass(weapon.getMeta()) != WeightClass.HEAVY) {
                    return;
                }
                HeavyWeaponsProfile profile = ProfileCache.getOrCache(p, HeavyWeaponsProfile.class);
                if (profile.doesBleedOnCrit()) {
                    Bleeder.inflictBleed(l, (Entity)p, CombatType.MELEE_ARMED);
                }
                if (profile.doesStunOnCrit()) {
                    Stun.attemptStun(l, (LivingEntity)p);
                }
            }
        }
    }

    @Override
    public boolean isLevelableSkill() {
        return true;
    }

    @Override
    public Class<? extends Profile> getProfileType() {
        return HeavyWeaponsProfile.class;
    }

    @Override
    public int getSkillTreeMenuOrderPriority() {
        return 45;
    }

    @Override
    public void addEXP(Player p, double amount, boolean silent, PlayerSkillExperienceGainEvent.ExperienceGainReason reason) {
        if (WorldGuardHook.inDisabledRegion(p.getLocation(), p, "vmmo-skill-heavyweapons")) {
            return;
        }
        if (reason == PlayerSkillExperienceGainEvent.ExperienceGainReason.SKILL_ACTION) {
            amount *= 1.0 + AccumulativeStatManager.getCachedStats("HEAVY_WEAPONS_EXP_GAIN", (Entity)p, 10000L, true);
        }
        super.addEXP(p, amount, silent, reason);
    }
}

