/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.skills.skills.implementations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.commands.valhallasubcommands.Debugger;
import me.athlaeos.valhallammo.configuration.ConfigManager;
import me.athlaeos.valhallammo.event.PlayerBlocksDropItemsEvent;
import me.athlaeos.valhallammo.event.PlayerSkillExperienceGainEvent;
import me.athlaeos.valhallammo.hooks.WorldGuardHook;
import me.athlaeos.valhallammo.item.EquipmentClass;
import me.athlaeos.valhallammo.listeners.CustomBreakSpeedListener;
import me.athlaeos.valhallammo.listeners.LootListener;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.playerstats.AccumulativeStatManager;
import me.athlaeos.valhallammo.playerstats.EntityCache;
import me.athlaeos.valhallammo.playerstats.EntityProperties;
import me.athlaeos.valhallammo.playerstats.profiles.Profile;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileCache;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.WoodcuttingProfile;
import me.athlaeos.valhallammo.skills.skills.Skill;
import me.athlaeos.valhallammo.utility.BlockStore;
import me.athlaeos.valhallammo.utility.BlockUtils;
import me.athlaeos.valhallammo.utility.EntityUtils;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.MathUtils;
import me.athlaeos.valhallammo.utility.Timer;
import me.athlaeos.valhallammo.utility.Utils;
import org.bukkit.GameMode;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.Container;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Leaves;
import org.bukkit.block.data.type.Sapling;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDropItemEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.LeavesDecayEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class WoodcuttingSkill
extends Skill
implements Listener {
    private final Map<Material, Double> dropsExpValues = new HashMap<Material, Double>();
    private final Map<Material, Double> stripExpValues = new HashMap<Material, Double>();
    private final Collection<Material> treeCapitatorPreventionBlocks = new HashSet<Material>();
    private int treeCapitatorLimit = 128;
    private boolean treeCapitatorInstant = true;
    private int treeCapitatorLeavesLimit = 256;
    private int treeScanLimit = 256;
    private boolean forgivingDropMultipliers = true;
    private final int[][] treeCapitatorScanArea = MathUtils.getOffsetsBetweenPoints(new int[]{-1, 0, -1}, new int[]{1, 1, 1}, new int[0][]);
    private final int[][] treeCapitatorLeavesScanArea = new int[][]{{-1, 0, 0}, {1, 0, 0}, {0, -1, 0}, {0, 1, 0}, {0, 0, -1}, {0, 0, 1}, {0, -2, 0}, {0, -3, 0}};
    private final Collection<UUID> treeCapitatingPlayers = new HashSet<UUID>();
    private final int[][] treeScanArea = MathUtils.getOffsetsBetweenPoints(new int[]{-1, 1, -1}, new int[]{1, 1, 1}, new int[0][]);

    public WoodcuttingSkill(String type) {
        super(type);
    }

    @Override
    public void loadConfiguration() {
        ConfigurationSection blockStripSection;
        ValhallaMMO.getInstance().save("skills/woodcutting_progression.yml");
        ValhallaMMO.getInstance().save("skills/woodcutting.yml");
        YamlConfiguration skillConfig = ConfigManager.getConfig("skills/woodcutting.yml").get();
        YamlConfiguration progressionConfig = ConfigManager.getConfig("skills/woodcutting_progression.yml").get();
        this.loadCommonConfig(skillConfig, progressionConfig);
        this.treeCapitatorLimit = skillConfig.getInt("break_limit_tree_capitator");
        this.treeCapitatorInstant = skillConfig.getBoolean("tree_capitator_instant");
        this.treeCapitatorLeavesLimit = skillConfig.getInt("leaf_decay_limit_tree_capitator");
        this.forgivingDropMultipliers = skillConfig.getBoolean("forgiving_multipliers");
        this.treeScanLimit = skillConfig.getInt("tree_scan_limit");
        for (String s : skillConfig.getStringList("tree_capitator_prevention_blocks")) {
            Material m = ItemUtils.stringToMaterial(s, null);
            if (m == null) continue;
            this.treeCapitatorPreventionBlocks.add(m);
        }
        HashSet<String> invalidMaterials = new HashSet<String>();
        ConfigurationSection blockBreakSection = progressionConfig.getConfigurationSection("experience.woodcutting_break");
        if (blockBreakSection != null) {
            for (String key : blockBreakSection.getKeys(false)) {
                try {
                    Material block = Material.valueOf((String)key);
                    double reward = progressionConfig.getDouble("experience.woodcutting_break." + key);
                    this.dropsExpValues.put(block, reward);
                }
                catch (IllegalArgumentException ignored) {
                    invalidMaterials.add(key);
                }
            }
        }
        if ((blockStripSection = progressionConfig.getConfigurationSection("experience.woodcutting_strip")) != null) {
            for (String key : blockStripSection.getKeys(false)) {
                try {
                    Material block = Material.valueOf((String)key);
                    double reward = progressionConfig.getDouble("experience.woodcutting_strip." + key);
                    this.stripExpValues.put(block, reward);
                }
                catch (IllegalArgumentException ignored) {
                    invalidMaterials.add(key);
                }
            }
        }
        if (!invalidMaterials.isEmpty()) {
            ValhallaMMO.logWarning("The following materials in skills/woodcutting_progression.yml do not exist, no exp values set (ignore warning if your version does not have these materials)");
            ValhallaMMO.logWarning(String.join((CharSequence)", ", invalidMaterials));
        }
        ValhallaMMO.getInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)ValhallaMMO.getInstance());
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getBlock().getWorld().getName()) || !this.isLog(e.getBlock()) || WorldGuardHook.inDisabledRegion(e.getPlayer().getLocation(), e.getPlayer(), "vmmo-skill-woodcutting") || !this.dropsExpValues.containsKey(e.getBlock().getType()) || e.getPlayer().getGameMode() == GameMode.CREATIVE) {
            return;
        }
        WoodcuttingProfile profile = ProfileCache.getOrCache(e.getPlayer(), WoodcuttingProfile.class);
        if (!this.hasPermissionAccess(e.getPlayer())) {
            Debugger.send(e.getPlayer(), "tree_capitator", "&cDoes not have permission access to Woodcutting");
            return;
        }
        double woodCuttingLuck = AccumulativeStatManager.getCachedStats("WOODCUTTING_LUCK", (Entity)e.getPlayer(), 10000L, true);
        if (BlockUtils.canReward(e.getBlock())) {
            e.setExpToDrop(e.getExpToDrop() + Utils.randomAverage(profile.getBlockExperienceRate()));
            LootListener.addPreparedLuck(e.getBlock(), woodCuttingLuck);
        }
        if (ItemUtils.isEmpty(e.getPlayer().getInventory().getItemInMainHand()) || !e.getPlayer().getInventory().getItemInMainHand().getType().toString().contains("_AXE")) {
            return;
        }
        if (e.getPlayer().isSneaking() && !this.treeCapitatingPlayers.contains(e.getPlayer().getUniqueId()) && profile.isTreeCapitatorUnlocked() && profile.getTreeCapitatorValidBlocks().contains(e.getBlock().getType().toString()) && Timer.isCooldownPassed(e.getPlayer().getUniqueId(), "woodcutting_tree_capitator") && this.isTree(e.getBlock()) && !WorldGuardHook.inDisabledRegion(e.getPlayer().getLocation(), e.getPlayer(), "vmmo-abilities-treecapitator")) {
            Collection<Block> vein = BlockUtils.getBlockVein(e.getBlock(), this.treeCapitatorLimit, b -> this.isLog((Block)b) || this.treeCapitatorPreventionBlocks.contains(b.getType()), this.treeCapitatorScanArea);
            if (vein.size() > profile.getTreeCapitatorLimit()) {
                Debugger.send(e.getPlayer(), "tree_capitator", "&cTree size " + vein.size() + " is above limit " + profile.getTreeCapitatorLimit());
                return;
            }
            if (vein.stream().anyMatch(b -> this.treeCapitatorPreventionBlocks.contains(b.getType()))) {
                Debugger.send(e.getPlayer(), "tree_capitator", "&cTree contains one of the following blocks: " + String.join((CharSequence)(this.treeCapitatorPreventionBlocks.stream().map(Enum::toString).collect(Collectors.joining(", ")) + ", which are tree capitator protection blocks"), new CharSequence[0]));
                return;
            }
            this.treeCapitatingPlayers.add(e.getPlayer().getUniqueId());
            e.setCancelled(true);
            Block leafOrigin = this.getTreeLeafOrigin(e.getBlock());
            if (this.treeCapitatorInstant) {
                if (!this.playerHasAxe(e.getPlayer())) {
                    Debugger.send(e.getPlayer(), "tree_capitator", "&cCached player properties indicates player does not have an axe.");
                    this.treeCapitatingPlayers.remove(e.getPlayer().getUniqueId());
                } else {
                    BlockUtils.processBlocks(e.getPlayer(), vein, this::playerHasAxe, b -> {
                        if (profile.isTreeCapitatorInstantPickup()) {
                            LootListener.setInstantPickup(b, e.getPlayer());
                        }
                        CustomBreakSpeedListener.markInstantBreak(b);
                        e.getPlayer().breakBlock(b);
                    }, b -> {
                        this.treeCapitatingPlayers.remove(e.getPlayer().getUniqueId());
                        ValhallaMMO.getInstance().getServer().getScheduler().runTaskLater((Plugin)ValhallaMMO.getInstance(), () -> {
                            ArrayList<Block> leaves = leafOrigin == null ? new ArrayList<Block>() : new ArrayList<Block>(BlockUtils.getBlockVein(leafOrigin, this.treeCapitatorLeavesLimit, bl -> {
                                Leaves l;
                                BlockData patt0$temp;
                                return this.isLeaves((Block)bl) && (!((patt0$temp = bl.getBlockData()) instanceof Leaves) || (l = (Leaves)patt0$temp).getDistance() > 3);
                            }, this.treeCapitatorLeavesScanArea));
                            Collections.shuffle(leaves);
                            BlockUtils.processBlocksDelayed(e.getPlayer(), leaves, p -> true, BlockUtils::decayBlock, null);
                        }, 20L);
                    });
                }
            } else {
                BlockUtils.processBlocksPulse(e.getPlayer(), e.getBlock(), vein, this::playerHasAxe, b -> {
                    if (profile.isTreeCapitatorInstantPickup()) {
                        LootListener.setInstantPickup(b, e.getPlayer());
                    }
                    CustomBreakSpeedListener.markInstantBreak(b);
                    e.getPlayer().breakBlock(b);
                }, b -> {
                    this.treeCapitatingPlayers.remove(e.getPlayer().getUniqueId());
                    ValhallaMMO.getInstance().getServer().getScheduler().runTaskLater((Plugin)ValhallaMMO.getInstance(), () -> {
                        ArrayList<Block> leaves = leafOrigin == null ? new ArrayList<Block>() : new ArrayList<Block>(BlockUtils.getBlockVein(leafOrigin, this.treeCapitatorLeavesLimit, bl -> {
                            Leaves l;
                            BlockData patt0$temp;
                            return this.isLeaves((Block)bl) && (!((patt0$temp = bl.getBlockData()) instanceof Leaves) || (l = (Leaves)patt0$temp).getDistance() > 3);
                        }, this.treeCapitatorLeavesScanArea));
                        Collections.shuffle(leaves);
                        BlockUtils.processBlocksDelayed(e.getPlayer(), leaves, p -> true, BlockUtils::decayBlock, null);
                    }, 20L);
                });
            }
            Timer.setCooldownIgnoreIfPermission((Entity)e.getPlayer(), profile.getTreeCapitatorCooldown() * 50, "woodcutting_tree_capitator");
        } else {
            if (Debugger.isDebuggerEnabled(e.getPlayer(), "tree_capitator")) {
                if (!e.getPlayer().isSneaking()) {
                    Debugger.send(e.getPlayer(), "tree_capitator", "&cPlayer is not sneaking");
                }
                if (this.treeCapitatingPlayers.contains(e.getPlayer().getUniqueId())) {
                    Debugger.send(e.getPlayer(), "tree_capitator", "&cPlayer is already processing a tree (This is only of concern if this message is sent once. If it is spammed, it is expected tree capitator worked here)");
                }
                if (!profile.isTreeCapitatorUnlocked()) {
                    Debugger.send(e.getPlayer(), "tree_capitator", "&cPlayer doesn't have tree capitator unlocked");
                }
                if (!profile.getTreeCapitatorValidBlocks().contains(e.getBlock().getType().toString())) {
                    Debugger.send(e.getPlayer(), "tree_capitator", "&cPlayer cannot tree capitate " + String.valueOf(e.getBlock().getType()));
                }
                if (!Timer.isCooldownPassed(e.getPlayer().getUniqueId(), "woodcutting_tree_capitator")) {
                    Debugger.send(e.getPlayer(), "tree_capitator", "&cTree capitator is on cooldown");
                }
                if (!this.isTree(e.getBlock())) {
                    Debugger.send(e.getPlayer(), "tree_capitator", "&cThis block (" + String.valueOf(e.getBlock().getType()) + ") is not considered part of a tree");
                }
                if (WorldGuardHook.inDisabledRegion(e.getPlayer().getLocation(), e.getPlayer(), "vmmo-abilities-treecapitator")) {
                    Debugger.send(e.getPlayer(), "tree_capitator", "&cAttempted tree capitation in worldguard blocked area");
                }
            }
            if (!Timer.isCooldownPassed(e.getPlayer().getUniqueId(), "woodcutting_tree_capitator")) {
                Timer.sendCooldownStatus(e.getPlayer(), "woodcutting_tree_capitator", TranslationManager.getTranslation("ability_tree_capitator"));
            }
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onBlockDecay(LeavesDecayEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getBlock().getWorld().getName())) {
            return;
        }
        Player p = null;
        List<Player> nearby = EntityUtils.getNearbyPlayers(e.getBlock().getLocation(), 100.0);
        if (!nearby.isEmpty()) {
            p = nearby.get(0);
        }
        if (p == null) {
            return;
        }
        double woodCuttingLuck = AccumulativeStatManager.getCachedStats("WOODCUTTING_LUCK", (Entity)p, 10000L, true);
        LootListener.addPreparedLuck(e.getBlock(), woodCuttingLuck);
        LootListener.setResponsibleBreaker(e.getBlock(), p);
    }

    private boolean playerHasAxe(Player p) {
        EntityProperties properties = EntityCache.getAndCacheProperties((LivingEntity)p);
        return properties.getMainHand() != null && EquipmentClass.getMatchingClass(properties.getMainHand().getMeta()) == EquipmentClass.AXE;
    }

    private boolean isTree(Block b) {
        Collection<Block> treeBlocks = BlockUtils.getBlockVein(b, this.treeScanLimit, l -> !BlockStore.isPlaced(l) && (this.isLog((Block)l) || this.isLeaves((Block)l)), this.treeScanArea);
        return treeBlocks.stream().anyMatch(l -> this.isLog((Block)l) && treeBlocks.stream().anyMatch(this::isLeaves));
    }

    private Block getTreeLeafOrigin(Block b) {
        for (int i = 1; i < 48 && !(b.getLocation().getY() + (double)i >= (double)b.getWorld().getMaxHeight()); ++i) {
            Block blockAt = b.getLocation().add(0.0, (double)i, 0.0).getBlock();
            if (this.isLeaves(blockAt)) {
                return blockAt;
            }
            if (blockAt.getType().isAir() || this.isLog(blockAt)) continue;
            return null;
        }
        return null;
    }

    private boolean isLeaves(Block block) {
        BlockData blockData;
        if (BlockStore.isPlaced(block)) {
            return false;
        }
        if (Tag.LEAVES.isTagged((Keyed)block.getType()) && (blockData = block.getBlockData()) instanceof Leaves) {
            Leaves l = (Leaves)blockData;
            return true;
        }
        return block.getType() == Material.NETHER_WART_BLOCK || block.getType() == Material.WARPED_WART_BLOCK || block.getType() == Material.SHROOMLIGHT;
    }

    private boolean isLog(Block block) {
        if (Tag.LOGS.isTagged((Keyed)block.getType())) {
            return true;
        }
        return block.getType().toString().equals("MANGROVE_ROOTS");
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void lootTableDrops(BlockBreakEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getBlock().getWorld().getName()) || !this.isLog(e.getBlock()) || !BlockUtils.canReward(e.getBlock()) || WorldGuardHook.inDisabledRegion(e.getPlayer().getLocation(), e.getPlayer(), "vmmo-skill-woodcutting") || e.getBlock().getState() instanceof Container) {
            return;
        }
        double dropMultiplier = AccumulativeStatManager.getCachedStats("WOODCUTTING_DROP_MULTIPLIER", (Entity)e.getPlayer(), 10000L, true);
        ItemUtils.multiplyItems(LootListener.getPreparedExtraDrops(e.getBlock()), 1.0 + dropMultiplier, this.forgivingDropMultipliers, i -> this.dropsExpValues.containsKey(i.getType()));
        double expQuantity = 0.0;
        for (ItemStack i2 : LootListener.getPreparedExtraDrops(e.getBlock())) {
            if (ItemUtils.isEmpty(i2)) continue;
            expQuantity += this.dropsExpValues.getOrDefault(i2.getType(), 0.0) * (double)i2.getAmount();
        }
        this.addEXP(e.getPlayer(), expQuantity, false, PlayerSkillExperienceGainEvent.ExperienceGainReason.SKILL_ACTION);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onItemsDropped(BlockDropItemEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getBlockState().getWorld().getName()) || !BlockUtils.canReward(e.getBlockState()) || WorldGuardHook.inDisabledRegion(e.getPlayer().getLocation(), e.getPlayer(), "vmmo-skill-woodcutting") || e.getBlockState() instanceof Container) {
            return;
        }
        double dropMultiplier = AccumulativeStatManager.getCachedStats("WOODCUTTING_DROP_MULTIPLIER", (Entity)e.getPlayer(), 10000L, true);
        List<ItemStack> extraDrops = ItemUtils.multiplyDrops(e.getItems(), 1.0 + dropMultiplier, this.forgivingDropMultipliers, i -> this.dropsExpValues.containsKey(i.getItemStack().getType()));
        if (!extraDrops.isEmpty()) {
            LootListener.prepareBlockDrops(e.getBlock(), extraDrops);
        }
        double expQuantity = 0.0;
        for (Item item : e.getItems()) {
            if (ItemUtils.isEmpty(item.getItemStack())) continue;
            expQuantity += this.dropsExpValues.getOrDefault(item.getItemStack().getType(), 0.0) * (double)item.getItemStack().getAmount();
        }
        for (ItemStack itemStack : extraDrops) {
            if (ItemUtils.isEmpty(itemStack)) continue;
            expQuantity += this.dropsExpValues.getOrDefault(itemStack.getType(), 0.0) * (double)itemStack.getAmount();
        }
        this.addEXP(e.getPlayer(), expQuantity, false, PlayerSkillExperienceGainEvent.ExperienceGainReason.SKILL_ACTION);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockPlaced(BlockPlaceEvent e) {
        BlockData amount2;
        if (ValhallaMMO.isWorldBlacklisted(e.getBlock().getWorld().getName()) || WorldGuardHook.inDisabledRegion(e.getPlayer().getLocation(), e.getPlayer(), "vmmo-skill-woodcutting")) {
            return;
        }
        Block b = e.getBlock();
        if (this.stripExpValues.containsKey(b.getType()) && this.dropsExpValues.containsKey(e.getBlockReplacedState().getType())) {
            double amount2 = this.stripExpValues.get(b.getType());
            if (amount2 > 0.0) {
                this.addEXP(e.getPlayer(), amount2, false, PlayerSkillExperienceGainEvent.ExperienceGainReason.SKILL_ACTION);
            }
        } else if (Tag.SAPLINGS.isTagged((Keyed)b.getType()) && (amount2 = b.getBlockData()) instanceof Sapling) {
            Sapling s = (Sapling)amount2;
            WoodcuttingProfile profile = ProfileCache.getOrCache(e.getPlayer(), WoodcuttingProfile.class);
            s.setStage(Math.min(Math.max(0, Utils.randomAverage(profile.getInstantGrowthRate())), s.getMaximumStage() - 1));
            e.getBlock().setBlockData((BlockData)s);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onOtherBlockDrops(PlayerBlocksDropItemsEvent e) {
        double exp = 0.0;
        for (Block b : e.getBlocksAndItems().keySet()) {
            for (ItemStack i : (List)e.getBlocksAndItems().getOrDefault(b, new ArrayList())) {
                if (ItemUtils.isEmpty(i)) continue;
                exp += this.dropsExpValues.getOrDefault(i.getType(), 0.0) * (double)i.getAmount();
            }
        }
        this.addEXP(e.getPlayer(), exp, false, PlayerSkillExperienceGainEvent.ExperienceGainReason.SKILL_ACTION);
    }

    @Override
    public boolean isLevelableSkill() {
        return true;
    }

    @Override
    public Class<? extends Profile> getProfileType() {
        return WoodcuttingProfile.class;
    }

    @Override
    public int getSkillTreeMenuOrderPriority() {
        return 25;
    }

    @Override
    public void addEXP(Player p, double amount, boolean silent, PlayerSkillExperienceGainEvent.ExperienceGainReason reason) {
        if (WorldGuardHook.inDisabledRegion(p.getLocation(), p, "vmmo-skill-woodcutting")) {
            return;
        }
        if (reason == PlayerSkillExperienceGainEvent.ExperienceGainReason.SKILL_ACTION) {
            amount *= 1.0 + AccumulativeStatManager.getCachedStats("WOODCUTTING_EXP_GAIN", (Entity)p, 10000L, true);
        }
        super.addEXP(p, amount, silent, reason);
    }

    public Map<Material, Double> getDropsExpValues() {
        return this.dropsExpValues;
    }
}

