/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.version.conversion_dto;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.version.conversion_dto.AlchemyProfile;
import me.athlaeos.valhallammo.version.conversion_dto.AlphaPDCAdapter;
import me.athlaeos.valhallammo.version.conversion_dto.ArcheryProfile;
import me.athlaeos.valhallammo.version.conversion_dto.DatabaseConnection;
import me.athlaeos.valhallammo.version.conversion_dto.EnchantingProfile;
import me.athlaeos.valhallammo.version.conversion_dto.FarmingProfile;
import me.athlaeos.valhallammo.version.conversion_dto.HeavyArmorProfile;
import me.athlaeos.valhallammo.version.conversion_dto.HeavyWeaponsProfile;
import me.athlaeos.valhallammo.version.conversion_dto.LandscapingProfile;
import me.athlaeos.valhallammo.version.conversion_dto.LightArmorProfile;
import me.athlaeos.valhallammo.version.conversion_dto.LightWeaponsProfile;
import me.athlaeos.valhallammo.version.conversion_dto.MiningProfile;
import me.athlaeos.valhallammo.version.conversion_dto.Profile;
import me.athlaeos.valhallammo.version.conversion_dto.SmithingProfile;
import org.bukkit.entity.Player;

public class AlphaDatabaseAdapter {
    private final DatabaseConnection conn;
    private final AlphaPDCAdapter altPersistency;
    private final Map<String, Profile> alphaProfileMappings = new HashMap<String, Profile>();
    private final Map<UUID, Map<String, Profile>> profiles;

    public AlphaDatabaseAdapter(DatabaseConnection conn, AlphaPDCAdapter altPersistency) {
        this.alphaProfileMappings.put("ALCHEMY", new AlchemyProfile(null));
        this.alphaProfileMappings.put("ARCHERY", new ArcheryProfile(null));
        this.alphaProfileMappings.put("ENCHANTING", new EnchantingProfile(null));
        this.alphaProfileMappings.put("FARMING", new FarmingProfile(null));
        this.alphaProfileMappings.put("HEAVYARMOR", new HeavyArmorProfile(null));
        this.alphaProfileMappings.put("HEAVYWEAPONS", new HeavyWeaponsProfile(null));
        this.alphaProfileMappings.put("LANDSCAPING", new LandscapingProfile(null));
        this.alphaProfileMappings.put("LIGHTARMOR", new LightArmorProfile(null));
        this.alphaProfileMappings.put("LIGHTWEAPONS", new LightWeaponsProfile(null));
        this.alphaProfileMappings.put("MINING", new MiningProfile(null));
        this.alphaProfileMappings.put("SMITHING", new SmithingProfile(null));
        this.profiles = new HashMap<UUID, Map<String, Profile>>();
        this.conn = conn;
        this.altPersistency = altPersistency;
    }

    public Profile getProfile(Player p, String type) {
        if (p == null) {
            return null;
        }
        if (this.conn == null || this.conn.getConnection() == null) {
            return this.altPersistency.getProfile(p, type);
        }
        try {
            Profile profile = this.alphaProfileMappings.get(type).fetchProfile(p, this.conn);
            if (profile == null) {
                profile = this.altPersistency.getProfile(p, type);
            }
            return profile;
        }
        catch (SQLException e) {
            ValhallaMMO.logSevere("SQLException when trying to fetch " + p.getName() + "'s profile for skill type " + type + ". ");
            e.printStackTrace();
            return null;
        }
    }
}

