/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.animations;

import java.util.HashMap;
import java.util.Map;
import me.athlaeos.valhallammo.animations.Animation;
import me.athlaeos.valhallammo.animations.implementations.BlockBubbles;
import me.athlaeos.valhallammo.animations.implementations.BlockParticlePuff;
import me.athlaeos.valhallammo.animations.implementations.BlockSparksCraftSound;
import me.athlaeos.valhallammo.animations.implementations.BlockSparksExtinguishSound;
import me.athlaeos.valhallammo.animations.implementations.ChargedShotActivation;
import me.athlaeos.valhallammo.animations.implementations.ChargedShotAmmo;
import me.athlaeos.valhallammo.animations.implementations.ChargedShotFire;
import me.athlaeos.valhallammo.animations.implementations.ChargedShotSonicBoom;
import me.athlaeos.valhallammo.animations.implementations.DrillingActive;
import me.athlaeos.valhallammo.animations.implementations.ElementalBladeActivation;
import me.athlaeos.valhallammo.animations.implementations.ElementalBladeExpiration;
import me.athlaeos.valhallammo.animations.implementations.EntityFlash;
import me.athlaeos.valhallammo.animations.implementations.EntitySparkFlash;
import me.athlaeos.valhallammo.animations.implementations.HitElectric;
import me.athlaeos.valhallammo.animations.implementations.HitExplosionBurst;
import me.athlaeos.valhallammo.animations.implementations.HitFireFlame;
import me.athlaeos.valhallammo.animations.implementations.HitFreezingPuff;
import me.athlaeos.valhallammo.animations.implementations.HitMagicPuff;
import me.athlaeos.valhallammo.animations.implementations.HitNecroticPuff;
import me.athlaeos.valhallammo.animations.implementations.HitPoisonPuff;
import me.athlaeos.valhallammo.animations.implementations.HitRadiantFlash;
import me.athlaeos.valhallammo.animations.implementations.MultiJump;

public class AnimationRegistry {
    public static Animation BLOCK_PARTICLE_PUFF = new BlockParticlePuff("block_particle_puff");
    public static Animation BLOCK_SPARKS_CRAFTSOUND = new BlockSparksCraftSound("block_sparks_craftsound");
    public static Animation BLOCK_BUBBLES = new BlockBubbles("block_bubbles");
    public static Animation BLOCK_SPARKS_EXTINGUISH = new BlockSparksExtinguishSound("block_sparks_extinguish");
    public static Animation ENTITY_SPARK_FLASH = new EntitySparkFlash("entity_spark_flash");
    public static Animation ENTITY_FLASH = new EntityFlash("entity_flash");
    public static Animation HIT_ELECTRIC = new HitElectric("hit_electric");
    public static Animation HIT_EXPLOSION = new HitExplosionBurst("hit_explosion");
    public static Animation HIT_FIRE = new HitFireFlame("hit_fire");
    public static Animation HIT_FREEZING = new HitFreezingPuff("hit_freezing");
    public static Animation HIT_MAGIC = new HitMagicPuff("hit_magic");
    public static Animation HIT_NECROTIC = new HitNecroticPuff("hit_necrotic");
    public static Animation HIT_POISON = new HitPoisonPuff("hit_poison");
    public static Animation HIT_RADIANT = new HitRadiantFlash("hit_radiant");
    public static Animation CHARGED_SHOT_ACTIVATION = new ChargedShotActivation("charged_shot_activation");
    public static Animation CHARGED_SHOT_AMMO = new ChargedShotAmmo("charged_shot_ammo");
    public static Animation CHARGED_SHOT_FIRE = new ChargedShotFire("charged_shot_fire");
    public static Animation CHARGED_SHOT_SONIC_BOOM = new ChargedShotSonicBoom("charged_shot_sonic_boom");
    public static Animation DRILLING_ACTIVE = new DrillingActive("drilling_active");
    public static Animation MULTI_JUMP = new MultiJump("multi_jump");
    public static Animation ELEMENTAL_BLADE_ACTIVATION = new ElementalBladeActivation("elemental_blade_activation");
    public static Animation ELEMENTAL_BLADE_EXPIRATION = new ElementalBladeExpiration("elemental_blade_expiration");
    private static final Map<String, Animation> animationRegistry = new HashMap<String, Animation>();

    public static void register(Animation animation) {
        animationRegistry.put(animation.id(), animation);
    }

    public static Animation getAnimation(String id) {
        return animationRegistry.get(id);
    }

    static {
        AnimationRegistry.register(BLOCK_PARTICLE_PUFF);
        AnimationRegistry.register(BLOCK_SPARKS_CRAFTSOUND);
        AnimationRegistry.register(BLOCK_BUBBLES);
        AnimationRegistry.register(BLOCK_SPARKS_EXTINGUISH);
        AnimationRegistry.register(ENTITY_SPARK_FLASH);
        AnimationRegistry.register(ENTITY_FLASH);
        AnimationRegistry.register(HIT_ELECTRIC);
        AnimationRegistry.register(HIT_EXPLOSION);
        AnimationRegistry.register(HIT_FIRE);
        AnimationRegistry.register(HIT_FREEZING);
        AnimationRegistry.register(HIT_MAGIC);
        AnimationRegistry.register(HIT_NECROTIC);
        AnimationRegistry.register(HIT_POISON);
        AnimationRegistry.register(HIT_RADIANT);
        AnimationRegistry.register(CHARGED_SHOT_ACTIVATION);
        AnimationRegistry.register(CHARGED_SHOT_AMMO);
        AnimationRegistry.register(CHARGED_SHOT_FIRE);
        AnimationRegistry.register(CHARGED_SHOT_SONIC_BOOM);
        AnimationRegistry.register(DRILLING_ACTIVE);
        AnimationRegistry.register(MULTI_JUMP);
        AnimationRegistry.register(ELEMENTAL_BLADE_ACTIVATION);
        AnimationRegistry.register(ELEMENTAL_BLADE_EXPIRATION);
    }
}

