/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.block;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.dom.MinecraftVersion;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.item.MiningSpeed;
import me.athlaeos.valhallammo.listeners.CustomBreakSpeedListener;
import me.athlaeos.valhallammo.playerstats.AccumulativeStatManager;
import me.athlaeos.valhallammo.playerstats.EntityCache;
import me.athlaeos.valhallammo.playerstats.EntityProperties;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileCache;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.MiningProfile;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.PowerProfile;
import me.athlaeos.valhallammo.utility.BlockUtils;
import me.athlaeos.valhallammo.utility.EntityUtils;
import me.athlaeos.valhallammo.utility.MathUtils;
import me.athlaeos.valhallammo.version.AttributeMappings;
import me.athlaeos.valhallammo.version.EnchantmentMappings;
import me.athlaeos.valhallammo.version.PotionEffectMappings;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class DigPacketInfo {
    private final Player digger;
    private final Location l;
    private final Type type;
    private static final Map<UUID, BlockCache> blockSpecificSpeedCache = new HashMap<UUID, BlockCache>();
    private static final Map<UUID, Float> cachedMultiplier = new HashMap<UUID, Float>();
    private static final Collection<UUID> cachedSwimmingMiners = new HashSet<UUID>();
    private static final Collection<UUID> cachedAirMiners = new HashSet<UUID>();

    public DigPacketInfo(Player digger, int x, int y, int z, Type type) {
        this.digger = digger;
        this.l = new Location(digger.getWorld(), (double)x, (double)y, (double)z);
        this.type = type;
    }

    public Location getLocation() {
        return this.l;
    }

    public Player getDigger() {
        return this.digger;
    }

    public Type getType() {
        return this.type;
    }

    public int id() {
        return (this.l.getBlockX() & 0xFFF) << 20 | (this.l.getBlockZ() & 0xFFF) << 8 | this.l.getBlockY() & 0xFF;
    }

    public Block getBlock() {
        return this.l.getBlock();
    }

    public boolean finished() {
        return this.type == Type.ABORT || this.type == Type.STOP;
    }

    public static void resetMinerCache(UUID uuid) {
        cachedMultiplier.remove(uuid);
        cachedSwimmingMiners.remove(uuid);
        cachedAirMiners.remove(uuid);
        blockSpecificSpeedCache.remove(uuid);
    }

    public static void resetBlockSpecificCache(UUID uuid) {
        blockSpecificSpeedCache.remove(uuid);
    }

    public static float damage(Player digger, Block b) {
        Map<Object, Object> hardnessTranslations;
        float hardness;
        ItemBuilder optimalTool;
        MiningProfile profile;
        if (digger == null || b == null || b.getType().isAir()) {
            return 0.0f;
        }
        ItemBuilder tool = EntityCache.getAndCacheProperties((LivingEntity)digger).getMainHand();
        if (tool == null && (profile = ProfileCache.getOrCache(digger, MiningProfile.class)).getEmptyHandTool() != null && ValhallaMMO.getNms().toolPower(profile.getEmptyHandTool().getItem(), b) > 1.0f) {
            tool = profile.getEmptyHandTool();
        }
        if (tool != null && !tool.getEmbeddedTools().isEmpty() && (optimalTool = MiningSpeed.getOptimalEmbeddedTool(tool.getEmbeddedTools(), tool.getMeta(), b)) != null) {
            tool = optimalTool;
        }
        float f = hardness = tool == null ? BlockUtils.getHardness(b) : MiningSpeed.getHardness(tool.getMeta(), b);
        if (hardness < 0.0f || hardness > 100000.0f) {
            return 0.0f;
        }
        EntityProperties properties = EntityCache.getAndCacheProperties((LivingEntity)digger);
        Map<Object, Object> map = hardnessTranslations = tool == null ? new HashMap() : MiningSpeed.getHardnessTranslations(tool.getMeta());
        float toolStrength = !hardnessTranslations.isEmpty() && hardnessTranslations.containsKey(b.getType()) ? ValhallaMMO.getNms().toolPower(tool.getItem(), (Material)hardnessTranslations.get(b.getType())) : ValhallaMMO.getNms().toolPower(tool == null ? null : tool.getItem(), b);
        boolean canHarvest = BlockUtils.hasDrops(b, (Entity)digger, tool == null ? null : tool.getItem());
        float baseMultiplier = 1.0f;
        if (toolStrength > 1.0f) {
            int efficiency;
            baseMultiplier = tool == null ? 1.0f : (float)MiningSpeed.getMultiplier(tool.getMeta(), b.getType());
            int n = efficiency = tool == null ? 0 : tool.getItem().getEnchantmentLevel(EnchantmentMappings.EFFICIENCY.getEnchantment());
            if (efficiency > 0) {
                baseMultiplier += (float)(MathUtils.pow(efficiency, 2.0) + 1.0);
            }
        }
        boolean canSwimMine = cachedSwimmingMiners.contains(digger.getUniqueId());
        boolean canAirMine = cachedAirMiners.contains(digger.getUniqueId());
        float additionalMultiplier = 1.0f;
        if (cachedMultiplier.containsKey(digger.getUniqueId())) {
            additionalMultiplier = cachedMultiplier.get(digger.getUniqueId()).floatValue();
        } else {
            Attribute miningSpeed;
            PotionEffect fatigue;
            additionalMultiplier += (float)AccumulativeStatManager.getCachedStats("DIG_SPEED", (Entity)digger, 10000L, true);
            PotionEffect haste = digger.getPotionEffect(PotionEffectMappings.HASTE.getPotionEffectType());
            if (haste != null) {
                additionalMultiplier += 0.2f * (float)haste.getAmplifier();
            }
            if ((fatigue = digger.getPotionEffect(PotionEffectMappings.MINING_FATIGUE.getPotionEffectType())) != null && fatigue.getAmplifier() > (MinecraftVersion.currentVersionNewerThan(MinecraftVersion.MINECRAFT_1_20_5) ? -1 : 0) && fatigue.getAmplifier() < 5) {
                additionalMultiplier *= (float)MathUtils.pow(0.3, Math.min(fatigue.getAmplifier() + 1, 4));
            }
            PowerProfile profile2 = ProfileCache.getOrCache(digger, PowerProfile.class);
            canSwimMine = properties.getCombinedEnchantments().getOrDefault(EnchantmentMappings.AQUA_AFFINITY.getEnchantment(), 0) > 0 || digger.hasPotionEffect(PotionEffectType.CONDUIT_POWER) || profile2.hasAquaAffinity();
            cachedMultiplier.put(digger.getUniqueId(), Float.valueOf(additionalMultiplier));
            if (canSwimMine) {
                cachedSwimmingMiners.add(digger.getUniqueId());
            }
            if (profile2.hasAerialAffinity()) {
                cachedAirMiners.add(digger.getUniqueId());
            }
            if ((miningSpeed = AttributeMappings.BLOCK_BREAK_SPEED.getAttribute()) != null && CustomBreakSpeedListener.isFatigued(digger)) {
                additionalMultiplier *= (float)(-EntityUtils.getUniqueAttributeValue((LivingEntity)digger, CustomBreakSpeedListener.FATIGUE_MODIFIER_UUID, "valhalla_mining_speed_nullifier", miningSpeed));
            }
        }
        baseMultiplier *= additionalMultiplier;
        BlockCache cachedBlockBonus = blockSpecificSpeedCache.get(digger.getUniqueId());
        if (cachedBlockBonus == null || !DigPacketInfo.sameLocation(b, cachedBlockBonus.block)) {
            cachedBlockBonus = new BlockCache(b, 1.0 + AccumulativeStatManager.getStats("BLOCK_SPECIFIC_DIG_SPEED", (Entity)digger, true));
            blockSpecificSpeedCache.put(digger.getUniqueId(), cachedBlockBonus);
        }
        baseMultiplier *= (float)cachedBlockBonus.value;
        if (DigPacketInfo.isInWater(digger) && !canSwimMine) {
            baseMultiplier /= 5.0f;
        }
        if (!EntityUtils.isOnGround((Entity)digger) && !canAirMine) {
            baseMultiplier /= 5.0f;
        }
        float damage = baseMultiplier / hardness;
        damage = canHarvest ? (damage /= 30.0f) : (damage /= 100.0f);
        return Math.max(0.0f, damage);
    }

    private static boolean isInWater(Player p) {
        return p.getEyeLocation().getBlock().getType() == Material.WATER || p.getEyeLocation().getBlock().getType() == Material.LAVA;
    }

    public static Type fromName(String name) {
        return switch (name.toUpperCase(Locale.US)) {
            case "START_DESTROY_BLOCK" -> Type.START;
            case "STOP_DESTROY_BLOCK" -> Type.STOP;
            case "ABORT_DESTROY_BLOCK" -> Type.ABORT;
            default -> Type.INVALID;
        };
    }

    private static boolean sameLocation(Block b1, Block b2) {
        return b1.getWorld().getName().equals(b2.getWorld().getName()) && b1.getX() == b2.getX() && b1.getY() == b2.getY() && b1.getZ() == b2.getZ();
    }

    public static enum Type {
        START,
        STOP,
        ABORT,
        INVALID;

    }

    private record BlockCache(Block block, double value) {
    }
}

