/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.crafting.blockvalidations.implementations;

import java.util.Collection;
import java.util.Set;
import me.athlaeos.valhallammo.crafting.blockvalidations.Validation;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.StringUtils;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.inventory.ItemStack;

public class BlockSurroundedTiered
extends Validation {
    private final Material icon;
    private final Collection<Material> betterMaterials;
    private final int amountRequired;
    private final String errorMessage;

    public BlockSurroundedTiered(int amountRequired, String errorMessage, Material ... blockRequired) {
        this.icon = blockRequired[0];
        this.betterMaterials = Set.of(blockRequired);
        this.amountRequired = amountRequired;
        this.errorMessage = errorMessage;
    }

    @Override
    public String id() {
        return "BLOCK_SURROUNDED_BY_" + String.valueOf(this.icon) + "_OR_BETTER";
    }

    @Override
    public ItemStack icon() {
        String name = StringUtils.toPascalCase(this.icon.toString().replace("_", " "));
        return new ItemBuilder(this.icon).name("&eSurrounded by " + name + " or better").lore("&fRequires the block to be", "&fsurrounded by " + this.amountRequired + " " + name).get();
    }

    @Override
    public String activeDescription() {
        String name = StringUtils.toPascalCase(this.icon.toString().replace("_", " "));
        return "&fMust be surrounded by " + this.amountRequired + " " + name + " or better";
    }

    @Override
    public String validationError() {
        return this.errorMessage;
    }

    @Override
    public boolean isCompatible(String block) {
        return true;
    }

    @Override
    public boolean validate(Block b) {
        int found = 0;
        for (int x = b.getX() - 1; x <= b.getX() + 1; ++x) {
            for (int y = b.getY() - 1; y <= b.getY() + 1; ++y) {
                for (int z = b.getZ() - 1; z <= b.getZ() + 1; ++z) {
                    Block block = b.getWorld().getBlockAt(x, y, z);
                    if (this.betterMaterials.stream().anyMatch(m -> ItemUtils.isSimilarMaterial(m, block.getType()))) {
                        ++found;
                    }
                    if (found < this.amountRequired) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void execute(Block b) {
    }
}

