/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.crafting.dynamicitemmodifiers;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierContext;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierPriority;
import me.athlaeos.valhallammo.event.ItemModificationEvent;
import me.athlaeos.valhallammo.gui.implementations.DynamicModifierMenu;
import me.athlaeos.valhallammo.item.CustomFlag;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.StringUtils;
import me.athlaeos.valhallammo.utility.Utils;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public abstract class DynamicItemModifier {
    public static final NamespacedKey ERROR_MESSAGE = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "contained_error_message");
    private final String name;
    private ModifierPriority priority = ModifierPriority.NEUTRAL;

    public DynamicItemModifier(String name) {
        this.name = name;
    }

    public abstract ItemStack getModifierIcon();

    public abstract String getDisplayName();

    public abstract String getDescription();

    public abstract String getActiveDescription();

    public abstract Collection<String> getCategories();

    public abstract DynamicItemModifier copy();

    public abstract String parseCommand(CommandSender var1, String[] var2);

    public abstract List<String> commandSuggestions(CommandSender var1, int var2);

    public abstract int commandArgsRequired();

    public abstract Map<Integer, ItemStack> getButtons();

    public abstract void onButtonPress(InventoryClickEvent var1, int var2);

    public void onButtonPress(InventoryClickEvent e, DynamicModifierMenu menu, int button) {
        this.onButtonPress(e, button);
    }

    public ModifierPriority getPriority() {
        return this.priority;
    }

    public void setPriority(ModifierPriority priority) {
        this.priority = priority;
    }

    public String getName() {
        return this.name;
    }

    public abstract void processItem(ModifierContext var1);

    public void failedRecipe(ItemBuilder i, String message) {
        if (message == null) {
            message = "";
        }
        i.flag(CustomFlag.UNCRAFTABLE).stringTag(ERROR_MESSAGE, message).lore(StringUtils.separateStringIntoLines(message, 40));
    }

    public boolean requiresPlayer() {
        return false;
    }

    public static void modify(ModifierContext context, List<DynamicItemModifier> modifiers) {
        ItemModificationEvent event = new ItemModificationEvent(context, modifiers);
        if (Bukkit.isPrimaryThread()) {
            ValhallaMMO.getInstance().getServer().getPluginManager().callEvent((Event)event);
        }
        if (event.getContext().shouldSort()) {
            DynamicItemModifier.sortModifiers(event.getModifiers());
        }
        block0: for (DynamicItemModifier modifier : event.getModifiers()) {
            if (!modifier.meetsRequirement(context)) {
                if (context.getCrafter() != null) {
                    Utils.sendMessage((CommandSender)context.getCrafter(), "&cWhatever you just created was improperly configured. Please notify admin. Modifier " + modifier.getClass().getSimpleName() + " was used which doesn't function in this context");
                }
                context.getItem().flag(CustomFlag.UNCRAFTABLE);
                return;
            }
            if (!modifier.meetsPlayerRequirement(context)) {
                context.getItem().flag(CustomFlag.UNCRAFTABLE);
                return;
            }
            modifier.processItem(context);
            if (ItemUtils.isEmpty(context.getItem().getItem()) || CustomFlag.hasFlag(context.getItem().getMeta(), CustomFlag.UNCRAFTABLE)) break;
            for (ItemBuilder otherItem : context.getOtherInvolvedItems()) {
                if (!ItemUtils.isEmpty(otherItem.getItem()) && !CustomFlag.hasFlag(otherItem.getMeta(), CustomFlag.UNCRAFTABLE)) continue;
                break block0;
            }
        }
        context.getItem().translate();
        for (ItemBuilder otherItem : context.getOtherInvolvedItems()) {
            otherItem.translate();
        }
    }

    public final boolean meetsPlayerRequirement(ModifierContext context) {
        return !this.requiresPlayer() || context.getCrafter() != null;
    }

    public boolean meetsRequirement(ModifierContext context) {
        return true;
    }

    public static void sortModifiers(List<DynamicItemModifier> modifiers) {
        modifiers.sort(Comparator.comparingInt(a -> a.getPriority().getPriorityRating()));
    }

    public static boolean requiresPlayer(Collection<DynamicItemModifier> modifiers) {
        for (DynamicItemModifier modifier : modifiers) {
            if (!modifier.requiresPlayer()) continue;
            return true;
        }
        return false;
    }
}

