/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.implementations.food;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.DynamicItemModifier;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierCategoryRegistry;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierContext;
import me.athlaeos.valhallammo.dom.Pair;
import me.athlaeos.valhallammo.item.FoodClass;
import me.athlaeos.valhallammo.item.FoodPropertyManager;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.utility.Utils;
import me.athlaeos.valhallammo.version.ConventionUtils;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class FoodClassSet
extends DynamicItemModifier {
    private FoodClass foodClass = FoodClass.MEAT;

    public FoodClassSet(String name) {
        super(name);
    }

    @Override
    public void processItem(ModifierContext context) {
        FoodPropertyManager.setFoodClass(context.getItem().getMeta(), this.foodClass);
    }

    @Override
    public void onButtonPress(InventoryClickEvent e, int button) {
        if (button == 12) {
            int currentRequirement = Arrays.asList(FoodClass.values()).indexOf((Object)this.foodClass);
            currentRequirement = e.isLeftClick() ? (currentRequirement + 1 >= FoodClass.values().length ? 0 : ++currentRequirement) : (currentRequirement - 1 < 0 ? FoodClass.values().length - 1 : --currentRequirement);
            this.foodClass = FoodClass.values()[currentRequirement];
        }
    }

    @Override
    public Map<Integer, ItemStack> getButtons() {
        Integer n = 12;
        return new Pair<Integer, ItemStack>(n, new ItemBuilder(switch (this.foodClass) {
            default -> throw new IncompatibleClassChangeError();
            case FoodClass.FATS -> Material.WHITE_DYE;
            case FoodClass.MEAT -> Material.BEEF;
            case FoodClass.NUTS -> Material.COCOA_BEANS;
            case FoodClass.DAIRY -> Material.MILK_BUCKET;
            case FoodClass.FRUIT -> Material.APPLE;
            case FoodClass.GRAIN -> Material.WHEAT;
            case FoodClass.SWEET -> Material.HONEY_BOTTLE;
            case FoodClass.MAGICAL -> Material.ENCHANTED_GOLDEN_APPLE;
            case FoodClass.SEAFOOD -> Material.COD;
            case FoodClass.SPOILED -> Material.ROTTEN_FLESH;
            case FoodClass.BEVERAGE -> Material.WATER_BUCKET;
            case FoodClass.ALCOHOLIC -> Material.POTION;
            case FoodClass.SEASONING -> Material.SUGAR;
            case FoodClass.VEGETABLE -> Material.CARROT;
        }).name("&eWhich food class should it be?").lore("&fFood class set to &e" + String.valueOf((Object)this.foodClass), "&fAffects the type of food the item ", "&fis considered by the plugin, which", "&faffects diminishing returns mechanics", "&fand food category multipliers.", "&6Click to cycle").flag(ConventionUtils.getHidePotionEffectsFlag()).color(Utils.hexToRgb("#5E2C04")).get()).map(new HashSet());
    }

    @Override
    public ItemStack getModifierIcon() {
        return new ItemBuilder(Material.PAPER).get();
    }

    @Override
    public String getDisplayName() {
        return "&bFood Class";
    }

    @Override
    public String getDescription() {
        return "&fChanges the food class of an item.";
    }

    @Override
    public String getActiveDescription() {
        return "&fFood class set to &e" + String.valueOf((Object)this.foodClass);
    }

    @Override
    public Collection<String> getCategories() {
        return Set.of(ModifierCategoryRegistry.FOOD.id());
    }

    public void setFoodClass(FoodClass foodClass) {
        this.foodClass = foodClass;
    }

    @Override
    public DynamicItemModifier copy() {
        FoodClassSet m = new FoodClassSet(this.getName());
        m.setFoodClass(this.foodClass);
        m.setPriority(this.getPriority());
        return m;
    }

    @Override
    public String parseCommand(CommandSender executor, String[] args) {
        if (args.length != 1) {
            return "You must indicate the food class to set the item to";
        }
        try {
            this.foodClass = FoodClass.valueOf(args[0]);
        }
        catch (IllegalArgumentException ignored) {
            return "Invalid equipment class";
        }
        return null;
    }

    @Override
    public List<String> commandSuggestions(CommandSender executor, int currentArg) {
        if (currentArg == 0) {
            return Arrays.stream(FoodClass.values()).map(Enum::toString).toList();
        }
        return null;
    }

    @Override
    public int commandArgsRequired() {
        return 1;
    }
}

