/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.crafting.ingredientconfiguration.implementations;

import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.RecipeOption;
import me.athlaeos.valhallammo.hooks.IAHook;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.utility.ItemUtils;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class IAChoice
extends RecipeOption {
    @Override
    public String getName() {
        return "CHOICE_ITEMSADDER_ITEM";
    }

    @Override
    public String getActiveDescription() {
        return "This ingredient will need to match a specific ItemsAdder item";
    }

    @Override
    public ItemStack getIcon() {
        return new ItemBuilder(Material.KNOWLEDGE_BOOK).name("&7ItemsAdder Item Requirement").lore("&aRequire this ingredient to be a specific", "&aItemsAdder item, identified by its ItemsAdder ID.", "", "&7The name of the ingredient will be", "&7used to communicate item requirement", "&7to the player.").get();
    }

    @Override
    public boolean isCompatible(ItemStack i) {
        if (!ValhallaMMO.isHookFunctional(IAHook.class)) {
            return false;
        }
        return IAHook.getItemsAdderItemID(i) != null;
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public RecipeChoice getChoice(final ItemStack i) {
        return new RecipeChoice.ExactChoice(this, i){
            final /* synthetic */ IAChoice this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            public boolean test(@NotNull ItemStack itemStack) {
                if (!ValhallaMMO.isHookFunctional(IAHook.class)) {
                    return false;
                }
                String referenceItemsAdderId = IAHook.getItemsAdderItemID(i);
                if (referenceItemsAdderId == null) {
                    return false;
                }
                String testedItemsAdderId = IAHook.getItemsAdderItemID(itemStack);
                return referenceItemsAdderId.equals(testedItemsAdderId);
            }
        };
    }

    @Override
    public boolean matches(ItemStack i1, ItemStack i2) {
        if (!ValhallaMMO.isHookFunctional(IAHook.class)) {
            return false;
        }
        String itemsAdderId1 = IAHook.getItemsAdderItemID(i1);
        String itemsAdderId2 = IAHook.getItemsAdderItemID(i2);
        if (itemsAdderId1 == null && itemsAdderId2 == null) {
            return false;
        }
        if (itemsAdderId1 == null || itemsAdderId2 == null) {
            return false;
        }
        return itemsAdderId1.equals(itemsAdderId2);
    }

    @Override
    public String ingredientDescription(ItemStack base) {
        if (!ValhallaMMO.isHookFunctional(IAHook.class)) {
            return ItemUtils.getItemName(new ItemBuilder(base));
        }
        ItemMeta meta = base.getItemMeta();
        if (meta != null && meta.hasDisplayName()) {
            return meta.getDisplayName();
        }
        String itemsAdderId = IAHook.getItemsAdderItemID(base);
        if (itemsAdderId != null) {
            return "ItemsAdder Item: " + itemsAdderId;
        }
        return ItemUtils.getItemName(new ItemBuilder(base));
    }

    @Override
    public RecipeOption getNew() {
        return new IAChoice();
    }

    @Override
    public boolean isCompatibleWithInputItem(boolean isInput) {
        return true;
    }
}

