/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.dom;

import java.util.function.Predicate;
import me.athlaeos.valhallammo.utility.Utils;
import org.bukkit.entity.Player;

public class Question {
    private final String question;
    private String answer;
    private final Predicate<String> validator;
    private final String onInvalidAnswer;

    public Question(String question, Predicate<String> validator, String onInvalidAnswer) {
        this.question = question;
        this.validator = validator;
        this.onInvalidAnswer = onInvalidAnswer;
    }

    public String getQuestion() {
        return this.question;
    }

    public String getAnswer() {
        return this.answer;
    }

    public void ask(Player who) {
        who.sendMessage(Utils.chat(this.question));
    }

    public void answer(Player who, String answer) {
        if (this.validator != null && !this.validator.test(answer)) {
            who.sendMessage(Utils.chat(this.onInvalidAnswer));
        } else {
            this.answer = answer;
        }
    }

    public Predicate<String> getValidator() {
        return this.validator;
    }

    public String getOnInvalidAnswer() {
        return this.onInvalidAnswer;
    }
}

