/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.dom;

import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.configuration.ConfigManager;
import me.athlaeos.valhallammo.utility.Utils;
import org.bukkit.configuration.file.YamlConfiguration;

public class Scaling {
    private Double lowerBound;
    private Double upperBound;
    private final ScalingMode scalingType;
    private final String expression;

    public Scaling(String expression, ScalingMode applicationType, Double lowerBound, Double upperBound) {
        this.expression = expression;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        if (lowerBound != null && upperBound != null) {
            this.lowerBound = Math.min(upperBound, lowerBound);
            this.upperBound = Math.max(upperBound, lowerBound);
        }
        this.scalingType = applicationType;
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    public double getUpperBound() {
        return this.upperBound;
    }

    public ScalingMode getScalingType() {
        return this.scalingType;
    }

    public String getExpression() {
        return this.expression;
    }

    public double evaluate(String expression) {
        double result = Utils.eval(expression);
        if (this.lowerBound != null) {
            result = Math.max(this.lowerBound, result);
        }
        if (this.upperBound != null) {
            result = Math.min(this.upperBound, result);
        }
        return result;
    }

    public double evaluate(String expression, double applyOn) {
        double d;
        double result = Utils.eval(expression);
        if (this.lowerBound != null) {
            result = Math.max(this.lowerBound, result);
        }
        if (this.upperBound != null) {
            result = Math.min(this.upperBound, result);
        }
        if (this.scalingType == null) {
            d = result;
        } else {
            switch (this.scalingType.ordinal()) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case 0: {
                    d = applyOn * result;
                    break;
                }
                case 1: {
                    d = applyOn + result;
                }
            }
        }
        return d;
    }

    public static Scaling fromConfig(String config, String path) {
        YamlConfiguration c = ConfigManager.getConfig(config).get();
        String value = c.getString(path);
        String def = null;
        c = ConfigManager.getDefault(config);
        if (c != null) {
            def = c.getString(path);
        }
        if (value == null) {
            return null;
        }
        try {
            return Scaling.fromString(value, def);
        }
        catch (IllegalArgumentException e) {
            ValhallaMMO.logWarning("At " + config + ":" + path + ", " + e.getMessage());
            return null;
        }
    }

    public static Scaling fromString(String value, String def) throws IllegalArgumentException {
        Double upper;
        Double lower;
        ScalingMode mode;
        if (value == null) {
            value = def;
        }
        if (value == null) {
            return null;
        }
        String[] args = value.split(",");
        if (args.length != 4) {
            throw new IllegalArgumentException("Scaling needs 4 arguments separated by comma, " + args.length + " were found. Valid format: 'EXPRESSION,MODE,LOWERBOUND,UPPERBOUND'");
        }
        try {
            mode = ScalingMode.valueOf(args[1]);
        }
        catch (IllegalArgumentException ignored) {
            throw new IllegalArgumentException("Unrecognized ScalingMode " + args[1] + " used. Valid formats are 'MULTIPLIER', 'ADD_ON_DEFAULT'");
        }
        try {
            lower = Double.valueOf(args[2]);
        }
        catch (NumberFormatException ignored) {
            lower = null;
        }
        try {
            upper = Double.valueOf(args[3]);
        }
        catch (NumberFormatException ignored) {
            upper = null;
        }
        return new Scaling(args[0], mode, lower, upper);
    }

    public static enum ScalingMode {
        MULTIPLIER,
        ADD_ON_DEFAULT;

    }
}

