/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.gui.implementations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.crafting.CustomRecipeRegistry;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.DynamicItemModifier;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.IngredientChoice;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.RecipeOption;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.SlotEntry;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.implementations.MaterialChoice;
import me.athlaeos.valhallammo.crafting.recipetypes.DynamicBrewingRecipe;
import me.athlaeos.valhallammo.dom.Action;
import me.athlaeos.valhallammo.dom.Question;
import me.athlaeos.valhallammo.dom.Questionnaire;
import me.athlaeos.valhallammo.gui.Menu;
import me.athlaeos.valhallammo.gui.PlayerMenuUtility;
import me.athlaeos.valhallammo.gui.SetModifiersMenu;
import me.athlaeos.valhallammo.gui.SetRecipeOptionMenu;
import me.athlaeos.valhallammo.gui.implementations.DynamicModifierMenu;
import me.athlaeos.valhallammo.gui.implementations.RecipeOptionMenu;
import me.athlaeos.valhallammo.gui.implementations.RecipeOverviewMenu;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.StringUtils;
import me.athlaeos.valhallammo.utility.Utils;
import me.athlaeos.valhallammo.version.EnchantmentMappings;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.DragType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;

public class BrewingRecipeEditor
extends Menu
implements SetModifiersMenu,
SetRecipeOptionMenu {
    private static final NamespacedKey BUTTON_ACTION_KEY = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "button_action");
    private static final int ingredientIndex = 12;
    private static final Collection<Integer> applyOnIndexes = Set.of(Integer.valueOf(28), Integer.valueOf(30), Integer.valueOf(32));
    private static final int resultIndex = 24;
    private static final ItemStack filler = new ItemBuilder(Material.GRAY_STAINED_GLASS_PANE).name("&r").get();
    private final DynamicBrewingRecipe recipe;
    private RecipeOption selectedChoice = null;
    private SlotEntry ingredient;
    private SlotEntry applyOn;
    private ItemStack result;
    private boolean requireValhallaTools;
    private boolean tinker;
    private boolean consumeIngredient;
    private List<DynamicItemModifier> modifiers;
    private boolean unlockedForEveryone;
    private int brewTime;
    private String displayName;
    private String description;
    private static final ItemStack toggleValhallaToolRequirementButton = new ItemBuilder(BrewingRecipeEditor.getButtonData("editor_recipe_brewing_valhallatoolrequirement", Material.DIAMOND_PICKAXE)).name("&eValhalla Tools").stringTag(BUTTON_ACTION_KEY, "toggleValhallaToolRequirementButton").lore("&7If enabled, the armors or tools", "&7in the recipe need to have ValhallaMMO ", "&7custom attributes. If disabled, vanilla ", "&7equipment can be used too.", "&eClick to toggle on/off").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack toggleTinkerButton = new ItemBuilder(BrewingRecipeEditor.getButtonData("editor_recipe_brewing_toggletinker", Material.ANVIL)).name("&eTinker Tools").stringTag(BUTTON_ACTION_KEY, "toggleTinkerButton").lore("&7If enabled, the recipe will", "&7improve the input item of the recipe.", "&7Otherwise, it will simply produce the", "&7item specified as the result.", "&eClick to toggle on/off").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack toggleConsumeIngredientButton = new ItemBuilder(BrewingRecipeEditor.getButtonData("editor_recipe_brewing_toggleconsumeingredient", Material.GOLDEN_APPLE)).name("&eConsume Ingredient").stringTag(BUTTON_ACTION_KEY, "toggleConsumeIngredientButton").lore("&7If enabled, the recipe will", "&7consume 1 of the ingredient item like usual.", "&7Otherwise, the ingredient will be left", "&7in the brewing stand GUI.", "&eClick to toggle on/off").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack modifierButton = new ItemBuilder(BrewingRecipeEditor.getButtonData("editor_recipe_brewing_modifiers", Material.WRITABLE_BOOK)).name("&dItem Modifiers").stringTag(BUTTON_ACTION_KEY, "modifierButton").lore("&7Modifiers are usually functions to edit", "&7the output item based on player", "&7stats or to apply crafting conditions.", "&aThese modifiers specifically run on", "&athe addition item if 'consume addition'", "&ais disabled.", "&eClick to open the menu", "&8&m                <>                ", "%modifiers%").get();
    private static final ItemStack brewTimeButton = new ItemBuilder(BrewingRecipeEditor.getButtonData("editor_recipe_brewing_brewtime", Material.CLOCK)).name("&eBrewing Time").stringTag(BUTTON_ACTION_KEY, "brewTimeButton").lore("&7How long it takes to brew this recipe.", "&7Typical brewing time: &a400 ticks", "&eClick to increase/decrease by 1 tick", "&eShift-click to increase/decrease by 20 ticks").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack recipeOptionsButton = new ItemBuilder(BrewingRecipeEditor.getButtonData("editor_recipe_brewing_recipeoptions", Material.WRITABLE_BOOK)).name("&bIngredient Options").stringTag(BUTTON_ACTION_KEY, "recipeOptionsButton").lore("&7Ingredient options are ingredient", "&7flags you can put on an ingredient or", "&7input to change its behavior during", "&7brewing.", "&eClick to open the menu").get();
    private static final ItemStack toggleUnlockedForEveryoneButton = new ItemBuilder(BrewingRecipeEditor.getButtonData("editor_recipe_brewing_unlockedforeveryone", Material.PAPER)).name("&eUnlocked for Everyone").stringTag(BUTTON_ACTION_KEY, "toggleUnlockedForEveryoneButton").lore("&7If enabled, the recipe will", "&7available to everyone regardless", "&7if unlocked or not. Otherwise it", "&7will have to be unlocked through", "&7perk rewards.", "&eClick to toggle on/off").get();
    private static final ItemStack setDisplayNameButton = new ItemBuilder(BrewingRecipeEditor.getButtonData("editor_recipe_brewing_setdisplayname", Material.NAME_TAG)).name("&aSet Display Name").stringTag(BUTTON_ACTION_KEY, "setDisplayNameButton").lore("&7Sets the display name of the recipe.", "&7The display name is visible in the", "&7recipe book and is usually used", "&7to roughly describe the purpose of", "&7tinkering recipes since the output is", "&7non-descriptive.", "&eLeft-Click to set display name", "&cRight-Click to nullify display name", "&7A nullified display name defaults to", "&7the name of the input/output", "&8&m                <>                ", "&7Currently set to: %display_name%").get();
    private static final ItemStack setDescriptionButton = new ItemBuilder(BrewingRecipeEditor.getButtonData("editor_recipe_brewing_setdescription", Material.WRITABLE_BOOK)).name("&aSet Description").stringTag(BUTTON_ACTION_KEY, "setDescriptionButton").lore("&7Sets the description of the recipe.", "&7The description is visible in the", "&7recipe book as lore.", "&eLeft-Click to set description", "&cRight-Click to nullify description", "&7A nullified description defaults to", "&7a default default recipe format in", "&7the language file.", "&8&m                <>                ", "&7Currently set to: %description%").get();
    private static final ItemStack confirmButton = new ItemBuilder(BrewingRecipeEditor.getButtonData("editor_save", Material.STRUCTURE_VOID)).name("&aConfirm").stringTag(BUTTON_ACTION_KEY, "confirmButton").lore("&aRight-click &7to save changes").get();
    private boolean confirmDeletion = false;
    private static final ItemStack deleteButton = new ItemBuilder(BrewingRecipeEditor.getButtonData("editor_delete", Material.BARRIER)).stringTag(BUTTON_ACTION_KEY, "deleteButton").name("&cDelete Recipe").get();
    private static final ItemStack deleteConfirmButton = new ItemBuilder(BrewingRecipeEditor.getButtonData("editor_deleteconfirm", Material.BARRIER)).name("&cDelete Recipe").stringTag(BUTTON_ACTION_KEY, "deleteConfirmButton").enchant(EnchantmentMappings.UNBREAKING.getEnchantment(), 1).lore("&aRight-click &7to confirm recipe deletion").flag(ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ENCHANTS).wipeAttributes().get();
    private static final ItemStack backToMenuButton = new ItemBuilder(BrewingRecipeEditor.getButtonData("editor_backtomenu", Material.BOOK)).stringTag(BUTTON_ACTION_KEY, "backToMenuButton").name("&fBack to Menu").get();

    public BrewingRecipeEditor(PlayerMenuUtility playerMenuUtility, DynamicBrewingRecipe recipe) {
        super(playerMenuUtility);
        IngredientChoice ingredientChoice;
        IngredientChoice ingredientChoice2;
        RecipeOption o;
        this.recipe = recipe;
        this.ingredient = recipe.getIngredient();
        IngredientChoice ingredientChoice3 = this.ingredient.getOption();
        if (ingredientChoice3 instanceof RecipeOption) {
            o = (RecipeOption)ingredientChoice3;
            ingredientChoice2 = o.getNew();
        } else {
            ingredientChoice2 = this.ingredient.getOption();
        }
        this.ingredient.setOption(ingredientChoice2);
        this.applyOn = recipe.getApplyOn();
        ingredientChoice3 = this.applyOn.getOption();
        if (ingredientChoice3 instanceof RecipeOption) {
            o = (RecipeOption)ingredientChoice3;
            ingredientChoice = o.getNew();
        } else {
            ingredientChoice = this.applyOn.getOption();
        }
        this.applyOn.setOption(ingredientChoice);
        this.result = recipe.getResult();
        this.requireValhallaTools = recipe.requireValhallaTools();
        this.tinker = recipe.tinker();
        this.consumeIngredient = recipe.consumeIngredient();
        this.modifiers = recipe.getModifiers();
        this.unlockedForEveryone = recipe.isUnlockedForEveryone();
        this.brewTime = recipe.getBrewTime();
        this.displayName = recipe.getDisplayName();
        this.description = recipe.getDescription();
    }

    public BrewingRecipeEditor(PlayerMenuUtility playerMenuUtility, DynamicBrewingRecipe recipe, String newName) {
        super(playerMenuUtility);
        this.recipe = new DynamicBrewingRecipe(newName);
        this.ingredient = new SlotEntry(recipe.getIngredient().getItem().clone(), recipe.getIngredient().getOption());
        this.applyOn = new SlotEntry(recipe.getApplyOn().getItem().clone(), recipe.getApplyOn().getOption());
        this.result = recipe.getResult().clone();
        this.requireValhallaTools = recipe.requireValhallaTools();
        this.tinker = recipe.tinker();
        this.consumeIngredient = recipe.consumeIngredient();
        this.modifiers = new ArrayList<DynamicItemModifier>(recipe.getModifiers().stream().map(DynamicItemModifier::copy).toList());
        this.unlockedForEveryone = recipe.isUnlockedForEveryone();
        this.brewTime = recipe.getBrewTime();
        this.displayName = recipe.getDisplayName();
        this.description = recipe.getDescription();
    }

    @Override
    public String getMenuName() {
        return Utils.chat(ValhallaMMO.isResourcePackConfigForced() ? "&f\uf808\uf204\uf80c\uf80a\uf808\uf802&8%recipe%" : TranslationManager.getTranslation("editormenu_brewingrecipes")).replace("%recipe%", this.recipe.getName());
    }

    @Override
    public int getSlots() {
        return 54;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        e.setCancelled(!(e.getClickedInventory() instanceof PlayerInventory));
        ItemStack cursor = e.getCursor();
        ItemStack clicked = e.getCurrentItem();
        String action = ItemUtils.getPDCString(BUTTON_ACTION_KEY, clicked, "");
        if (!StringUtils.isEmpty(action)) {
            switch (action) {
                case "backToMenuButton": {
                    new RecipeOverviewMenu(this.playerMenuUtility, "brewing").open();
                    return;
                }
                case "modifierButton": {
                    this.playerMenuUtility.setPreviousMenu(this);
                    new DynamicModifierMenu(this.playerMenuUtility, this, false).open();
                    return;
                }
                case "recipeOptionsButton": {
                    this.playerMenuUtility.setPreviousMenu(this);
                    new RecipeOptionMenu(this.playerMenuUtility, this).open();
                    return;
                }
                case "deleteButton": {
                    this.confirmDeletion = true;
                    Utils.sendMessage((CommandSender)e.getWhoClicked(), "&cAre you sure you want to delete this recipe?");
                    this.setMenuItems();
                    return;
                }
                case "deleteConfirmButton": {
                    if (!e.isRightClick()) break;
                    CustomRecipeRegistry.unregister(this.recipe.getName());
                    new RecipeOverviewMenu(this.playerMenuUtility, RecipeOverviewMenu.BREWING.getId()).open();
                    return;
                }
                case "setDisplayNameButton": {
                    if (e.isLeftClick()) {
                        this.playerMenuUtility.setPreviousMenu(this);
                        e.getWhoClicked().closeInventory();
                        Questionnaire questionaire = new Questionnaire((Player)e.getWhoClicked(), null, null, new Question[]{new Question("&aWhat should the display name be? (type 'cancel' to cancel)", null, "")}){

                            @Override
                            public Action<Player> getOnFinish() {
                                if (this.getQuestions().isEmpty()) {
                                    return super.getOnFinish();
                                }
                                Question question = this.getQuestions().get(0);
                                if (question.getAnswer() == null) {
                                    return super.getOnFinish();
                                }
                                return p -> {
                                    String answer = Utils.chat(question.getAnswer());
                                    if (!answer.contains("cancel")) {
                                        BrewingRecipeEditor.this.displayName = answer;
                                    }
                                    BrewingRecipeEditor.this.playerMenuUtility.getPreviousMenu().open();
                                };
                            }
                        };
                        Questionnaire.startQuestionnaire((Player)e.getWhoClicked(), questionaire);
                        break;
                    }
                    this.displayName = null;
                    break;
                }
                case "setDescriptionButton": {
                    if (e.isLeftClick()) {
                        this.playerMenuUtility.setPreviousMenu(this);
                        e.getWhoClicked().closeInventory();
                        Questionnaire questionnaire = new Questionnaire((Player)e.getWhoClicked(), null, null, new Question[]{new Question("&aWhat should the description be? Use '/n' to separate lines. (type 'cancel' to cancel)", null, "")}){

                            @Override
                            public Action<Player> getOnFinish() {
                                if (this.getQuestions().isEmpty()) {
                                    return super.getOnFinish();
                                }
                                Question question = this.getQuestions().get(0);
                                if (question.getAnswer() == null) {
                                    return super.getOnFinish();
                                }
                                return p -> {
                                    String answer = Utils.chat(question.getAnswer());
                                    if (!answer.contains("cancel")) {
                                        BrewingRecipeEditor.this.description = answer;
                                    }
                                    BrewingRecipeEditor.this.playerMenuUtility.getPreviousMenu().open();
                                };
                            }
                        };
                        Questionnaire.startQuestionnaire((Player)e.getWhoClicked(), questionnaire);
                        Utils.sendMessage((CommandSender)e.getWhoClicked(), "&aValid placeholders are:");
                        Utils.sendMessage((CommandSender)e.getWhoClicked(), "          &2%ingredient% &afor the input item");
                        Utils.sendMessage((CommandSender)e.getWhoClicked(), "          &2%applyon% &afor the 'applied on' or potion slot item");
                        Utils.sendMessage((CommandSender)e.getWhoClicked(), "          &2%result% &afor a preformatted result");
                        Utils.sendMessage((CommandSender)e.getWhoClicked(), "          &2%tinker% &afor the raw name of the tinkered result");
                        break;
                    }
                    this.description = null;
                    break;
                }
                case "confirmButton": {
                    if (this.applyOn == null || ItemUtils.isEmpty(this.applyOn.getItem()) || this.ingredient == null || ItemUtils.isEmpty(this.ingredient.getItem()) || ItemUtils.isEmpty(this.result)) {
                        Utils.sendMessage((CommandSender)e.getWhoClicked(), "&cAn input and ingredient are required!");
                        this.setMenuItems();
                        return;
                    }
                    this.recipe.setIngredient(this.ingredient);
                    this.recipe.setApplyOn(this.applyOn);
                    this.recipe.setResult(this.result);
                    this.recipe.setRequireValhallaTools(this.requireValhallaTools);
                    this.recipe.setTinker(this.tinker);
                    this.recipe.setConsumeIngredient(this.consumeIngredient);
                    this.recipe.setModifiers(this.modifiers);
                    this.recipe.setUnlockedForEveryone(this.unlockedForEveryone);
                    this.recipe.setBrewTime(this.brewTime);
                    this.recipe.setDescription(this.description);
                    this.recipe.setDisplayName(this.displayName);
                    CustomRecipeRegistry.register(this.recipe, true);
                    CustomRecipeRegistry.setChangesMade();
                    new RecipeOverviewMenu(this.playerMenuUtility, RecipeOverviewMenu.BREWING.getId()).open();
                    return;
                }
                case "brewTimeButton": {
                    this.brewTime = Math.max(0, this.brewTime + (e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? 20 : 1));
                    break;
                }
                case "toggleValhallaToolRequirementButton": {
                    this.requireValhallaTools = !this.requireValhallaTools;
                    break;
                }
                case "toggleTinkerButton": {
                    this.tinker = !this.tinker;
                    break;
                }
                case "toggleUnlockedForEveryoneButton": {
                    this.unlockedForEveryone = !this.unlockedForEveryone;
                    break;
                }
                case "toggleConsumeIngredientButton": {
                    boolean bl = this.consumeIngredient = !this.consumeIngredient;
                }
            }
        }
        if (12 == e.getRawSlot() || applyOnIndexes.contains(e.getRawSlot()) || 24 == e.getRawSlot()) {
            if (e.getRawSlot() == 24) {
                if (!this.tinker && !ItemUtils.isEmpty(cursor)) {
                    this.result = cursor.clone();
                }
            } else if (!ItemUtils.isEmpty(cursor)) {
                String option = ItemUtils.getPDCString(RecipeOptionMenu.KEY_OPTION_ID, cursor, null);
                if (option == null) {
                    if (e.getRawSlot() == 12) {
                        this.ingredient = new SlotEntry(new ItemBuilder(cursor.clone()).amount(1).get(), new MaterialChoice());
                    } else if (applyOnIndexes.contains(e.getRawSlot())) {
                        this.applyOn = new SlotEntry(new ItemBuilder(cursor.clone()).amount(1).get(), new MaterialChoice());
                    }
                } else if (this.selectedChoice != null) {
                    if (e.getRawSlot() == 12) {
                        if (this.selectedChoice.isCompatible(this.ingredient.getItem()) && this.selectedChoice.isCompatibleWithInputItem(false)) {
                            this.ingredient.setOption(this.selectedChoice);
                            e.getWhoClicked().setItemOnCursor(null);
                        } else {
                            Utils.sendMessage((CommandSender)e.getWhoClicked(), "&cNot compatible with this item");
                        }
                    } else if (applyOnIndexes.contains(e.getRawSlot())) {
                        if (this.selectedChoice.isCompatible(this.applyOn.getItem()) && this.selectedChoice.isCompatibleWithInputItem(true)) {
                            this.applyOn.setOption(this.selectedChoice);
                            e.getWhoClicked().setItemOnCursor(null);
                        } else {
                            Utils.sendMessage((CommandSender)e.getWhoClicked(), "&cNot compatible with this item");
                        }
                    }
                }
            } else if (e.getRawSlot() == 12) {
                if (this.ingredient != null) {
                    this.ingredient.setOption(null);
                }
            } else if (applyOnIndexes.contains(e.getRawSlot()) && this.applyOn != null) {
                this.applyOn.setOption(null);
            }
        }
        this.confirmDeletion = false;
        this.setMenuItems();
    }

    @Override
    public void handleMenu(InventoryDragEvent e) {
        e.setCancelled(true);
        if (e.getRawSlots().size() == 1) {
            ClickType type = e.getType() == DragType.EVEN ? ClickType.LEFT : ClickType.RIGHT;
            InventoryAction action = e.getType() == DragType.EVEN ? InventoryAction.DROP_ALL_CURSOR : InventoryAction.DROP_ONE_CURSOR;
            this.handleMenu(new InventoryClickEvent(e.getView(), InventoryType.SlotType.CONTAINER, ((Integer)new ArrayList(e.getRawSlots()).get(0)).intValue(), type, action));
        }
    }

    @Override
    public void setMenuItems() {
        this.inventory.clear();
        if (!ValhallaMMO.getPluginConfig().getBoolean("admin_gui_filler_removal")) {
            for (int i = 0; i < 54; ++i) {
                this.inventory.setItem(i, filler);
            }
        }
        this.inventory.setItem(12, null);
        for (Integer i : applyOnIndexes) {
            this.inventory.setItem(i.intValue(), null);
        }
        if (!this.tinker) {
            this.inventory.setItem(24, null);
        } else {
            this.inventory.setItem(24, new ItemBuilder(this.applyOn.getItem()).name("&dTinkered Base").get());
        }
        List<String> ingredientLore = SlotEntry.getOptionLore(this.ingredient);
        List<String> applyOnLore = SlotEntry.getOptionLore(this.applyOn);
        ItemStack ingredientIcon = new ItemBuilder(this.ingredient.getItem().clone()).appendLore(ingredientLore).get();
        ItemStack applyOnIcon = new ItemBuilder(this.applyOn.getItem().clone()).appendLore(applyOnLore).get();
        this.inventory.setItem(12, ingredientIcon);
        for (Integer i : applyOnIndexes) {
            this.inventory.setItem(i.intValue(), applyOnIcon);
        }
        if (!this.tinker) {
            this.inventory.setItem(24, this.result.clone());
        }
        ArrayList<String> modifierLore = new ArrayList<String>();
        this.modifiers.forEach(m -> modifierLore.addAll(StringUtils.separateStringIntoLines("&d> " + m.getActiveDescription(), 40)));
        ItemBuilder itemBuilder = new ItemBuilder(this.result);
        String tinkerFormat = TranslationManager.getTranslation("tinker_result_format");
        List<String> description = Arrays.asList(this.description == null ? "&eDefault".split("/n") : this.description.replace("%ingredient%", SlotEntry.toString(this.ingredient)).replace("%applyon%", SlotEntry.toString(this.applyOn)).replace("%tinker%", this.tinker ? SlotEntry.toString(this.applyOn) : ItemUtils.getItemName(itemBuilder)).replace("%result%", this.tinker ? tinkerFormat.replace("%item%", SlotEntry.toString(this.applyOn)) : ItemUtils.getItemName(itemBuilder)).split("/n"));
        this.inventory.setItem(0, new ItemBuilder(setDisplayNameButton).lore(ItemUtils.setListPlaceholder(ItemUtils.getLore(setDisplayNameButton), "%display_name%", List.of(this.displayName == null ? "&eDefault" : this.displayName))).get());
        this.inventory.setItem(1, new ItemBuilder(setDescriptionButton).lore(ItemUtils.setListPlaceholder(ItemUtils.getLore(setDescriptionButton), "%description%", description)).get());
        this.inventory.setItem(3, new ItemBuilder(toggleConsumeIngredientButton).name("&eConsume Ingredient: " + (this.consumeIngredient ? "&aYes" : "&fNo")).get());
        this.inventory.setItem(5, new ItemBuilder(toggleUnlockedForEveryoneButton).name("&eUnlocked for Everyone " + (this.unlockedForEveryone ? "&aYes" : "&fNo")).get());
        this.inventory.setItem(10, recipeOptionsButton);
        this.inventory.setItem(17, new ItemBuilder(toggleValhallaToolRequirementButton).name("&eValhalla Tools: " + (this.requireValhallaTools ? "&aYes" : "&fNo")).get());
        this.inventory.setItem(21, new ItemBuilder(brewTimeButton).name(String.format("&fTime to brew: &e%d, %ss", this.brewTime, StringUtils.toTimeStamp2(this.brewTime, 20L))).get());
        this.inventory.setItem(25, new ItemBuilder(modifierButton).lore(modifierLore).get());
        this.inventory.setItem(35, new ItemBuilder(toggleTinkerButton).name("&eTinker: " + (this.tinker ? "&aYes" : "&fNo")).get());
        this.inventory.setItem(45, this.confirmDeletion ? deleteConfirmButton : deleteButton);
        this.inventory.setItem(49, backToMenuButton);
        this.inventory.setItem(53, confirmButton);
    }

    @Override
    public void setResultModifiers(List<DynamicItemModifier> resultModifiers) {
        this.modifiers = resultModifiers;
    }

    @Override
    public List<DynamicItemModifier> getResultModifiers() {
        return this.modifiers;
    }

    @Override
    public void setRecipeOption(RecipeOption option) {
        this.selectedChoice = option;
        if (option == null) {
            return;
        }
        ValhallaMMO.getInstance().getServer().getScheduler().runTaskLater((Plugin)ValhallaMMO.getInstance(), () -> this.playerMenuUtility.getOwner().setItemOnCursor(new ItemBuilder(option.getIcon()).stringTag(RecipeOptionMenu.KEY_OPTION_ID, option.getName()).get()), 1L);
    }
}

