/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.gui.implementations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.crafting.CustomRecipeRegistry;
import me.athlaeos.valhallammo.crafting.blockvalidations.Validation;
import me.athlaeos.valhallammo.crafting.blockvalidations.ValidationRegistry;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.DynamicItemModifier;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierContext;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ResultChangingModifier;
import me.athlaeos.valhallammo.crafting.recipetypes.ImmersiveCraftingRecipe;
import me.athlaeos.valhallammo.dom.Comparator;
import me.athlaeos.valhallammo.gui.Menu;
import me.athlaeos.valhallammo.gui.PlayerMenuUtility;
import me.athlaeos.valhallammo.hooks.WorldGuardHook;
import me.athlaeos.valhallammo.item.CustomFlag;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.listeners.ImmersiveRecipeListener;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.playerstats.AccumulativeStatManager;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileCache;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.PowerProfile;
import me.athlaeos.valhallammo.utility.BlockUtils;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.StringUtils;
import me.athlaeos.valhallammo.utility.Utils;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ImmersiveRecipeSelectionMenu
extends Menu {
    private static final Collection<UUID> playersWhoReceivedFirstTimeMessage = new HashSet<UUID>();
    private static final NamespacedKey BUTTON_ACTION_KEY = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "button_action");
    private static final NamespacedKey BUTTON_RECIPE_KEY = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "button_recipe");
    private static final int filter = 53;
    private static final int predictedResult = 43;
    private static final List<Integer> recipeIndexes = List.of(0, 1, 2, 3, 4, 9, 10, 11, 12, 13, 18, 19, 20, 21, 22, 27, 28, 29, 30, 31, 36, 37, 38, 39, 40, 45, 46, 47, 48, 49);
    private static final List<Integer> ingredientIndexes = List.of(Integer.valueOf(6), Integer.valueOf(7), Integer.valueOf(8), Integer.valueOf(15), Integer.valueOf(16), Integer.valueOf(17), Integer.valueOf(24), Integer.valueOf(25), Integer.valueOf(26));
    private static final ItemStack pageUp = new ItemBuilder(ImmersiveRecipeSelectionMenu.getButtonData("recipeselection_immersive_pageup", Material.ARROW)).stringTag(BUTTON_ACTION_KEY, "pageUp").name(TranslationManager.getTranslation("translation_page_up")).get();
    private static final ItemStack pageDown = new ItemBuilder(ImmersiveRecipeSelectionMenu.getButtonData("recipeselection_immersive_pagedown", Material.ARROW)).stringTag(BUTTON_ACTION_KEY, "pageDown").name(TranslationManager.getTranslation("translation_page_down")).get();
    private static final ItemStack favouritesButton = new ItemBuilder(ImmersiveRecipeSelectionMenu.getButtonData("recipeselection_immersive_favourites", Material.NETHER_STAR)).name(TranslationManager.getTranslation("selectionmenu_recipe_immersive_favourites")).stringTag(BUTTON_ACTION_KEY, "favouritesButton").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack craftOnlyButton = new ItemBuilder(ImmersiveRecipeSelectionMenu.getButtonData("recipeselection_immersive_craftonly", Material.CRAFTING_TABLE)).name(TranslationManager.getTranslation("selectionmenu_recipe_immersive_craftonly")).stringTag(BUTTON_ACTION_KEY, "craftOnlyButton").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack tinkerOnlyButton = new ItemBuilder(ImmersiveRecipeSelectionMenu.getButtonData("recipeselection_immersive_tinkeronly", Material.ANVIL)).name(TranslationManager.getTranslation("selectionmenu_recipe_immersive_tinkeronly")).stringTag(BUTTON_ACTION_KEY, "tinkerOnlyButton").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private View view;
    private final Block clicked;
    private ImmersiveCraftingRecipe selectedRecipe = null;
    private final Collection<ImmersiveCraftingRecipe> recipes = new HashSet<ImmersiveCraftingRecipe>();
    private ItemStack recipeFilter = null;
    private int page = 1;
    private ItemBuilder predictedItem = null;
    private static final NamespacedKey KEY_FAVOURITES = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "favourited_recipes");

    public ImmersiveRecipeSelectionMenu(PlayerMenuUtility playerMenuUtility, Block clicked, boolean craft) {
        super(playerMenuUtility);
        this.clicked = clicked;
        String type = BlockUtils.getBlockType(clicked);
        this.view = craft ? View.CRAFTING : View.TINKERING;
        Player p = playerMenuUtility.getOwner();
        PowerProfile profile = ProfileCache.getOrCache(p, PowerProfile.class);
        if (profile == null) {
            return;
        }
        boolean allAllowed = p.hasPermission("valhalla.allrecipes");
        ((Collection)CustomRecipeRegistry.getImmersiveRecipesByBlock().getOrDefault(type, new HashSet())).forEach(r -> {
            if (r.isUnlockedForEveryone() || allAllowed || profile.getUnlockedRecipes().contains(r.getName()) || p.hasPermission("valhalla.recipe." + r.getName())) {
                this.recipes.add((ImmersiveCraftingRecipe)r);
            }
        });
        this.predictedItem = this.predictResult();
    }

    @Override
    public String getMenuName() {
        return Utils.chat(ValhallaMMO.isResourcePackConfigForced() ? "&f\uf808\uf002\uf80c\uf80a\uf808\uf802" : TranslationManager.getTranslation("selectionmenu_recipe_immersive"));
    }

    @Override
    public int getSlots() {
        return 54;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        ImmersiveCraftingRecipe recipe;
        String r;
        e.setCancelled(true);
        ItemStack clicked = e.getCurrentItem();
        if (e.getClickedInventory() instanceof PlayerInventory) {
            if (ItemUtils.isEmpty(clicked)) {
                this.recipeFilter = null;
            } else {
                this.recipeFilter = clicked.clone();
                this.recipeFilter.setAmount(1);
            }
        } else if (ItemUtils.isEmpty(clicked)) {
            return;
        }
        String action = ItemUtils.getPDCString(BUTTON_ACTION_KEY, clicked, null);
        if (!StringUtils.isEmpty(action)) {
            switch (action) {
                case "pageUp": {
                    --this.page;
                    break;
                }
                case "pageDown": {
                    ++this.page;
                    break;
                }
                case "favouritesButton": {
                    this.view = View.FAVOURITES;
                    break;
                }
                case "craftOnlyButton": {
                    this.view = View.CRAFTING;
                    break;
                }
                case "tinkerOnlyButton": {
                    this.view = View.TINKERING;
                }
            }
        } else if (e.getRawSlot() == 53) {
            this.recipeFilter = null;
        } else if ((e.getRawSlot() == 43 || recipeIndexes.contains(e.getRawSlot())) && !StringUtils.isEmpty(r = ItemUtils.getPDCString(BUTTON_RECIPE_KEY, clicked, null)) && (recipe = CustomRecipeRegistry.getImmersiveRecipes().get(r)) != null) {
            if (e.isShiftClick()) {
                if (ImmersiveRecipeSelectionMenu.isFavourited(this.playerMenuUtility.getOwner(), r)) {
                    ImmersiveRecipeSelectionMenu.removeFavourite(this.playerMenuUtility.getOwner(), r);
                } else {
                    ImmersiveRecipeSelectionMenu.addFavourite(this.playerMenuUtility.getOwner(), r);
                }
            } else if (this.selectedRecipe != null && this.predictedItem != null && !ItemUtils.isEmpty(this.predictedItem.getItem()) && recipe.getName().equals(this.selectedRecipe.getName())) {
                if (CustomFlag.hasFlag(this.predictedItem.getMeta(), CustomFlag.UNCRAFTABLE)) {
                    Utils.sendMessage((CommandSender)e.getWhoClicked(), ItemUtils.getPDCString(DynamicItemModifier.ERROR_MESSAGE, this.predictedItem.getMeta(), ""));
                } else {
                    if (recipe.tinker()) {
                        this.playerMenuUtility.getOwner().spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(Utils.chat(playersWhoReceivedFirstTimeMessage.contains(e.getWhoClicked().getUniqueId()) ? TranslationManager.getTranslation("status_tinkering_recipe_selected") : TranslationManager.getTranslation("status_onetime_tinkering_recipe_selected")).replace("%recipe%", recipe.getDisplayName() == null && clicked != null ? ItemUtils.getItemName(new ItemBuilder(clicked)) : recipe.getDisplayName()).replace("%item%", ItemUtils.getItemName(new ItemBuilder(recipe.getResult())))));
                    } else {
                        this.playerMenuUtility.getOwner().spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(Utils.chat(playersWhoReceivedFirstTimeMessage.contains(e.getWhoClicked().getUniqueId()) ? TranslationManager.getTranslation("status_crafting_recipe_selected") : TranslationManager.getTranslation("status_onetime_crafting_recipe_selected")).replace("%recipe%", recipe.getDisplayName() == null && clicked != null ? ItemUtils.getItemName(new ItemBuilder(clicked)) : recipe.getDisplayName()).replace("%item%", ItemUtils.getItemName(new ItemBuilder(recipe.getResult())))));
                    }
                    playersWhoReceivedFirstTimeMessage.add(e.getWhoClicked().getUniqueId());
                    ImmersiveRecipeListener.getSelectedImmersiveRecipe().put(e.getWhoClicked().getUniqueId(), recipe);
                    e.getWhoClicked().closeInventory();
                }
            } else {
                this.selectedRecipe = recipe;
                this.predictedItem = this.predictResult();
            }
        }
        this.setMenuItems();
    }

    @Override
    public void handleMenu(InventoryDragEvent e) {
        e.setCancelled(true);
    }

    @Override
    public void setMenuItems() {
        this.inventory.clear();
        this.inventory.setItem(53, this.recipeFilter);
        this.inventory.setItem(43, this.predictedItem == null ? null : this.predictedItem.get());
        this.inventory.setItem(5, favouritesButton);
        this.inventory.setItem(14, craftOnlyButton);
        this.inventory.setItem(23, tinkerOnlyButton);
        this.buildMenuItems(buttons -> {
            List p;
            buttons.sort(java.util.Comparator.comparing(this::isIconFavourited, java.util.Comparator.reverseOrder()).thenComparing(ItemStack::getType).thenComparing(item -> ChatColor.stripColor((String)ItemUtils.getItemName(new ItemBuilder((ItemStack)item)))));
            int pageCount = 1;
            if (buttons.size() >= recipeIndexes.size()) {
                Map pages = Utils.paginate(recipeIndexes.size(), buttons);
                pageCount = pages.size();
                if (this.page > pages.size()) {
                    this.page = pages.size();
                } else if (this.page < 1) {
                    this.page = 1;
                }
                p = pages.get(this.page - 1);
            } else {
                p = buttons;
            }
            for (int i = 0; i < p.size(); ++i) {
                this.inventory.setItem(recipeIndexes.get(i).intValue(), (ItemStack)p.get(i));
            }
            if (this.page < pageCount) {
                this.inventory.setItem(50, pageDown);
            }
            if (this.page > 1) {
                this.inventory.setItem(41, pageUp);
            }
            if (this.selectedRecipe != null) {
                List separatedIngredients = ItemUtils.decompressStacks(this.selectedRecipe.getIngredients()).stream().limit(9L).toList();
                for (int i = 0; i < separatedIngredients.size(); ++i) {
                    this.inventory.setItem(ingredientIndexes.get(i).intValue(), (ItemStack)separatedIngredients.get(i));
                }
            }
        });
    }

    private void buildMenuItems(ItemBuilderCallback callback) {
        List<String> defaultFormat = TranslationManager.getListTranslation("immersive_recipe_button_format");
        String ingredientFormat = TranslationManager.getTranslation("recipe_ingredient_format");
        double craftingTimeReduction = AccumulativeStatManager.getCachedStats("CRAFTING_TIME_REDUCTION", (Entity)this.playerMenuUtility.getOwner(), 10000L, true);
        ValhallaMMO.getInstance().getServer().getScheduler().runTaskAsynchronously((Plugin)ValhallaMMO.getInstance(), () -> {
            ArrayList<ItemStack> icons = new ArrayList<ItemStack>();
            for (ImmersiveCraftingRecipe recipe : this.recipes) {
                if (!this.view.shouldShow(this.playerMenuUtility.getOwner(), recipe) || ValhallaMMO.isWorldBlacklisted(this.clicked.getWorld().getName()) || WorldGuardHook.inDisabledRegion(this.clicked.getLocation(), "vmmo-crafting-immersive") || recipe.getValidations().stream().anyMatch(v -> {
                    Validation validation = ValidationRegistry.getValidation(v);
                    if (validation != null) {
                        return !validation.validate(this.clicked);
                    }
                    return false;
                })) continue;
                if (!ItemUtils.isEmpty(this.recipeFilter)) {
                    boolean filterMatch = false;
                    if (recipe.tinker() && recipe.getTinkerInput().getOption().matches(recipe.getTinkerInput().getItem(), this.recipeFilter)) {
                        filterMatch = true;
                    } else if (recipe.getIngredients().keySet().stream().anyMatch(i -> recipe.getMetaRequirement().getChoice().matches((ItemStack)i, this.recipeFilter))) {
                        filterMatch = true;
                    }
                    if (!filterMatch) continue;
                }
                if (this.selectedRecipe != null && this.selectedRecipe.getName().equals(recipe.getName()) && !ItemUtils.isEmpty(this.predictedItem.getItem())) {
                    icons.add(this.predictedItem.name("&r&f" + ItemUtils.getItemName(this.predictedItem)).get());
                    continue;
                }
                ItemStack hand = this.playerMenuUtility.getOwner().getInventory().getItemInMainHand();
                ItemStack button = (recipe.tinker() ? (!ItemUtils.isEmpty(hand) && recipe.getTinkerInput().getOption().matches(recipe.getTinkerInput().getItem(), hand) ? hand : recipe.getTinkerInput().getItem()) : recipe.getResult()).clone();
                ResultChangingModifier changingModifier = recipe.getModifiers().stream().filter(m -> m instanceof ResultChangingModifier).findFirst().orElse(null);
                if (changingModifier != null) {
                    button = changingModifier.getNewResult(ModifierContext.builder(new ItemBuilder(button)).crafter(this.playerMenuUtility.getOwner()).get());
                }
                List<String> lore = new ArrayList<String>(recipe.getDescription() == null ? defaultFormat : Arrays.asList(recipe.getDescription().split("/n")));
                lore = ItemUtils.setListPlaceholder(lore, "%ingredients%", recipe.getIngredients().keySet().stream().map(i -> {
                    int amount = recipe.getIngredients().get(i);
                    return ingredientFormat.replace("%amount%", String.valueOf(amount)).replace("%item%", recipe.getMetaRequirement().getChoice().ingredientDescription((ItemStack)i));
                }).collect(Collectors.toList()));
                String time = String.format("%.1f", Math.max(0.0, (double)recipe.getTimeToCraft() * (1.0 - craftingTimeReduction)) / 20.0);
                lore = lore.stream().map(l -> l.replace("%crafting_time%", time)).collect(Collectors.toList());
                String displayName = recipe.getDisplayName() == null ? ItemUtils.getItemName(new ItemBuilder(button)) : recipe.getDisplayName();
                String favouritePrefix = TranslationManager.getTranslation("recipe_favourited_prefix");
                String favouriteSuffix = TranslationManager.getTranslation("recipe_favourited_suffix");
                icons.add(new ItemBuilder(button).name("&r" + (String)(ImmersiveRecipeSelectionMenu.isFavourited(this.playerMenuUtility.getOwner(), recipe.getName()) ? favouritePrefix + displayName + favouriteSuffix : displayName)).lore(lore).stringTag(BUTTON_RECIPE_KEY, recipe.getName()).translate().get());
            }
            ValhallaMMO.getInstance().getServer().getScheduler().runTask((Plugin)ValhallaMMO.getInstance(), () -> callback.onItemsBuilt(icons));
        });
    }

    private ItemBuilder predictResult() {
        if (this.selectedRecipe == null) {
            return null;
        }
        ItemStack hand = this.playerMenuUtility.getOwner().getInventory().getItemInMainHand();
        ItemStack button = (this.selectedRecipe.tinker() ? (!ItemUtils.isEmpty(hand) && this.selectedRecipe.getTinkerInput().getOption().matches(this.selectedRecipe.getTinkerInput().getItem(), hand) ? hand : this.selectedRecipe.getTinkerInput().getItem()) : this.selectedRecipe.getResult()).clone();
        for (String v : this.selectedRecipe.getValidations()) {
            Validation validation = ValidationRegistry.getValidation(v);
            if (validation == null || validation.validate(this.clicked)) continue;
            return new ItemBuilder(button).flag(CustomFlag.UNCRAFTABLE).lore(validation.validationError());
        }
        ItemBuilder result = new ItemBuilder(button);
        DynamicItemModifier.modify(ModifierContext.builder(result).crafter(this.playerMenuUtility.getOwner()).validate().get(), this.selectedRecipe.getModifiers());
        if (ItemUtils.isEmpty(result.getItem())) {
            return null;
        }
        return result.stringTag(BUTTON_RECIPE_KEY, this.selectedRecipe.getName());
    }

    public static boolean isFavourited(Player p, String recipe) {
        return ImmersiveRecipeSelectionMenu.getFavourites(p).contains(recipe);
    }

    public static List<String> getFavourites(Player p) {
        ArrayList<String> favourites = new ArrayList<String>();
        if (p.getPersistentDataContainer().has(KEY_FAVOURITES, PersistentDataType.STRING)) {
            String value = (String)p.getPersistentDataContainer().get(KEY_FAVOURITES, PersistentDataType.STRING);
            if (value == null) {
                return favourites;
            }
            favourites.addAll(Arrays.asList(value.split("<splitter>")));
        }
        return favourites;
    }

    public static void setFavourites(Player p, List<String> favourites) {
        p.getPersistentDataContainer().set(KEY_FAVOURITES, PersistentDataType.STRING, (Object)String.join((CharSequence)"<splitter>", favourites));
    }

    public static void addFavourite(Player p, String recipe) {
        List<String> favourites = ImmersiveRecipeSelectionMenu.getFavourites(p);
        favourites.add(recipe);
        ImmersiveRecipeSelectionMenu.setFavourites(p, favourites);
    }

    public static void removeFavourite(Player p, String favourite) {
        List<String> favourites = ImmersiveRecipeSelectionMenu.getFavourites(p);
        favourites.remove(favourite);
        ImmersiveRecipeSelectionMenu.setFavourites(p, favourites);
    }

    private boolean isIconFavourited(ItemStack i) {
        String recipe = ItemUtils.getPDCString(BUTTON_RECIPE_KEY, i, "");
        return ImmersiveRecipeSelectionMenu.isFavourited(this.playerMenuUtility.getOwner(), recipe);
    }

    private static enum View {
        CRAFTING((p, r) -> !r.tinker()),
        TINKERING((p, r) -> r.tinker()),
        FAVOURITES((p, r) -> ImmersiveRecipeSelectionMenu.isFavourited(p, r.getName()));

        private final Comparator<Player, ImmersiveCraftingRecipe> viewChecker;

        private View(Comparator<Player, ImmersiveCraftingRecipe> viewChecker) {
            this.viewChecker = viewChecker;
        }

        public boolean shouldShow(Player p, ImmersiveCraftingRecipe recipe) {
            return this.viewChecker.compare(p, recipe);
        }
    }

    private static interface ItemBuilderCallback {
        public void onItemsBuilt(List<ItemStack> var1);
    }
}

