/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.gui.implementations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.crafting.CustomRecipeRegistry;
import me.athlaeos.valhallammo.crafting.blockvalidations.Validation;
import me.athlaeos.valhallammo.crafting.blockvalidations.ValidationRegistry;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.DynamicItemModifier;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.IngredientChoice;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.RecipeOption;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.SlotEntry;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.implementations.MaterialChoice;
import me.athlaeos.valhallammo.crafting.recipetypes.DynamicSmithingRecipe;
import me.athlaeos.valhallammo.dom.Action;
import me.athlaeos.valhallammo.dom.Question;
import me.athlaeos.valhallammo.dom.Questionnaire;
import me.athlaeos.valhallammo.gui.Menu;
import me.athlaeos.valhallammo.gui.PlayerMenuUtility;
import me.athlaeos.valhallammo.gui.SetModifiersMenu;
import me.athlaeos.valhallammo.gui.SetRecipeOptionMenu;
import me.athlaeos.valhallammo.gui.SetValidationsMenu;
import me.athlaeos.valhallammo.gui.implementations.DynamicModifierMenu;
import me.athlaeos.valhallammo.gui.implementations.RecipeOptionMenu;
import me.athlaeos.valhallammo.gui.implementations.RecipeOverviewMenu;
import me.athlaeos.valhallammo.gui.implementations.ValidationSelectionMenu;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.StringUtils;
import me.athlaeos.valhallammo.utility.Utils;
import me.athlaeos.valhallammo.version.EnchantmentMappings;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.DragType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;

public class SmithingRecipeEditor
extends Menu
implements SetModifiersMenu,
SetRecipeOptionMenu,
SetValidationsMenu {
    private static final NamespacedKey BUTTON_ACTION_KEY = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "button_action");
    private static final int templateIndex = 20;
    private static final int baseIndex = 21;
    private static final int additionIndex = 22;
    private static final int resultIndex = 24;
    private static final ItemStack filler = new ItemBuilder(Material.GRAY_STAINED_GLASS_PANE).name("&r").get();
    private final DynamicSmithingRecipe recipe;
    private RecipeOption selectedChoice = null;
    private SlotEntry template;
    private SlotEntry base;
    private SlotEntry addition;
    private ItemStack result;
    private boolean requireValhallaTools;
    private boolean tinker;
    private boolean consumeAddition;
    private List<DynamicItemModifier> additionModifiers;
    private List<DynamicItemModifier> resultModifiers;
    private boolean unlockedForEveryone;
    private Collection<String> validations;
    private String displayName;
    private String description;
    private static final ItemStack toggleValhallaToolRequirementButton = new ItemBuilder(SmithingRecipeEditor.getButtonData("editor_recipe_smithing_valhallatoolrequirement", Material.DIAMOND_PICKAXE)).name("&eValhalla Tools").stringTag(BUTTON_ACTION_KEY, "toggleValhallaToolRequirementButton").lore("&7If enabled, the armors or tools", "&7in the recipe need to have ValhallaMMO ", "&7custom attributes. If disabled, vanilla ", "&7equipment can be used too.", "&eClick to toggle on/off").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack toggleTinkerButton = new ItemBuilder(SmithingRecipeEditor.getButtonData("editor_recipe_smithing_toggletinker", Material.ANVIL)).name("&eTinker Tools").stringTag(BUTTON_ACTION_KEY, "toggleTinkerButton").lore("&7If enabled, the recipe will", "&7improve the input item of the recipe.", "&7Otherwise, it will simply produce the", "&7item specified as the result.", "&eClick to toggle on/off").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack toggleConsumeAdditionButton = new ItemBuilder(SmithingRecipeEditor.getButtonData("editor_recipe_smithing_toggleconsumeaddition", Material.GOLDEN_APPLE)).name("&eConsume Addition").stringTag(BUTTON_ACTION_KEY, "toggleConsumeAdditionButton").lore("&7If enabled, the recipe will", "&7consume 1 of the addition item like usual.", "&7Otherwise, the addition will be left", "&7in the smithing table GUI which also", "&7allows it to be tinkered.", "&eClick to toggle on/off").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack selectValidationButton = new ItemBuilder(SmithingRecipeEditor.getButtonData("editor_recipe_smithing_selectvalidation", Material.BARRIER)).name("&eBlock condition").stringTag(BUTTON_ACTION_KEY, "selectValidationButton").lore("&7Block conditions are checks", "&7to allow/disallow recipes based on", "&7block environment.", "&7These conditions may also change", "&7the environment after crafting.", "&eClick to open the menu", "&8&m                <>                ", "%description%").get();
    private static final ItemStack additionModifierButton = new ItemBuilder(SmithingRecipeEditor.getButtonData("editor_recipe_smithing_additionmodifiers", Material.WRITABLE_BOOK)).name("&dAddition Item Modifiers").stringTag(BUTTON_ACTION_KEY, "additionModifierButton").lore("&7Modifiers are usually functions to edit", "&7the output item based on player", "&7stats or to apply crafting conditions.", "&aThese modifiers specifically run on", "&athe addition item if 'consume addition'", "&ais disabled.", "&eClick to open the menu", "&8&m                <>                ", "%modifiers%").get();
    private static final ItemStack resultModifierButton = new ItemBuilder(SmithingRecipeEditor.getButtonData("editor_recipe_smithing_resultmodifiers", Material.WRITABLE_BOOK)).name("&dResult Item Modifiers").stringTag(BUTTON_ACTION_KEY, "resultModifierButton").lore("&7Modifiers are functions to edit", "&7the output item based on player", "&7stats or to apply crafting conditions.", "&eClick to open the menu", "&8&m                <>                ", "%modifiers%").get();
    private static final ItemStack recipeOptionsButton = new ItemBuilder(SmithingRecipeEditor.getButtonData("editor_recipe_smithing_recipeoptions", Material.WRITABLE_BOOK)).name("&bIngredient Options").stringTag(BUTTON_ACTION_KEY, "recipeOptionsButton").lore("&7Ingredient options are ingredient", "&7flags you can put on an ingredient", "&7to change its behavior during crafting.", "&eClick to open the menu").get();
    private static final ItemStack toggleUnlockedForEveryoneButton = new ItemBuilder(SmithingRecipeEditor.getButtonData("editor_recipe_smithing_unlockedforeveryone", Material.PAPER)).name("&eUnlocked for Everyone").stringTag(BUTTON_ACTION_KEY, "toggleUnlockedForEveryoneButton").lore("&7If enabled, the recipe will", "&7available to everyone regardless", "&7if unlocked or not. Otherwise it", "&7will have to be unlocked through", "&7perk rewards.", "&eClick to toggle on/off").get();
    private static final ItemStack setDisplayNameButton = new ItemBuilder(SmithingRecipeEditor.getButtonData("editor_recipe_smithing_setdisplayname", Material.NAME_TAG)).name("&aSet Display Name").stringTag(BUTTON_ACTION_KEY, "setDisplayNameButton").lore("&7Sets the display name of the recipe.", "&7The display name is visible in the", "&7recipe book and is usually used", "&7to roughly describe the purpose of", "&7tinkering recipes since the output is", "&7non-descriptive.", "&eLeft-Click to set display name", "&cRight-Click to nullify display name", "&7A nullified display name defaults to", "&7the name of the input/output", "&8&m                <>                ", "&7Currently set to: %display_name%").get();
    private static final ItemStack setDescriptionButton = new ItemBuilder(SmithingRecipeEditor.getButtonData("editor_recipe_smithing_setdescription", Material.WRITABLE_BOOK)).name("&aSet Description").stringTag(BUTTON_ACTION_KEY, "setDescriptionButton").lore("&7Sets the description of the recipe.", "&7The description is visible in the", "&7recipe book as lore.", "&eLeft-Click to set description", "&cRight-Click to nullify description", "&7A nullified description defaults to", "&7a default default recipe format in", "&7the language file.", "&8&m                <>                ", "&7Currently set to: %description%").get();
    private static final ItemStack confirmButton = new ItemBuilder(SmithingRecipeEditor.getButtonData("editor_save", Material.STRUCTURE_VOID)).name("&aConfirm").stringTag(BUTTON_ACTION_KEY, "confirmButton").lore("&aRight-click &7to save changes").get();
    private boolean confirmDeletion = false;
    private static final ItemStack deleteButton = new ItemBuilder(SmithingRecipeEditor.getButtonData("editor_delete", Material.BARRIER)).stringTag(BUTTON_ACTION_KEY, "deleteButton").name("&cDelete Recipe").get();
    private static final ItemStack deleteConfirmButton = new ItemBuilder(SmithingRecipeEditor.getButtonData("editor_deleteconfirm", Material.BARRIER)).name("&cDelete Recipe").stringTag(BUTTON_ACTION_KEY, "deleteConfirmButton").enchant(EnchantmentMappings.UNBREAKING.getEnchantment(), 1).lore("&aRight-click &7to confirm recipe deletion").flag(ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ENCHANTS).get();
    private static final ItemStack backToMenuButton = new ItemBuilder(SmithingRecipeEditor.getButtonData("editor_backtomenu", Material.BOOK)).stringTag(BUTTON_ACTION_KEY, "backToMenuButton").name("&fBack to Menu").get();
    private String lastAction = null;

    public SmithingRecipeEditor(PlayerMenuUtility playerMenuUtility, DynamicSmithingRecipe recipe) {
        super(playerMenuUtility);
        IngredientChoice ingredientChoice;
        IngredientChoice ingredientChoice2;
        IngredientChoice ingredientChoice3;
        RecipeOption o;
        this.recipe = recipe;
        this.template = recipe.getTemplate();
        IngredientChoice ingredientChoice4 = this.template.getOption();
        if (ingredientChoice4 instanceof RecipeOption) {
            o = (RecipeOption)ingredientChoice4;
            ingredientChoice3 = o.getNew();
        } else {
            ingredientChoice3 = this.template.getOption();
        }
        this.template.setOption(ingredientChoice3);
        this.base = recipe.getBase();
        ingredientChoice4 = this.base.getOption();
        if (ingredientChoice4 instanceof RecipeOption) {
            o = (RecipeOption)ingredientChoice4;
            ingredientChoice2 = o.getNew();
        } else {
            ingredientChoice2 = this.base.getOption();
        }
        this.base.setOption(ingredientChoice2);
        this.addition = recipe.getAddition();
        ingredientChoice4 = this.addition.getOption();
        if (ingredientChoice4 instanceof RecipeOption) {
            o = (RecipeOption)ingredientChoice4;
            ingredientChoice = o.getNew();
        } else {
            ingredientChoice = this.addition.getOption();
        }
        this.addition.setOption(ingredientChoice);
        this.result = recipe.getResult();
        this.requireValhallaTools = recipe.requireValhallaTools();
        this.tinker = recipe.tinkerBase();
        this.consumeAddition = recipe.consumeAddition();
        this.resultModifiers = recipe.getResultModifiers();
        this.additionModifiers = recipe.getAdditionModifiers();
        this.unlockedForEveryone = recipe.isUnlockedForEveryone();
        this.validations = recipe.getValidations();
        this.displayName = recipe.getDisplayName();
        this.description = recipe.getDescription();
    }

    public SmithingRecipeEditor(PlayerMenuUtility playerMenuUtility, DynamicSmithingRecipe recipe, String newName) {
        super(playerMenuUtility);
        this.recipe = new DynamicSmithingRecipe(newName);
        this.template = new SlotEntry(recipe.getTemplate().getItem().clone(), recipe.getTemplate().getOption());
        this.base = new SlotEntry(recipe.getBase().getItem().clone(), recipe.getBase().getOption());
        this.addition = new SlotEntry(recipe.getAddition().getItem().clone(), recipe.getAddition().getOption());
        this.result = recipe.getResult().clone();
        this.requireValhallaTools = recipe.requireValhallaTools();
        this.tinker = recipe.tinkerBase();
        this.consumeAddition = recipe.consumeAddition();
        this.resultModifiers = new ArrayList<DynamicItemModifier>(recipe.getResultModifiers().stream().map(DynamicItemModifier::copy).toList());
        this.additionModifiers = new ArrayList<DynamicItemModifier>(recipe.getAdditionModifiers().stream().map(DynamicItemModifier::copy).toList());
        this.unlockedForEveryone = recipe.isUnlockedForEveryone();
        this.validations = new HashSet<String>(recipe.getValidations());
        this.displayName = recipe.getDisplayName();
        this.description = recipe.getDescription();
    }

    @Override
    public String getMenuName() {
        return Utils.chat(ValhallaMMO.isResourcePackConfigForced() ? "&f\uf808\uf203\uf80c\uf80a\uf808\uf802&8%recipe%" : TranslationManager.getTranslation("editormenu_smithingrecipes")).replace("%recipe%", this.recipe.getName());
    }

    @Override
    public int getSlots() {
        return 54;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        e.setCancelled(!(e.getClickedInventory() instanceof PlayerInventory));
        ItemStack cursor = e.getCursor();
        ItemStack clicked = e.getCurrentItem();
        String action = ItemUtils.getPDCString(BUTTON_ACTION_KEY, clicked, "");
        if (!StringUtils.isEmpty(action)) {
            this.lastAction = action;
            switch (action) {
                case "backToMenuButton": {
                    new RecipeOverviewMenu(this.playerMenuUtility, "smithing").open();
                    return;
                }
                case "resultModifierButton": 
                case "additionModifierButton": {
                    this.playerMenuUtility.setPreviousMenu(this);
                    new DynamicModifierMenu(this.playerMenuUtility, this, true).open();
                    return;
                }
                case "recipeOptionsButton": {
                    this.playerMenuUtility.setPreviousMenu(this);
                    new RecipeOptionMenu(this.playerMenuUtility, this).open();
                    return;
                }
                case "deleteButton": {
                    this.confirmDeletion = true;
                    Utils.sendMessage((CommandSender)e.getWhoClicked(), "&cAre you sure you want to delete this recipe?");
                    this.setMenuItems();
                    return;
                }
                case "deleteConfirmButton": {
                    if (!e.isRightClick()) break;
                    CustomRecipeRegistry.unregister(this.recipe.getName());
                    new RecipeOverviewMenu(this.playerMenuUtility, RecipeOverviewMenu.SMITHING.getId()).open();
                    return;
                }
                case "selectValidationButton": {
                    this.playerMenuUtility.setPreviousMenu(this);
                    new ValidationSelectionMenu(this.playerMenuUtility, this, "SMITHING_TABLE").open();
                    return;
                }
                case "setDisplayNameButton": {
                    if (e.isLeftClick()) {
                        this.playerMenuUtility.setPreviousMenu(this);
                        e.getWhoClicked().closeInventory();
                        Questionnaire questionaire = new Questionnaire((Player)e.getWhoClicked(), null, null, new Question[]{new Question("&aWhat should the display name be? (type 'cancel' to cancel)", null, "")}){

                            @Override
                            public Action<Player> getOnFinish() {
                                if (this.getQuestions().isEmpty()) {
                                    return super.getOnFinish();
                                }
                                Question question = this.getQuestions().get(0);
                                if (question.getAnswer() == null) {
                                    return super.getOnFinish();
                                }
                                return p -> {
                                    String answer = Utils.chat(question.getAnswer());
                                    if (!answer.contains("cancel")) {
                                        SmithingRecipeEditor.this.displayName = answer;
                                    }
                                    SmithingRecipeEditor.this.playerMenuUtility.getPreviousMenu().open();
                                };
                            }
                        };
                        Questionnaire.startQuestionnaire((Player)e.getWhoClicked(), questionaire);
                        break;
                    }
                    this.displayName = null;
                    break;
                }
                case "setDescriptionButton": {
                    if (e.isLeftClick()) {
                        this.playerMenuUtility.setPreviousMenu(this);
                        e.getWhoClicked().closeInventory();
                        Questionnaire questionnaire = new Questionnaire((Player)e.getWhoClicked(), null, null, new Question[]{new Question("&aWhat should the description be? Use '/n' to separate lines. (type 'cancel' to cancel)", null, "")}){

                            @Override
                            public Action<Player> getOnFinish() {
                                if (this.getQuestions().isEmpty()) {
                                    return super.getOnFinish();
                                }
                                Question question = this.getQuestions().get(0);
                                if (question.getAnswer() == null) {
                                    return super.getOnFinish();
                                }
                                return p -> {
                                    String answer = Utils.chat(question.getAnswer());
                                    if (!answer.contains("cancel")) {
                                        SmithingRecipeEditor.this.description = answer;
                                    }
                                    SmithingRecipeEditor.this.playerMenuUtility.getPreviousMenu().open();
                                };
                            }
                        };
                        Questionnaire.startQuestionnaire((Player)e.getWhoClicked(), questionnaire);
                        Utils.sendMessage((CommandSender)e.getWhoClicked(), "&aValid placeholders are:");
                        Utils.sendMessage((CommandSender)e.getWhoClicked(), "          &2%template% &afor the template item");
                        Utils.sendMessage((CommandSender)e.getWhoClicked(), "          &2%base% &afor the base item");
                        Utils.sendMessage((CommandSender)e.getWhoClicked(), "          &2%addition% &afor the added item");
                        Utils.sendMessage((CommandSender)e.getWhoClicked(), "          &2%result% &afor a preformatted result");
                        Utils.sendMessage((CommandSender)e.getWhoClicked(), "          &2%tinker% &afor the raw name of the tinkered result");
                        break;
                    }
                    this.description = null;
                    break;
                }
                case "confirmButton": {
                    if (this.base == null || ItemUtils.isEmpty(this.base.getItem()) || this.addition == null || ItemUtils.isEmpty(this.addition.getItem()) || ItemUtils.isEmpty(this.result)) {
                        Utils.sendMessage((CommandSender)e.getWhoClicked(), "&cA base and addition are required!");
                        this.setMenuItems();
                        return;
                    }
                    this.recipe.setTemplate(this.template);
                    this.recipe.setBase(this.base);
                    this.recipe.setAddition(this.addition);
                    this.recipe.setResult(this.result);
                    this.recipe.setRequireValhallaTools(this.requireValhallaTools);
                    this.recipe.setTinkerBase(this.tinker);
                    this.recipe.setConsumeAddition(this.consumeAddition);
                    this.recipe.setResultModifiers(this.resultModifiers);
                    this.recipe.setAdditionModifiers(this.additionModifiers);
                    this.recipe.setUnlockedForEveryone(this.unlockedForEveryone);
                    this.recipe.setValidations(this.validations);
                    this.recipe.setDescription(this.description);
                    this.recipe.setDisplayName(this.displayName);
                    CustomRecipeRegistry.register(this.recipe, true);
                    CustomRecipeRegistry.setChangesMade();
                    new RecipeOverviewMenu(this.playerMenuUtility, "smithing").open();
                    return;
                }
                case "toggleValhallaToolRequirementButton": {
                    this.requireValhallaTools = !this.requireValhallaTools;
                    break;
                }
                case "toggleTinkerButton": {
                    this.tinker = !this.tinker;
                    break;
                }
                case "toggleUnlockedForEveryoneButton": {
                    this.unlockedForEveryone = !this.unlockedForEveryone;
                    break;
                }
                case "toggleConsumeAdditionButton": {
                    boolean bl = this.consumeAddition = !this.consumeAddition;
                }
            }
        }
        if (20 == e.getRawSlot() || 21 == e.getRawSlot() || 22 == e.getRawSlot() || 24 == e.getRawSlot()) {
            if (e.getRawSlot() == 24) {
                if (!this.tinker && !ItemUtils.isEmpty(cursor)) {
                    this.result = cursor.clone();
                }
            } else if (!ItemUtils.isEmpty(cursor)) {
                String option = ItemUtils.getPDCString(RecipeOptionMenu.KEY_OPTION_ID, cursor, null);
                if (option == null) {
                    if (e.getRawSlot() == 20) {
                        this.template = new SlotEntry(new ItemBuilder(cursor.clone()).amount(1).get(), new MaterialChoice());
                    } else if (e.getRawSlot() == 21) {
                        this.base = new SlotEntry(new ItemBuilder(cursor.clone()).amount(1).get(), new MaterialChoice());
                    } else if (e.getRawSlot() == 22) {
                        this.addition = new SlotEntry(new ItemBuilder(cursor.clone()).amount(1).get(), new MaterialChoice());
                    }
                } else if (this.selectedChoice != null) {
                    if (e.getRawSlot() == 20) {
                        if (this.selectedChoice.isCompatible(this.template.getItem()) && this.selectedChoice.isCompatibleWithInputItem(false)) {
                            this.template.setOption(this.selectedChoice);
                            e.getWhoClicked().setItemOnCursor(null);
                        } else {
                            Utils.sendMessage((CommandSender)e.getWhoClicked(), "&cNot compatible with this item");
                        }
                    } else if (e.getRawSlot() == 21) {
                        if (this.selectedChoice.isCompatible(this.base.getItem()) && this.selectedChoice.isCompatibleWithInputItem(false)) {
                            this.base.setOption(this.selectedChoice);
                            e.getWhoClicked().setItemOnCursor(null);
                        } else {
                            Utils.sendMessage((CommandSender)e.getWhoClicked(), "&cNot compatible with this item");
                        }
                    } else if (e.getRawSlot() == 22) {
                        if (this.selectedChoice.isCompatible(this.addition.getItem()) && this.selectedChoice.isCompatibleWithInputItem(true)) {
                            this.addition.setOption(this.selectedChoice);
                            e.getWhoClicked().setItemOnCursor(null);
                        } else {
                            Utils.sendMessage((CommandSender)e.getWhoClicked(), "&cNot compatible with this item");
                        }
                    }
                }
            } else if (e.getRawSlot() == 20) {
                this.template = null;
            } else if (e.getRawSlot() == 21) {
                if (this.base != null) {
                    this.base.setOption(null);
                }
            } else if (e.getRawSlot() == 22 && this.addition != null) {
                this.addition.setOption(null);
            }
        }
        this.confirmDeletion = false;
        this.setMenuItems();
    }

    @Override
    public void handleMenu(InventoryDragEvent e) {
        e.setCancelled(true);
        if (e.getRawSlots().size() == 1) {
            ClickType type = e.getType() == DragType.EVEN ? ClickType.LEFT : ClickType.RIGHT;
            InventoryAction action = e.getType() == DragType.EVEN ? InventoryAction.DROP_ALL_CURSOR : InventoryAction.DROP_ONE_CURSOR;
            this.handleMenu(new InventoryClickEvent(e.getView(), InventoryType.SlotType.CONTAINER, ((Integer)new ArrayList(e.getRawSlots()).get(0)).intValue(), type, action));
        }
    }

    @Override
    public void setMenuItems() {
        this.inventory.clear();
        if (!ValhallaMMO.getPluginConfig().getBoolean("admin_gui_filler_removal")) {
            for (int i = 0; i < 54; ++i) {
                this.inventory.setItem(i, filler);
            }
        }
        this.inventory.setItem(20, null);
        this.inventory.setItem(21, null);
        this.inventory.setItem(22, null);
        if (!this.tinker) {
            this.inventory.setItem(24, null);
        } else {
            this.inventory.setItem(24, new ItemBuilder(this.base.getItem()).name("&dTinkered Base").get());
        }
        List<String> templateLore = SlotEntry.getOptionLore(this.template);
        List<String> baseLore = SlotEntry.getOptionLore(this.base);
        List<String> additionLore = SlotEntry.getOptionLore(this.addition);
        ItemStack templateIcon = this.template == null ? new ItemBuilder(Material.BARRIER).name("&fNo template required!").lore("&7Click with an item to require", "&7it as template.").get() : new ItemBuilder(this.template.getItem().clone()).appendLore(templateLore).get();
        ItemStack baseIcon = new ItemBuilder(this.base.getItem().clone()).appendLore(baseLore).get();
        ItemStack additionIcon = new ItemBuilder(this.addition.getItem().clone()).appendLore(additionLore).get();
        this.inventory.setItem(20, templateIcon);
        this.inventory.setItem(21, baseIcon);
        this.inventory.setItem(22, additionIcon);
        if (!this.tinker) {
            this.inventory.setItem(24, this.result.clone());
        }
        ArrayList<String> validationLore = new ArrayList<String>();
        if (!this.validations.isEmpty()) {
            for (String v : this.validations) {
                Validation validation = ValidationRegistry.getValidation(v);
                validationLore.add(validation.activeDescription());
            }
        } else {
            validationLore.add("&aNo special conditions required");
        }
        ArrayList<String> additionModifierLore = new ArrayList<String>();
        this.additionModifiers.forEach(m -> additionModifierLore.addAll(StringUtils.separateStringIntoLines("&d> " + m.getActiveDescription(), 40)));
        ArrayList<String> resultModifierLore = new ArrayList<String>();
        this.resultModifiers.forEach(m -> resultModifierLore.addAll(StringUtils.separateStringIntoLines("&d> " + m.getActiveDescription(), 40)));
        ItemBuilder resultBuilder = new ItemBuilder(this.result);
        String tinkerFormat = TranslationManager.getTranslation("tinker_result_format");
        List<String> description = Arrays.asList(this.description == null ? "&eDefault".split("/n") : this.description.replace("%template%", SlotEntry.toString(this.template)).replace("%base%", SlotEntry.toString(this.base)).replace("%tinker%", this.tinker ? SlotEntry.toString(this.base) : ItemUtils.getItemName(resultBuilder)).replace("%result%", this.tinker ? tinkerFormat.replace("%item%", SlotEntry.toString(this.base)) : ItemUtils.getItemName(resultBuilder)).replace("%addition%", SlotEntry.toString(this.addition)).split("/n"));
        this.inventory.setItem(0, new ItemBuilder(setDisplayNameButton).lore(ItemUtils.setListPlaceholder(ItemUtils.getLore(setDisplayNameButton), "%display_name%", List.of(this.displayName == null ? "&eDefault" : this.displayName))).get());
        this.inventory.setItem(1, new ItemBuilder(setDescriptionButton).lore(ItemUtils.setListPlaceholder(ItemUtils.getLore(setDescriptionButton), "%description%", description)).get());
        this.inventory.setItem(5, new ItemBuilder(toggleUnlockedForEveryoneButton).name("&eUnlocked for Everyone " + (this.unlockedForEveryone ? "&aYes" : "&fNo")).get());
        this.inventory.setItem(10, new ItemBuilder(selectValidationButton).lore(ItemUtils.setListPlaceholder(ItemUtils.getLore(selectValidationButton), "%description%", validationLore)).get());
        this.inventory.setItem(12, recipeOptionsButton);
        this.inventory.setItem(26, new ItemBuilder(toggleValhallaToolRequirementButton).name("&eValhalla Tools: " + (this.requireValhallaTools ? "&aYes" : "&fNo")).get());
        this.inventory.setItem(30, new ItemBuilder(toggleTinkerButton).name("&eTinker: " + (this.tinker ? "&aYes" : "&fNo")).get());
        this.inventory.setItem(13, new ItemBuilder(toggleConsumeAdditionButton).name("&eConsume Addition: " + (this.consumeAddition ? "&aYes" : "&fNo")).get());
        this.inventory.setItem(33, new ItemBuilder(resultModifierButton).lore(resultModifierLore).get());
        if (!this.consumeAddition) {
            this.inventory.setItem(31, new ItemBuilder(additionModifierButton).lore(additionModifierLore).get());
        }
        this.inventory.setItem(45, this.confirmDeletion ? deleteConfirmButton : deleteButton);
        this.inventory.setItem(49, backToMenuButton);
        this.inventory.setItem(53, confirmButton);
    }

    @Override
    public void setResultModifiers(List<DynamicItemModifier> resultModifiers) {
        if (this.lastAction.equals("resultModifierButton")) {
            this.resultModifiers = resultModifiers;
        } else if (this.lastAction.equals("additionModifierButton")) {
            this.additionModifiers = resultModifiers;
        }
    }

    @Override
    public List<DynamicItemModifier> getResultModifiers() {
        if (this.lastAction.equals("resultModifierButton")) {
            return this.resultModifiers;
        }
        if (this.lastAction.equals("additionModifierButton")) {
            return this.additionModifiers;
        }
        return new ArrayList<DynamicItemModifier>();
    }

    @Override
    public void setRecipeOption(RecipeOption option) {
        this.selectedChoice = option;
        if (option == null) {
            return;
        }
        ValhallaMMO.getInstance().getServer().getScheduler().runTaskLater((Plugin)ValhallaMMO.getInstance(), () -> this.playerMenuUtility.getOwner().setItemOnCursor(new ItemBuilder(option.getIcon()).stringTag(RecipeOptionMenu.KEY_OPTION_ID, option.getName()).get()), 1L);
    }

    @Override
    public void setValidations(Collection<String> validations) {
        this.validations = validations;
    }

    @Override
    public Collection<String> getValidations() {
        return this.validations;
    }
}

