/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.gui.implementations.loottablecategories;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.dom.Catch;
import me.athlaeos.valhallammo.entities.EntityClassification;
import me.athlaeos.valhallammo.gui.Menu;
import me.athlaeos.valhallammo.gui.PlayerMenuUtilManager;
import me.athlaeos.valhallammo.gui.implementations.LootTableOverviewMenu;
import me.athlaeos.valhallammo.gui.implementations.LootTableSelectionMenu;
import me.athlaeos.valhallammo.gui.implementations.loottablecategories.TableCategory;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.loot.LootTable;
import me.athlaeos.valhallammo.loot.LootTableRegistry;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.StringUtils;
import me.athlaeos.valhallammo.utility.Utils;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class EntityLootTables
extends TableCategory {
    private static final Map<EntityType, Material> entityIconMapping = new HashMap<EntityType, Material>();

    public EntityLootTables(int position) {
        super("loot_table_entities", new ItemBuilder(Material.PARROT_SPAWN_EGG).name("&eEntity Loot Tables").lore("&fLoot tables assigned to entities, ", "&fdropped when killed.").get(), position, Utils.chat(ValhallaMMO.isResourcePackConfigForced() ? "&f\uf808\uf317\uf80c\uf80a\uf808\uf802" : TranslationManager.getTranslation("editormenu_entitytables")));
    }

    @Override
    public List<ItemStack> getCategoryOptions() {
        ArrayList<ItemBuilder> buttons = new ArrayList<ItemBuilder>();
        for (EntityType e : entityIconMapping.keySet()) {
            LootTable typeTable = LootTableRegistry.getLootTable(e);
            ItemBuilder builder = new ItemBuilder(entityIconMapping.get(e)).name((typeTable != null ? "&a" : "&c") + String.valueOf(e)).stringTag(LootTableOverviewMenu.KEY_TABLE, e.toString());
            if (typeTable == null) {
                builder.lore("&cNo loot table set");
            } else {
                builder.lore("&aHas loot table: " + typeTable.getKey());
            }
            builder.appendLore("&fClick to set new loot table", "&fShift-Click to remove loot table");
            buttons.add(builder);
        }
        buttons.sort(Comparator.comparing(ItemUtils::getItemName));
        return buttons.stream().map(ItemBuilder::get).collect(Collectors.toList());
    }

    @Override
    public void onButtonClick(InventoryClickEvent e, String storedValue, Menu openedFrom) {
        if (StringUtils.isEmpty(storedValue)) {
            return;
        }
        EntityType en = Catch.catchOrElse(() -> EntityType.valueOf((String)storedValue), null);
        if (en == null) {
            return;
        }
        if (!e.isShiftClick()) {
            new LootTableSelectionMenu(PlayerMenuUtilManager.getPlayerMenuUtility((Player)e.getWhoClicked()), openedFrom, table -> {
                LootTableRegistry.getEntityLootTables().put(en.toString(), table.getKey());
                new LootTableOverviewMenu(PlayerMenuUtilManager.getPlayerMenuUtility((Player)e.getWhoClicked()), LootTableOverviewMenu.ENTITIES_LOOT.getId()).open();
            }).open();
        } else {
            LootTableRegistry.getEntityLootTables().remove(en.toString());
        }
    }

    private static String getEntityIcon(String type) {
        return switch (type) {
            case "BAT" -> "BAT_SPAWN_EGG";
            case "BEE" -> "HONEY_BOTTLE";
            case "CAT" -> "STRING";
            case "COD" -> "COD";
            case "COW" -> "BEEF";
            case "FOX" -> "SWEET_BERRIES";
            case "PIG" -> "PORKCHOP";
            case "VEX" -> "VEX_SPAWN_EGG";
            case "FROG" -> "OCHRE_FROGLIGHT";
            case "GOAT" -> "GOAT_HORN";
            case "HUSK" -> "SAND";
            case "MULE" -> "SADDLE";
            case "WOLF" -> "WOLF_SPAWN_EGG";
            case "ALLAY" -> "ALLAY_SPAWN_EGG";
            case "BLAZE" -> "BLAZE_ROD";
            case "CAMEL" -> "CAMEL_SPAWN_EGG";
            case "GHAST" -> "GHAST_TEAR";
            case "HORSE" -> "DIAMOND_HORSE_ARMOR";
            case "LLAMA" -> "LLAMA_SPAWN_EGG";
            case "PANDA" -> "BAMBOO";
            case "SHEEP" -> "WHITE_WOOL";
            case "SLIME" -> "SLIME_BALL";
            case "SQUID" -> "INK_SAC";
            case "STRAY" -> "TIPPED_ARROW";
            case "WITCH" -> "SPLASH_POTION";
            case "DONKEY" -> "CHEST";
            case "EVOKER" -> "TOTEM_OF_UNDYING";
            case "HOGLIN" -> "HOGLIN_SPAWN_EGG";
            case "OCELOT" -> "OCELOT_SPAWN_EGG";
            case "PARROT" -> "PARROT_SPAWN_EGG";
            case "PIGLIN" -> "GOLD_INGOT";
            case "PLAYER" -> "DIAMOND";
            case "RABBIT" -> "RABBIT_FOOT";
            case "SALMON" -> "SALMON";
            case "SPIDER" -> "SPIDER_EYE";
            case "TURTLE" -> "SCUTE";
            case "WARDEN" -> "SCULK_SHRIEKER";
            case "WITHER" -> "NETHER_STAR";
            case "ZOGLIN" -> "ZOGLIN_SPAWN_EGG";
            case "ZOMBIE" -> "ROTTEN_FLESH";
            case "AXOLOTL" -> "AXOLOTL_SPAWN_EGG";
            case "CHICKEN" -> "CHICKEN";
            case "CREEPER" -> "GUNPOWDER";
            case "DOLPHIN" -> "HEART_OF_THE_SEA";
            case "DROWNED" -> "TRIDENT";
            case "PHANTOM" -> "PHANTOM_MEMBRANE";
            case "RAVAGER" -> "RAVAGER_SPAWN_EGG";
            case "SHULKER" -> "SHULKER_SHELL";
            case "SNIFFER" -> "SNIFFER_EGG";
            case "SNOWMAN" -> "SNOWBALL";
            case "STRIDER" -> "STRIDER_SPAWN_EGG";
            case "TADPOLE" -> "FROGSPAWN";
            case "ENDERMAN" -> "ENDER_PEARL";
            case "GUARDIAN" -> "PRISMARINE_SHARD";
            case "PILLAGER" -> "CROSSBOW";
            case "SKELETON" -> "BONE";
            case "VILLAGER" -> "EMERALD";
            case "ENDERMITE" -> "ENDERMITE_SPAWN_EGG";
            case "GLOW_SQUID" -> "GLOW_INK_SAC";
            case "ILLUSIONER" -> "ENDER_EYE";
            case "IRON_GOLEM" -> "IRON_BLOCK";
            case "MAGMA_CUBE" -> "MAGMA_CREAM";
            case "POLAR_BEAR" -> "POLAR_BEAR_SPAWN_EGG";
            case "PUFFERFISH" -> "PUFFERFISH";
            case "VINDICATOR" -> "IRON_AXE";
            case "SILVERFISH" -> "STONE_BRICKS";
            case "CAVE_SPIDER" -> "COBWEB";
            case "ENDER_DRAGON" -> "DRAGON_EGG";
            case "MUSHROOM_COW" -> "RED_MUSHROOM";
            case "PIGLIN_BRUTE" -> "GOLDEN_AXE";
            case "ZOMBIE_HORSE" -> "ZOMBIE_HORSE_SPAWN_EGG";
            case "TROPICAL_FISH" -> "TROPICAL_FISH";
            case "ELDER_GUARDIAN" -> "PRISMARINE_CRYSTALS";
            case "WITHER_SKELETON" -> "WITHER_SKELETON_SKULL";
            case "TRADER_LLAMA" -> "TRADER_LLAMA_SPAWN_EGG";
            case "SKELETON_HORSE" -> "SKELETON_HORSE_SPAWN_EGG";
            case "ZOMBIE_VILLAGER" -> "ZOMBIE_VILLAGER_SPAWN_EGG";
            case "ZOMBIFIED_PIGLIN" -> "GOLD_NUGGET";
            case "WANDERING_TRADER" -> "WANDERING_TRADER_SPAWN_EGG";
            default -> "STRUCTURE_VOID";
        };
    }

    static {
        for (EntityType type : EntityType.values()) {
            if (EntityClassification.matchesClassification(type, EntityClassification.UNALIVE)) continue;
            entityIconMapping.put(type, ItemUtils.stringToMaterial(EntityLootTables.getEntityIcon(type.toString()), Material.STRUCTURE_VOID));
        }
    }
}

