/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.gui.implementations.recipecategories;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import me.athlaeos.valhallammo.commands.valhallasubcommands.ExportCommand;
import me.athlaeos.valhallammo.crafting.CustomRecipeRegistry;
import me.athlaeos.valhallammo.crafting.blockvalidations.Validation;
import me.athlaeos.valhallammo.crafting.blockvalidations.ValidationRegistry;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.SlotEntry;
import me.athlaeos.valhallammo.crafting.recipetypes.DynamicCookingRecipe;
import me.athlaeos.valhallammo.gui.PlayerMenuUtilManager;
import me.athlaeos.valhallammo.gui.implementations.CookingRecipeEditor;
import me.athlaeos.valhallammo.gui.implementations.RecipeOverviewMenu;
import me.athlaeos.valhallammo.gui.implementations.recipecategories.RecipeCategory;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.StringUtils;
import me.athlaeos.valhallammo.version.ConventionUtils;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;

public abstract class CookingRecipeCategory
extends RecipeCategory {
    private final DynamicCookingRecipe.CookingRecipeType type;

    public CookingRecipeCategory(String id, ItemStack icon, int position, String title, DynamicCookingRecipe.CookingRecipeType type) {
        super(id, icon, position, title);
        this.type = type;
    }

    @Override
    public List<ItemStack> getRecipeButtons() {
        ArrayList<ItemStack> icons = new ArrayList<ItemStack>();
        for (DynamicCookingRecipe recipe : CustomRecipeRegistry.getCookingRecipes().values()) {
            String[] stringArray;
            if (recipe.getType() != this.type) continue;
            ArrayList<String> lore = new ArrayList<String>(List.of("&f" + SlotEntry.toString(recipe.getInput()) + " >> &e" + StringUtils.toTimeStamp2(recipe.getCookTime(), 20L) + "s &f>> " + (recipe.tinker() ? "&eTinkered Input" : ItemUtils.getItemName(new ItemBuilder(recipe.getResult()))), recipe.getExperience() > 0.0f ? "&aRewards " + recipe.getExperience() + " experience" : "&aRewards no experience", recipe.requireValhallaTools() ? "&fRequires ValhallaMMO equipment" : "&fVanilla equipment may be used", recipe.isUnlockedForEveryone() ? "&aAccessible to anyone" : "&aNeeds to be unlocked to craft", "&8&m                <>                "));
            if (!recipe.getValidations().isEmpty()) {
                lore.add("&8&m                <>                ");
                for (String v : recipe.getValidations()) {
                    Validation validation = ValidationRegistry.getValidation(v);
                    lore.add(validation.activeDescription());
                }
            } else {
                lore.add("&fNo special conditions required");
            }
            lore.add("&8&m                <>                ");
            if (recipe.getModifiers().isEmpty()) {
                lore.add("&aNo modifiers executed");
            }
            recipe.getModifiers().forEach(m -> lore.addAll(StringUtils.separateStringIntoLines(m.getActiveDescription(), 40)));
            ItemBuilder itemBuilder = new ItemBuilder(recipe.tinker() ? recipe.getInput().getItem() : recipe.getResult()).name("&f" + recipe.getName()).lore(lore);
            if (ExportCommand.isPrepared(recipe.getName())) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "&aPrepared for export";
                stringArray = stringArray2;
                stringArray2[1] = "";
            } else {
                stringArray = new String[]{};
            }
            icons.add(itemBuilder.prependLore(stringArray).flag(ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ENCHANTS, ConventionUtils.getHidePotionEffectsFlag(), ItemFlag.HIDE_DYE).color(Color.fromRGB((int)210, (int)60, (int)200)).stringTag(RecipeOverviewMenu.KEY_RECIPE, recipe.getName()).get());
        }
        icons.sort(Comparator.comparing(ItemStack::getType).thenComparing(item -> ChatColor.stripColor((String)ItemUtils.getItemName(new ItemBuilder((ItemStack)item)))));
        return icons;
    }

    @Override
    public void onRecipeButtonClick(String recipeName, Player editor) {
        DynamicCookingRecipe recipe = CustomRecipeRegistry.getCookingRecipes().get(recipeName);
        if (recipe == null) {
            throw new IllegalArgumentException("Cooking recipe of this name does not exist");
        }
        new CookingRecipeEditor(PlayerMenuUtilManager.getPlayerMenuUtility(editor), recipe).open();
    }
}

