/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.gui.implementations.recipecategories;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.commands.valhallasubcommands.ExportCommand;
import me.athlaeos.valhallammo.crafting.CustomRecipeRegistry;
import me.athlaeos.valhallammo.crafting.blockvalidations.Validation;
import me.athlaeos.valhallammo.crafting.blockvalidations.ValidationRegistry;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.SlotEntry;
import me.athlaeos.valhallammo.crafting.recipetypes.ImmersiveCraftingRecipe;
import me.athlaeos.valhallammo.gui.PlayerMenuUtilManager;
import me.athlaeos.valhallammo.gui.implementations.ImmersiveRecipeEditor;
import me.athlaeos.valhallammo.gui.implementations.RecipeOverviewMenu;
import me.athlaeos.valhallammo.gui.implementations.recipecategories.RecipeCategory;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.StringUtils;
import me.athlaeos.valhallammo.utility.Utils;
import me.athlaeos.valhallammo.version.ConventionUtils;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;

public class ImmersiveRecipeCategory
extends RecipeCategory {
    public ImmersiveRecipeCategory(int position) {
        super("immersive", new ItemBuilder(Material.ANVIL).name("&eImmersive Crafting Recipes &7(&6" + CustomRecipeRegistry.getImmersiveRecipes().size() + "&7)").lore("&fClick to access all &eImmersive crafting recipes").get(), position, Utils.chat(ValhallaMMO.isResourcePackConfigForced() ? "&f\uf808\uf30b\uf80c\uf80a\uf808\uf802" : TranslationManager.getTranslation("editormenu_recipecategory_immersive")));
    }

    @Override
    public List<ItemStack> getRecipeButtons() {
        ArrayList<ItemStack> icons = new ArrayList<ItemStack>();
        for (ImmersiveCraftingRecipe recipe : CustomRecipeRegistry.getImmersiveRecipes().values()) {
            String[] stringArray;
            ArrayList<String> lore = new ArrayList<String>();
            if (!recipe.getIngredients().isEmpty()) {
                for (ItemStack entry : recipe.getIngredients().keySet()) {
                    int amount = recipe.getIngredients().get(entry);
                    lore.add("&e" + amount + "&7x &e" + recipe.getMetaRequirement().getChoice().ingredientDescription(entry));
                }
            } else {
                lore.add("&eRecipe is crafted for free");
            }
            lore.add("&eCrafted on &f" + recipe.getBlock() + (recipe.destroysStation() ? "&e which is destroyed afterwards" : ""));
            if (recipe.tinker()) {
                lore.add("&fHolding " + SlotEntry.toString(recipe.getTinkerInput()) + " for " + StringUtils.toTimeStamp2(recipe.getTimeToCraft(), 20L) + "s upgrades it");
            } else {
                lore.add("&fProduces " + ItemUtils.getItemName(new ItemBuilder(recipe.getResult())) + " after " + StringUtils.toTimeStamp2(recipe.getTimeToCraft(), 20L) + "s");
            }
            if (recipe.destroysStation()) {
                lore.add("&eDestroys the crafting station afterwards");
            }
            if (recipe.destroysStation()) {
                lore.add("&fCan be crafted " + recipe.getConsecutiveCrafts() + " times before resetting");
            }
            lore.add("&8&m                <>                ");
            lore.add(recipe.requiresValhallaTools() ? "&fRequires ValhallaMMO equipment" : "&fVanilla equipment may be used");
            lore.add(recipe.isUnlockedForEveryone() ? "&aAccessible to anyone" : "&aNeeds to be unlocked to craft");
            if (!recipe.getValidations().isEmpty()) {
                lore.add("&8&m                <>                ");
                for (String v : recipe.getValidations()) {
                    Validation validation = ValidationRegistry.getValidation(v);
                    lore.add(validation.activeDescription());
                }
            } else {
                lore.add("&fNo special conditions required");
            }
            lore.add("&8&m                <>                ");
            recipe.getModifiers().forEach(m -> lore.addAll(StringUtils.separateStringIntoLines(m.getActiveDescription(), 40)));
            ItemBuilder itemBuilder = new ItemBuilder(recipe.tinker() ? recipe.getTinkerInput().getItem() : recipe.getResult()).name("&f" + recipe.getName()).lore(lore);
            if (ExportCommand.isPrepared(recipe.getName())) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "&aPrepared for export";
                stringArray = stringArray2;
                stringArray2[1] = "";
            } else {
                stringArray = new String[]{};
            }
            icons.add(itemBuilder.prependLore(stringArray).flag(ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ENCHANTS, ConventionUtils.getHidePotionEffectsFlag(), ItemFlag.HIDE_DYE).stringTag(RecipeOverviewMenu.KEY_RECIPE, recipe.getName()).get());
        }
        icons.sort(Comparator.comparing(ItemStack::getType).thenComparing(item -> ChatColor.stripColor((String)ItemUtils.getItemName(new ItemBuilder((ItemStack)item)))));
        return icons;
    }

    @Override
    public void onRecipeButtonClick(String recipeName, Player editor) {
        ImmersiveCraftingRecipe recipe = CustomRecipeRegistry.getImmersiveRecipes().get(recipeName);
        if (recipe == null) {
            throw new IllegalArgumentException("Immersive recipe of this name does not exist");
        }
        new ImmersiveRecipeEditor(PlayerMenuUtilManager.getPlayerMenuUtility(editor), recipe).open();
    }

    @Override
    public void createNew(String name, Player editor) {
        new ImmersiveRecipeEditor(PlayerMenuUtilManager.getPlayerMenuUtility(editor), new ImmersiveCraftingRecipe(name)).open();
    }
}

