/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.item;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.StringUtils;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public enum MaterialClass {
    WOOD("wood_equipment", "WOODEN_PICKAXE", "WOODEN_AXE", "WOODEN_HOE", "WOODEN_SHOVEL", "WOODEN_SWORD", "WOODEN_SPEAR", "FISHING_ROD", "CARROT_ON_A_STICK", "WARPED_FUNGUS_ON_A_STICK"),
    BOW("material_bow", "BOW"),
    CROSSBOW("material_crossbow", "CROSSBOW"),
    LEATHER("leather_equipment", "LEATHER_BOOTS", "LEATHER_CHESTPLATE", "LEATHER_HELMET", "LEATHER_LEGGINGS"),
    STONE("stone_equipment", "STONE_PICKAXE", "STONE_AXE", "STONE_HOE", "STONE_SHOVEL", "STONE_SWORD", "STONE_SPEAR"),
    COPPER("copper_equipment", "COPPER_PICKAXE", "COPPER_AXE", "COPPER_HOE", "COPPER_SHOVEL", "COPPER_SWORD", "COPPER_SPEAR", "COPPER_HELMET", "COPPER_CHESTPLATE", "COPPER_LEGGINGS", "COPPER_BOOTS"),
    CHAINMAIL("chainmail_equipment", "CHAINMAIL_BOOTS", "CHAINMAIL_CHESTPLATE", "CHAINMAIL_HELMET", "CHAINMAIL_LEGGINGS"),
    GOLD("gold_equipment", "GOLDEN_PICKAXE", "GOLDEN_SHOVEL", "GOLDEN_HOE", "GOLDEN_AXE", "GOLDEN_SWORD", "GOLDEN_SPEAR", "GOLDEN_BOOTS", "GOLDEN_HELMET", "GOLDEN_CHESTPLATE", "GOLDEN_LEGGINGS"),
    IRON("iron_equipment", "IRON_PICKAXE", "IRON_SHOVEL", "IRON_HOE", "IRON_AXE", "IRON_SWORD", "IRON_SPEAR", "IRON_BOOTS", "IRON_HELMET", "IRON_CHESTPLATE", "IRON_LEGGINGS", "SHIELD", "FLINT_AND_STEEL", "SHEARS"),
    DIAMOND("diamond_equipment", "DIAMOND_PICKAXE", "DIAMOND_SHOVEL", "DIAMOND_HOE", "DIAMOND_AXE", "DIAMOND_SWORD", "DIAMOND_SPEAR", "DIAMOND_BOOTS", "DIAMOND_HELMET", "DIAMOND_CHESTPLATE", "DIAMOND_LEGGINGS"),
    NETHERITE("netherite_equipment", "NETHERITE_PICKAXE", "NETHERITE_SHOVEL", "NETHERITE_HOE", "NETHERITE_AXE", "NETHERITE_SWORD", "NETHERITE_SPEAR", "NETHERITE_BOOTS", "NETHERITE_HELMET", "NETHERITE_CHESTPLATE", "NETHERITE_LEGGINGS"),
    PRISMARINE("prismarine_equipment", "TRIDENT"),
    ENDERIC("enderic_equipment", new String[0]),
    CUSTOM_1("custom_1_equipment", new String[0]),
    CUSTOM_2("custom_2_equipment", new String[0]),
    CUSTOM_3("custom_3_equipment", new String[0]),
    CUSTOM_4("custom_4_equipment", new String[0]),
    CUSTOM_5("custom_5_equipment", new String[0]),
    CUSTOM_6("custom_6_equipment", new String[0]),
    CUSTOM_7("custom_7_equipment", new String[0]),
    CUSTOM_8("custom_8_equipment", new String[0]),
    CUSTOM_9("custom_9_equipment", new String[0]),
    CUSTOM_10("custom_10_equipment", new String[0]),
    OTHER("other_materials", "MACE");

    private final Tag<Material> matchingMaterials;
    private static final NamespacedKey materialTypeKey;

    private MaterialClass(final String key, String ... matchingMaterials) {
        final HashSet<Material> tagged = new HashSet<Material>(ItemUtils.getMaterialSet(matchingMaterials));
        this.matchingMaterials = new Tag<Material>(this){
            private final NamespacedKey k;
            final /* synthetic */ MaterialClass this$0;
            {
                this.this$0 = this$0;
                this.k = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "tag_" + key);
            }

            public boolean isTagged(@NotNull Material material) {
                return tagged.contains(material);
            }

            @NotNull
            public Set<Material> getValues() {
                return tagged;
            }

            @NotNull
            public NamespacedKey getKey() {
                return this.k;
            }
        };
    }

    public Tag<Material> getTag() {
        return this.matchingMaterials;
    }

    public Collection<Material> getMatchingMaterials() {
        return this.matchingMaterials.getValues();
    }

    public static MaterialClass getMatchingClass(ItemMeta meta) {
        if (meta == null) {
            return null;
        }
        Material base = ItemUtils.getStoredType(meta);
        String value = (String)meta.getPersistentDataContainer().getOrDefault(materialTypeKey, PersistentDataType.STRING, (Object)"");
        if (!StringUtils.isEmpty(value)) {
            try {
                return MaterialClass.valueOf(value);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (base != null) {
            for (MaterialClass type : MaterialClass.values()) {
                if (!type.getMatchingMaterials().contains(base)) continue;
                return type;
            }
        }
        return null;
    }

    public static MaterialClass getMatchingClass(Material base) {
        if (base != null) {
            for (MaterialClass type : MaterialClass.values()) {
                if (!type.getMatchingMaterials().contains(base)) continue;
                return type;
            }
        }
        return null;
    }

    public static void setMaterialType(ItemMeta meta, MaterialClass type) {
        if (type == null) {
            meta.getPersistentDataContainer().remove(materialTypeKey);
        } else {
            meta.getPersistentDataContainer().set(materialTypeKey, PersistentDataType.STRING, (Object)type.toString());
        }
    }

    static {
        materialTypeKey = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "material_type");
    }
}

