/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.item.throwable_weapon_animations;

import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.item.ItemAttributesRegistry;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.item.item_attributes.AttributeWrapper;
import me.athlaeos.valhallammo.item.throwable_weapon_animations.ThrowableItemStats;
import me.athlaeos.valhallammo.item.throwable_weapon_animations.ThrowableWeaponAnimation;
import me.athlaeos.valhallammo.item.throwable_weapon_animations.ThrowableWeaponAnimationRegistry;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.MathUtils;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class ThrownItem {
    private static final NamespacedKey THROWN_WEAPON = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "thrown_weapon");
    private final ArmorStand stand;
    private final BukkitRunnable runnable;
    private final ItemBuilder item;
    private final ThrowableItemStats stats;
    private final EquipmentSlot hand;
    private final Player thrower;
    private Vector direction;
    private Vector gravity;
    private final Location location;
    private int piercingLeft;
    private final Collection<UUID> hitEntities = new HashSet<UUID>();
    private int tick = 0;
    private boolean returning = false;
    private final ItemStack rawThrown;
    private static final double GRAVITY = 9.81;

    public static UUID getThrownBy(ArmorStand a) {
        String value = (String)a.getPersistentDataContainer().get(THROWN_WEAPON, PersistentDataType.STRING);
        if (value == null) {
            return null;
        }
        return UUID.fromString(value);
    }

    public ThrownItem(Player thrower, EquipmentSlot hand, ItemBuilder item, final ThrowableWeaponAnimation animation) {
        AttributeWrapper speedWrapper;
        this.thrower = thrower;
        this.stats = ThrowableWeaponAnimationRegistry.getItemStats(item.getMeta());
        this.hand = hand;
        this.item = item.amount(1);
        this.rawThrown = item.get();
        this.gravity = new Vector(0.0, -9.81 * this.stats.getGravityStrength(), 0.0);
        this.location = thrower.getLocation().add(MathUtils.getHandOffset(thrower, hand == EquipmentSlot.HAND));
        this.location.setPitch(0.0f);
        this.location.setYaw(thrower.getEyeLocation().getYaw() + 90.0f);
        this.direction = thrower.getEyeLocation().getDirection().multiply(this.stats.getDefaultVelocity());
        AttributeWrapper piercing = ItemAttributesRegistry.getAttribute(item.getMeta(), "ARROW_PIERCING", false);
        if (piercing != null) {
            this.piercingLeft = Math.max(0, (int)piercing.getValue());
        }
        if ((speedWrapper = ItemAttributesRegistry.getAttribute(item.getMeta(), "ARROW_VELOCITY", false)) != null) {
            this.direction = this.direction.multiply(1.0 + speedWrapper.getValue());
        }
        this.stand = (ArmorStand)thrower.getWorld().spawn(this.location, ArmorStand.class);
        if (this.stand.getEquipment() == null) {
            this.stand.remove();
            this.runnable = null;
            return;
        }
        ThrowableWeaponAnimationRegistry.setStats(this.stand.getPersistentDataContainer(), this.stats);
        this.stand.getPersistentDataContainer().set(THROWN_WEAPON, PersistentDataType.STRING, (Object)thrower.getUniqueId().toString());
        this.stand.setGravity(false);
        this.stand.setInvulnerable(true);
        this.stand.setInvisible(true);
        this.stand.setCollidable(false);
        this.stand.setMarker(false);
        this.stand.setAI(false);
        this.stand.getEquipment().setHelmet(item.get());
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            this.stand.addEquipmentLock(slot, ArmorStand.LockType.REMOVING_OR_CHANGING);
            this.stand.addEquipmentLock(slot, ArmorStand.LockType.ADDING);
        }
        final ThrownItem instance = this;
        this.runnable = new BukkitRunnable(this){
            final /* synthetic */ ThrownItem this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                animation.tick(instance);
            }
        };
        this.runnable.runTaskTimer((Plugin)ValhallaMMO.getInstance(), 0L, 1L);
    }

    public void incrementTick() {
        ++this.tick;
    }

    public int getTick() {
        return this.tick;
    }

    public ArmorStand getStand() {
        return this.stand;
    }

    public Collection<UUID> getHitEntities() {
        return this.hitEntities;
    }

    public EquipmentSlot getHand() {
        return this.hand;
    }

    public int getPiercingLeft() {
        return this.piercingLeft;
    }

    public ItemBuilder getItem() {
        return this.item;
    }

    public ItemStack getRawThrown() {
        return this.rawThrown;
    }

    public Location getLocation() {
        return this.location;
    }

    public Player getThrower() {
        return this.thrower;
    }

    public ThrowableItemStats getStats() {
        return this.stats;
    }

    public Vector getDirection() {
        return this.direction;
    }

    public Vector getGravity() {
        return this.gravity;
    }

    public boolean isReturning() {
        return this.returning;
    }

    public void setDirection(Vector direction) {
        this.direction = direction;
    }

    public void setGravity(Vector gravity) {
        this.gravity = gravity;
    }

    public void setPiercingLeft(int piercingLeft) {
        this.piercingLeft = piercingLeft;
    }

    public void setReturning(boolean returning) {
        this.returning = returning;
    }

    public void stop() {
        this.runnable.cancel();
        this.stand.remove();
    }

    public void drop() {
        if (this.stand.getEquipment() == null || ItemUtils.isEmpty(this.stand.getEquipment().getHelmet())) {
            return;
        }
        if (!this.stats.isInfinity()) {
            this.stand.getWorld().dropItem(this.stand.getEyeLocation(), this.stand.getEquipment().getHelmet());
        }
        this.stop();
    }
}

