/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.listeners;

import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.entities.EntityAttributeStats;
import me.athlaeos.valhallammo.gui.PlayerMenuUtilManager;
import me.athlaeos.valhallammo.playerstats.EntityCache;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileRegistry;
import me.athlaeos.valhallammo.potioneffects.PotionEffectRegistry;
import me.athlaeos.valhallammo.skills.perk_rewards.implementations.FlightReward;
import me.athlaeos.valhallammo.utility.GlobalEffect;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class JoinLeaveListener
implements Listener {
    private final NamespacedKey HEALTH = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "cached_health");
    private static final Collection<UUID> loadedProfiles = new HashSet<UUID>();

    public static Collection<UUID> getLoadedProfiles() {
        return loadedProfiles;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerJoin(PlayerJoinEvent e) {
        AttributeInstance maxHealth;
        Player player = e.getPlayer();
        EntityCache.getAndCacheProperties((LivingEntity)player);
        PotionEffectRegistry.updatePlayerAffectedStatus(player);
        ProfileRegistry.getPersistence().requestProfile(player.getUniqueId());
        GlobalEffect.temporarilyRevealBossBar(player);
        PlayerMenuUtilManager.removePlayerMenuUtility(player.getUniqueId());
        double health = (Double)player.getPersistentDataContainer().getOrDefault(this.HEALTH, PersistentDataType.DOUBLE, (Object)-1.0);
        if (health > 0.0 && (maxHealth = player.getAttribute(Attribute.GENERIC_MAX_HEALTH)) != null) {
            if (maxHealth.getValue() < health) {
                health = maxHealth.getValue();
            }
            player.setHealth(health);
        }
        ValhallaMMO.getInstance().getServer().getScheduler().runTaskLater((Plugin)ValhallaMMO.getInstance(), () -> {
            EntityAttributeStats.updateStats((LivingEntity)player);
            FlightReward.setFlight(player, true);
        }, 40L);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerQuit(PlayerQuitEvent e) {
        Player player = e.getPlayer();
        player.getPersistentDataContainer().set(this.HEALTH, PersistentDataType.DOUBLE, (Object)player.getHealth());
        EntityAttributeStats.removeStats((LivingEntity)player);
        PotionEffectRegistry.markAsUnaffected((LivingEntity)player);
        ProfileRegistry.getPersistence().saveProfile(player.getUniqueId(), true);
        FlightReward.setFlight(player, false);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onDimensionChange(PlayerChangedWorldEvent e) {
        FlightReward.setFlight(e.getPlayer(), true);
    }
}

