/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.listeners;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.animations.Animation;
import me.athlaeos.valhallammo.animations.AnimationRegistry;
import me.athlaeos.valhallammo.dom.MinecraftVersion;
import me.athlaeos.valhallammo.event.PlayerJumpEvent;
import me.athlaeos.valhallammo.hooks.WorldGuardHook;
import me.athlaeos.valhallammo.playerstats.AccumulativeStatManager;
import me.athlaeos.valhallammo.utility.MathUtils;
import me.athlaeos.valhallammo.version.AttributeMappings;
import me.athlaeos.valhallammo.version.PotionEffectMappings;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.util.Vector;

public class JumpListener
implements Listener {
    private static Animation multiJumpAnimation = AnimationRegistry.MULTI_JUMP;
    private static final Collection<UUID> playersGivenFlight = new HashSet<UUID>();
    private final Map<UUID, Integer> jumpsLeft = new HashMap<UUID, Integer>();
    private final Attribute jumpHeightAttribute = AttributeMappings.JUMP_STRENGTH.getAttribute();

    public static void setMultiJumpAnimation(Animation multiJumpAnimation) {
        JumpListener.multiJumpAnimation = multiJumpAnimation;
    }

    public static Animation getMultiJumpAnimation() {
        return multiJumpAnimation;
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerJump(PlayerJumpEvent e) {
        double jumpHeightBonus;
        if (ValhallaMMO.isWorldBlacklisted(e.getPlayer().getWorld().getName())) {
            return;
        }
        if (!MinecraftVersion.currentVersionNewerThan(MinecraftVersion.MINECRAFT_1_20_5) && (jumpHeightBonus = AccumulativeStatManager.getCachedStats("JUMP_HEIGHT_MULTIPLIER", (Entity)e.getPlayer(), 10000L, true)) > 0.0) {
            e.getPlayer().setVelocity(e.getPlayer().getVelocity().add(new Vector(0.0, jumpHeightBonus * 0.15, 0.0)));
        }
        if (e.getPlayer().getAllowFlight()) {
            return;
        }
        int extraJumps = (int)AccumulativeStatManager.getCachedStats("JUMPS_BONUS", (Entity)e.getPlayer(), 10000L, true);
        if (extraJumps <= 0) {
            return;
        }
        this.jumpsLeft.put(e.getPlayer().getUniqueId(), extraJumps);
        playersGivenFlight.add(e.getPlayer().getUniqueId());
        e.getPlayer().setAllowFlight(true);
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent e) {
        int extraJumps;
        if (ValhallaMMO.isWorldBlacklisted(e.getPlayer().getWorld().getName()) || e.getPlayer().getGameMode() == GameMode.SPECTATOR || e.getPlayer().getGameMode() == GameMode.CREATIVE) {
            return;
        }
        if (!playersGivenFlight.contains(e.getPlayer().getUniqueId()) && !this.jumpsLeft.containsKey(e.getPlayer().getUniqueId()) && (extraJumps = (int)AccumulativeStatManager.getCachedStats("JUMPS_BONUS", (Entity)e.getPlayer(), 10000L, true)) > 0) {
            this.jumpsLeft.put(e.getPlayer().getUniqueId(), extraJumps);
            playersGivenFlight.add(e.getPlayer().getUniqueId());
            e.getPlayer().setAllowFlight(true);
        }
        if (!playersGivenFlight.contains(e.getPlayer().getUniqueId())) {
            return;
        }
        if (!e.getPlayer().getLocation().add(0.0, -0.1, 0.0).getBlock().getType().isSolid()) {
            return;
        }
        playersGivenFlight.remove(e.getPlayer().getUniqueId());
        e.getPlayer().setAllowFlight(false);
        this.jumpsLeft.remove(e.getPlayer().getUniqueId());
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onFallDamage(EntityDamageEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getEntity().getWorld().getName()) || e.getCause() != EntityDamageEvent.DamageCause.FALL) {
            return;
        }
        double jumpHeightBonus = AccumulativeStatManager.getCachedStats("JUMP_HEIGHT_MULTIPLIER", e.getEntity(), 10000L, true);
        if (jumpHeightBonus == 0.0) {
            return;
        }
        double fallDamage = Math.max(0.0, (double)(e.getEntity().getFallDistance() - 3.0f) - jumpHeightBonus);
        if (e.getEntity().getLocation().subtract(0.0, 0.2, 0.0).getBlock().getType() == Material.POINTED_DRIPSTONE) {
            fallDamage *= 2.0;
        }
        e.setDamage(fallDamage);
    }

    @EventHandler(ignoreCancelled=true)
    public void onToggleFlight(PlayerToggleFlightEvent e) {
        int remainingJumps;
        if (ValhallaMMO.isWorldBlacklisted(e.getPlayer().getWorld().getName()) || !playersGivenFlight.contains(e.getPlayer().getUniqueId()) || e.getPlayer().getGameMode() == GameMode.CREATIVE || e.getPlayer().getGameMode() == GameMode.SPECTATOR) {
            return;
        }
        e.setCancelled(true);
        double jumpHeightBonus = 0.0;
        if (this.jumpHeightAttribute == null) {
            jumpHeightBonus = MinecraftVersion.currentVersionNewerThan(MinecraftVersion.MINECRAFT_1_20_5) ? 0.0 : AccumulativeStatManager.getCachedStats("JUMP_HEIGHT_MULTIPLIER", (Entity)e.getPlayer(), 10000L, true);
        } else {
            AttributeInstance instance = e.getPlayer().getAttribute(this.jumpHeightAttribute);
            if (instance != null) {
                jumpHeightBonus = instance.getValue();
            }
        }
        if (!WorldGuardHook.inDisabledRegion(e.getPlayer().getLocation(), e.getPlayer(), "vmmo-double-jumping")) {
            PotionEffect jumpEffect = e.getPlayer().getPotionEffect(PotionEffectMappings.JUMP_BOOST.getPotionEffectType());
            double jumpLevel = 0.0;
            if (jumpEffect != null) {
                jumpLevel = jumpEffect.getAmplifier() + 1;
            }
            float f = e.getPlayer().getEyeLocation().getYaw() * ((float)Math.PI / 180);
            double motionX = e.getPlayer().getVelocity().getX() - (e.getPlayer().isSprinting() ? MathUtils.sin(f) * 0.2 : 0.0);
            double motionY = 0.42 + (jumpLevel += 2.0 * jumpHeightBonus) * (double)0.1f;
            double motionZ = e.getPlayer().getVelocity().getZ() + (e.getPlayer().isSprinting() ? MathUtils.cos(f) * 0.2 : 0.0);
            if (multiJumpAnimation != null) {
                multiJumpAnimation.animate((LivingEntity)e.getPlayer(), e.getPlayer().getLocation(), e.getPlayer().getEyeLocation().getDirection(), 0);
            }
            ValhallaMMO.getInstance().getServer().getScheduler().runTaskLater((Plugin)ValhallaMMO.getInstance(), () -> e.getPlayer().setVelocity(new Vector(motionX, motionY, motionZ)), 1L);
            e.getPlayer().setFallDistance(0.0f);
        }
        if ((remainingJumps = this.jumpsLeft.getOrDefault(e.getPlayer().getUniqueId(), 0) - 1) <= 0) {
            e.getPlayer().setAllowFlight(false);
            playersGivenFlight.remove(e.getPlayer().getUniqueId());
        } else {
            this.jumpsLeft.put(e.getPlayer().getUniqueId(), remainingJumps);
        }
    }

    @EventHandler
    public void onLeave(PlayerQuitEvent e) {
        if (playersGivenFlight.contains(e.getPlayer().getUniqueId())) {
            e.getPlayer().setAllowFlight(false);
        }
    }

    public static void onServerStop() {
        for (Player p : ValhallaMMO.getInstance().getServer().getOnlinePlayers()) {
            if (!playersGivenFlight.contains(p.getUniqueId())) continue;
            p.setAllowFlight(false);
        }
    }
}

